/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards.targetpanel.providers;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.netbeans.modules.target.iterator.api.TargetChooserPanel;
import org.netbeans.modules.target.iterator.api.TargetChooserPanelGUI;
import org.netbeans.modules.target.iterator.spi.TargetPanelUIManager;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.targetpanel.providers.TagLibTargetPanelProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

class TagLibUIManager
implements TargetPanelUIManager<FileType> {
    private static final String TLD_IN_JAVALIB_FOLDER = "META-INF";
    private static final String TLD_FOLDER = "tlds";
    private JTextField myUriTextField;
    private JTextField myPrefixTextField;
    private JLabel myUriLabel;
    private JLabel myPrefixLabel;
    private boolean myUriWasTyped;
    private boolean myPrefixWasTyped;
    private WebModule myWebModule;

    TagLibUIManager() {
    }

    public void initValues(TargetChooserPanel<FileType> targetChooserPanel, TargetChooserPanelGUI<FileType> targetChooserPanelGUI) {
        if (targetChooserPanel.getSourceGroups() != null && targetChooserPanel.getSourceGroups().length > 0) {
            this.myWebModule = WebModule.getWebModule((FileObject)targetChooserPanel.getSourceGroups()[0].getRootFolder());
        }
    }

    public void changeUpdate(DocumentEvent documentEvent, TargetChooserPanel<FileType> targetChooserPanel) {
        if (!this.myUriWasTyped) {
            String string = targetChooserPanel.getComponent().getNormalizedFolder();
            if (this.getWebModule() == null) {
                String string2 = this.getPackageNameInMetaInf(targetChooserPanel);
                this.myUriTextField.setText((string2.length() > 0 ? string2 + "." : "") + targetChooserPanel.getComponent().getDocumentName());
            } else {
                String string3 = targetChooserPanel.getComponent().getSelectedFolder();
                if ("WEB-INF".equals(string3)) {
                    this.myUriTextField.setText("/" + string3 + (string.length() == 0 ? "" : "/" + string) + "/" + targetChooserPanel.getComponent().getDocumentName());
                } else {
                    this.myUriTextField.setText((string.length() == 0 ? "" : "/" + string) + "/" + targetChooserPanel.getComponent().getDocumentName());
                }
            }
        }
        if (!this.myPrefixWasTyped) {
            this.myPrefixTextField.setText(targetChooserPanel.getComponent().getDocumentName().toLowerCase());
        }
    }

    public String getAccessibleDescription() {
        return "tag_library";
    }

    public String getErrorMessage(TargetChooserPanel<FileType> targetChooserPanel) {
        if (this.getWebModule() == null) {
            if (!targetChooserPanel.getComponent().getNormalizedFolder().startsWith(TLD_IN_JAVALIB_FOLDER)) {
                return NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"NOTE_TLDInJavalib");
            }
        } else {
            boolean bl = targetChooserPanel.getComponent().getSelectedFolder().equals("WEB-INF");
            if (!targetChooserPanel.getComponent().getNormalizedFolder().startsWith("WEB-INF") && !bl) {
                return NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"NOTE_TLDInWeb");
            }
        }
        if (this.getUri().length() == 0) {
            return NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"MSG_missingUri");
        }
        if (this.getPrefix().length() == 0) {
            return NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"MSG_missingPrefix");
        }
        return null;
    }

    public JPanel getOptionPanel() {
        return null;
    }

    public void initComponents(JPanel jPanel, final TargetChooserPanel<FileType> targetChooserPanel, final TargetChooserPanelGUI<FileType> targetChooserPanelGUI) {
        this.myUriTextField = new JTextField();
        this.myUriTextField.setColumns(20);
        this.myPrefixTextField = new JTextField();
        this.myPrefixTextField.setColumns(5);
        this.myUriLabel = new JLabel(NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"LBL_URI"));
        this.myUriLabel.setToolTipText(NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"TTT_URI"));
        this.myUriLabel.setLabelFor(this.myUriTextField);
        this.myUriLabel.setDisplayedMnemonic(NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"A11Y_URI_mnem").charAt(0));
        this.myUriTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"A11Y_DESC_URI"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.myUriLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.myUriTextField, gridBagConstraints);
        this.myPrefixLabel = new JLabel(NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"LBL_Prefix"));
        this.myPrefixLabel.setLabelFor(this.myPrefixTextField);
        this.myPrefixLabel.setToolTipText(NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"TTT_prefix"));
        this.myPrefixLabel.setDisplayedMnemonic(NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"A11Y_Prefix_mnem").charAt(0));
        this.myPrefixTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"A11Y_DESC_Prefix"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.myPrefixLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        jPanel.add((Component)this.myPrefixTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 2.0;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        this.myUriTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                TagLibUIManager.this.myUriWasTyped = true;
                targetChooserPanel.fireChange();
            }
        });
        this.myPrefixTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                TagLibUIManager.this.myPrefixWasTyped = true;
                targetChooserPanel.fireChange();
            }
        });
        targetChooserPanelGUI.setNameLabel(NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"LBL_TldName"));
        targetChooserPanelGUI.addLocationListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                targetChooserPanelGUI.changedUpdate(null);
            }
        });
    }

    public void initFolderValue(TargetChooserPanel<FileType> targetChooserPanel, String string, JTextField jTextField) {
        if (string != null && !string.startsWith(TLD_IN_JAVALIB_FOLDER)) {
            string = null;
        }
        if (this.getWebModule() == null) {
            jTextField.setText("META-INF/");
        } else {
            jTextField.setText("tlds/");
        }
    }

    public boolean isPanelValid() {
        return this.getUri().length() != 0 && this.getPrefix().length() != 0;
    }

    protected WebModule getWebModule() {
        return this.myWebModule;
    }

    String getUri() {
        if (this.myUriTextField == null) {
            return "";
        }
        return this.myUriTextField.getText();
    }

    String getPrefix() {
        if (this.myPrefixTextField == null) {
            return "";
        }
        return this.myPrefixTextField.getText();
    }

    private String getPackageNameInMetaInf(TargetChooserPanel<FileType> targetChooserPanel) {
        String string = targetChooserPanel.getComponent().getRelativeTargetFolder();
        if (string.startsWith(TLD_IN_JAVALIB_FOLDER)) {
            if ((string = string.substring(8)).length() == 0) {
                return "";
            }
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
        }
        if (string.length() == 0) {
            return "";
        }
        string = string.replace('/', '.');
        return string;
    }
}

