/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.kenai;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.bugtracking.jira.JiraUpdater;
import org.netbeans.modules.bugtracking.kenai.QueryDescriptor;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.spi.QueryHandle;
import org.netbeans.modules.kenai.ui.spi.QueryResultHandle;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class FakeJiraSupport {
    private static final String JIRA_SUBSTRING = "kenai.com/jira/";
    private final String projectUrl;
    private final String createIssueUrl;
    private final String openIssueUrl;
    private static Map<String, FakeJiraSupport> supportedProjects = new HashMap<String, FakeJiraSupport>();
    private static List<QueryHandle> queryHandles;

    private FakeJiraSupport(String projectUrl, String createIssueUrl, String openIssueUrl) {
        this.projectUrl = projectUrl;
        this.createIssueUrl = createIssueUrl;
        this.openIssueUrl = openIssueUrl;
    }

    public static synchronized FakeJiraSupport get(ProjectHandle handle) {
        KenaiProject project = handle.getKenaiProject();
        if (project == null) {
            return null;
        }
        return FakeJiraSupport.get(project);
    }

    public static synchronized FakeJiraSupport get(KenaiProject project) {
        if (project == null) {
            return null;
        }
        FakeJiraSupport support = supportedProjects.get(project.getName());
        if (support != null) {
            return support;
        }
        String url = null;
        String createIssueUrl = null;
        String openIssueUrl = null;
        try {
            KenaiFeature[] features = project.getFeatures(KenaiService.Type.ISSUES);
            url = null;
            KenaiFeature[] arr$ = features;
            int len$ = arr$.length;
            int i$ = 0;
            if (i$ < len$) {
                KenaiFeature f = arr$[i$];
                if (!"jira".equals(f.getService())) {
                    return null;
                }
                url = f.getLocation();
            }
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
        }
        if (url == null) {
            return null;
        }
        int idx = url.indexOf(JIRA_SUBSTRING);
        if (idx > -1) {
            String urlBase = url.substring(0, idx + JIRA_SUBSTRING.length());
            createIssueUrl = urlBase + "secure/CreateIssue!default.jspa?pname=" + project.getName();
            openIssueUrl = urlBase + "browse/";
        }
        support = new FakeJiraSupport(url, createIssueUrl, openIssueUrl);
        supportedProjects.put(project.getName(), support);
        return support;
    }

    public ActionListener getCreateIssueListener() {
        return this.getJiraListener(this.createIssueUrl);
    }

    public ActionListener getOpenProjectListener() {
        return this.getJiraListener(this.projectUrl);
    }

    public String getIssueUrl(String issueID) {
        return this.openIssueUrl + issueID;
    }

    public QueryHandle getAllIssuesQuery() {
        List<QueryHandle> queries = this.getQueries();
        String allIssuesName = NbBundle.getMessage(FakeJiraSupport.class, (String)"LBL_AllIssues");
        for (QueryHandle queryHandle : queries) {
            if (!queryHandle.getDisplayName().equals(allIssuesName)) continue;
            return queryHandle;
        }
        return null;
    }

    public List<QueryHandle> getQueries() {
        if (queryHandles == null) {
            queryHandles = this.createQueryHandles();
        }
        return queryHandles;
    }

    private List<QueryHandle> createQueryHandles() {
        ArrayList<QueryHandle> l = new ArrayList<QueryHandle>(2);
        l.add(new FakeJiraQueryHandle(NbBundle.getMessage(FakeJiraSupport.class, (String)"LBL_MyIssues"), this.projectUrl));
        l.add(new FakeJiraQueryHandle(NbBundle.getMessage(FakeJiraSupport.class, (String)"LBL_AllIssues"), this.projectUrl));
        return l;
    }

    private ActionListener getJiraListener(final String urlString) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JiraUpdater.notifyJiraDownload((String)urlString)) {
                    JiraUpdater.getInstance().downloadAndInstall();
                }
            }
        };
    }

    public static class FakeJiraQueryResultHandle
    extends QueryResultHandle
    implements ActionListener {
        private final String label;
        private final QueryResultHandle.ResultType type;
        private final String projectUrl;

        public FakeJiraQueryResultHandle(String label, QueryResultHandle.ResultType type, String projectUrl) {
            this.label = label;
            this.type = type;
            this.projectUrl = projectUrl;
        }

        public String getText() {
            return this.label;
        }

        public String getToolTipText() {
            return NbBundle.getMessage(FakeJiraQueryHandle.class, (String)"LBL_NotAvailableTooltip");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JiraUpdater.notifyJiraDownload((String)this.projectUrl)) {
                JiraUpdater.getInstance().downloadAndInstall();
            }
        }

        public QueryResultHandle.ResultType getResultType() {
            return this.type;
        }
    }

    public static class FakeJiraQueryHandle
    extends QueryHandle
    implements QueryDescriptor,
    ActionListener {
        private final String displayName;
        private static List<QueryResultHandle> results;
        private final String projectUrl;
        private final String notAvailableResult;

        public FakeJiraQueryHandle(String displayName, String projectUrl) {
            this.displayName = displayName;
            this.projectUrl = projectUrl;
            this.notAvailableResult = NbBundle.getMessage(FakeJiraSupport.class, (String)"LBL_NotAvailable");
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JiraUpdater.notifyJiraDownload((String)this.projectUrl)) {
                JiraUpdater.getInstance().downloadAndInstall();
            }
        }

        public List<QueryResultHandle> getQueryResults() {
            if (results == null) {
                ArrayList<QueryResultHandle> r = new ArrayList<QueryResultHandle>(1);
                r.add(new FakeJiraQueryResultHandle(this.notAvailableResult, QueryResultHandle.ResultType.NAMED_RESULT, this.projectUrl));
                results = r;
            }
            return results;
        }

        public QueryResultHandle getUnseenResult() {
            return new FakeJiraQueryResultHandle(this.notAvailableResult, QueryResultHandle.ResultType.ALL_CHANGES_RESULT, this.projectUrl);
        }

        @Override
        public boolean isPredefined() {
            return true;
        }

        @Override
        public Query getQuery() {
            return null;
        }
    }
}

