/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.generic;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.modules.profiler.attach.providers.AbstractIntegrationProvider;
import org.netbeans.modules.profiler.attach.providers.IntegrationCategorizer;
import org.netbeans.modules.profiler.attach.spi.IntegrationProvider;
import org.netbeans.modules.profiler.attach.wizard.steps.NullWizardStep;
import org.netbeans.modules.profiler.attach.wizard.steps.WizardStep;

public class GenericWebAppServerIntegrationProvider
extends AbstractIntegrationProvider {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.modules.profiler.j2ee.generic.Bundle");
    private static final String GENERIC_WEBAPP_SERVER_STRING = messages.getString("GenericWebAppServerIntegrationProvider_GenericWebappServerString");
    private static final String PATH_TO_JDK_DIRECTORY_STRING = messages.getString("GenericWebAppServerIntegrationProvider_PathToJdkDirectory");
    private static final String MANUAL_REMOTE_STEP3_MESSAGE = messages.getString("GenericWebAppServerIntegrationProvider_ManualRemoteStep3Message");
    private static final String MANUAL_REMOTE_STEP4_MESSAGE = messages.getString("GenericWebAppServerIntegrationProvider_ManualRemoteStep4Message");
    private static final String MANUAL_REMOTE_STEP5_MESSAGE = messages.getString("GenericWebAppServerIntegrationProvider_ManualRemoteStep5Message");
    private static final String MANUAL_DIRECT_STEP1_MESSAGE = messages.getString("GenericWebAppServerIntegrationProvider_ManualDirectStep1Message");
    private static final String MANUAL_DIRECT_STEP2_MESSAGE = messages.getString("GenericWebAppServerIntegrationProvider_ManualDirectStep2Message");
    private static final String MANUAL_DIRECT_STEP3_MESSAGE = messages.getString("GenericWebAppServerIntegrationProvider_ManualDirectStep3Message");
    private static final String MANUAL_DYNAMIC_STEP1_MESSAGE = messages.getString("GenericWebAppServerIntegrationProvider_ManualDynamicStep1Message");
    private static final String MANUAL_DYNAMIC_STEP2_MESSAGE = messages.getString("GenericWebAppServerIntegrationProvider_ManualDynamicStep2Message");
    private static final String DYNAMIC_WARNING_MESSAGE = messages.getString("GenericWebAppServerIntegrationProvider_DynamicWarningMessage");
    private static final WizardStep NULL_WIZARD_STEP = new NullWizardStep();

    public IntegrationProvider.IntegrationHints getAfterInstallationHints(AttachSettings attachSettings, boolean b) {
        return new IntegrationProvider.IntegrationHints();
    }

    public WizardStep getAttachedWizard() {
        return NULL_WIZARD_STEP;
    }

    public IntegrationProvider.IntegrationHints getIntegrationReview(AttachSettings attachSettings) {
        return null;
    }

    public IntegrationProvider.IntegrationHints getModificationHints(AttachSettings attachSettings) {
        String targetOS = attachSettings.getHostOS();
        if (attachSettings.isRemote()) {
            return this.getManualRemoteIntegrationStepsInstructions(targetOS, attachSettings);
        }
        if (attachSettings.isDirect()) {
            return this.getManualLocalDirectIntegrationStepsInstructions(targetOS, attachSettings);
        }
        return this.getManualLocalDynamicIntegrationStepsInstructions(targetOS, attachSettings);
    }

    public String getTitle() {
        return GENERIC_WEBAPP_SERVER_STRING;
    }

    public void categorize(IntegrationCategorizer integrationCategorizer) {
        integrationCategorizer.addAppserver((IntegrationProvider)this, this.getAttachWizardPriority());
    }

    public void modify(AttachSettings attachSettings) {
    }

    public void run(AttachSettings attachSettings) {
    }

    public boolean supportsAutomation() {
        return false;
    }

    public boolean supportsDirect() {
        return true;
    }

    public boolean supportsDynamic() {
        return true;
    }

    public boolean supportsDynamicPid() {
        return true;
    }

    public boolean supportsLocal() {
        return true;
    }

    public boolean supportsManual() {
        return true;
    }

    public boolean supportsRemote() {
        return true;
    }

    protected int getAttachWizardPriority() {
        return 1;
    }

    private IntegrationProvider.IntegrationHints getManualLocalDirectIntegrationStepsInstructions(String targetOS, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints instructions = new IntegrationProvider.IntegrationHints();
        String pathToJDKDirectory = "&lt;" + MessageFormat.format(PATH_TO_JDK_DIRECTORY_STRING, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava())) + "&gt;";
        instructions.addStep(MessageFormat.format(MANUAL_DIRECT_STEP1_MESSAGE, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()), IntegrationUtils.getExportEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)pathToJDKDirectory, (boolean)true)));
        instructions.addStep(MessageFormat.format(MANUAL_DIRECT_STEP2_MESSAGE, IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort())));
        instructions.addStep(MANUAL_DIRECT_STEP3_MESSAGE);
        if (IntegrationUtils.isWindowsPlatform((String)targetOS)) {
            instructions.addWarning(this.SPACES_IN_PATH_WARNING_MSG);
        }
        instructions.addHint(this.REDUCE_OVERHEAD_MSG);
        if (!IntegrationUtils.isWindowsPlatform((String)targetOS)) {
            instructions.addHint(this.EXPORT_SETENV_MSG);
        }
        return instructions;
    }

    private IntegrationProvider.IntegrationHints getManualLocalDynamicIntegrationStepsInstructions(String targetOS, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints instructions = new IntegrationProvider.IntegrationHints();
        instructions.addStep(MessageFormat.format(MANUAL_DYNAMIC_STEP1_MESSAGE, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava())));
        instructions.addStep(MANUAL_DYNAMIC_STEP2_MESSAGE);
        if (IntegrationUtils.isWindowsPlatform((String)targetOS)) {
            instructions.addWarning(this.SPACES_IN_PATH_WARNING_MSG);
        }
        instructions.addHint(this.REDUCE_OVERHEAD_MSG);
        if (!IntegrationUtils.isWindowsPlatform((String)targetOS)) {
            instructions.addHint(this.EXPORT_SETENV_MSG);
        }
        instructions.addWarning(MessageFormat.format(DYNAMIC_WARNING_MESSAGE, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()), IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort())));
        return instructions;
    }

    private IntegrationProvider.IntegrationHints getManualRemoteIntegrationStepsInstructions(String targetOS, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints instructions = new IntegrationProvider.IntegrationHints();
        instructions.addStep(this.getManualRemoteStep1(targetOS));
        instructions.addStep(this.getManualRemoteStep2(targetOS));
        String pathToJDKDirectory = "&lt;" + MessageFormat.format(PATH_TO_JDK_DIRECTORY_STRING, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava())) + "&gt;";
        instructions.addStep(MessageFormat.format(MANUAL_REMOTE_STEP3_MESSAGE, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()), IntegrationUtils.getExportEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)pathToJDKDirectory, (boolean)true)));
        instructions.addStep(MessageFormat.format(MANUAL_REMOTE_STEP4_MESSAGE, IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort()), this.REMOTE_ABSOLUTE_PATH_HINT));
        instructions.addStep(MANUAL_REMOTE_STEP5_MESSAGE);
        if (IntegrationUtils.isWindowsPlatform((String)targetOS)) {
            instructions.addWarning(this.SPACES_IN_PATH_WARNING_MSG);
        }
        instructions.addHint(this.REDUCE_OVERHEAD_MSG);
        if (!IntegrationUtils.isWindowsPlatform((String)targetOS)) {
            instructions.addHint(this.EXPORT_SETENV_MSG);
        }
        return instructions;
    }
}

