/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.webservices.annotation;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.dd.api.common.Icon;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.impl.webservices.annotation.PortComponentImpl;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.JavaContextListener;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObject;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;

public class WebserviceDescriptionImpl
extends PersistentObject
implements WebserviceDescription,
JavaContextListener {
    private String serviceName;
    private String wsdlLocation;
    private boolean isProvider;
    private PortComponent[] portComponents;

    public WebserviceDescriptionImpl(AnnotationModelHelper annotationModelHelper, TypeElement typeElement) {
        super(annotationModelHelper, typeElement);
        annotationModelHelper.addJavaContextListener((JavaContextListener)this);
        boolean bl = this.refresh(typeElement);
        assert (bl);
    }

    boolean refresh(TypeElement typeElement) {
        if (typeElement.getKind() == ElementKind.INTERFACE) {
            return false;
        }
        AnnotationModelHelper annotationModelHelper = this.getHelper();
        Map map = annotationModelHelper.getAnnotationsByType(typeElement.getAnnotationMirrors());
        AnnotationMirror annotationMirror = (AnnotationMirror)map.get("javax.jws.WebService");
        if (annotationMirror == null) {
            annotationMirror = (AnnotationMirror)map.get("javax.xml.ws.WebServiceProvider");
            this.isProvider = true;
        }
        if (annotationMirror == null) {
            return false;
        }
        AnnotationParser annotationParser = AnnotationParser.create((AnnotationModelHelper)annotationModelHelper);
        annotationParser.expectString("serviceName", AnnotationParser.defaultValue((Object)(typeElement.getSimpleName().toString() + "Service")));
        annotationParser.expectString("wsdlLocation", AnnotationParser.defaultValue((Object)""));
        ParseResult parseResult = annotationParser.parse(annotationMirror);
        this.serviceName = (String)parseResult.get("serviceName", String.class);
        this.wsdlLocation = (String)parseResult.get("wsdlLocation", String.class);
        return true;
    }

    public void javaContextLeft() {
        this.portComponents = null;
    }

    @Override
    public String getWebserviceDescriptionName() {
        return this.serviceName;
    }

    @Override
    public String getWsdlFile() {
        return this.wsdlLocation;
    }

    @Override
    public String getDisplayName() {
        return this.isProvider ? "javax.xml.ws.WebServiceProvider" : this.serviceName;
    }

    @Override
    public PortComponent[] getPortComponent() {
        this.initPortComonents();
        return this.portComponents;
    }

    @Override
    public int sizePortComponent() {
        this.initPortComonents();
        return this.portComponents.length;
    }

    @Override
    public PortComponent getPortComponent(int n) {
        this.initPortComonents();
        return this.portComponents[n];
    }

    private void initPortComonents() {
        if (this.portComponents != null) {
            return;
        }
        AnnotationModelHelper annotationModelHelper = this.getHelper();
        TypeElement typeElement = this.getTypeElement();
        if (typeElement == null) {
            this.portComponents = new PortComponent[0];
            return;
        }
        Map map = annotationModelHelper.getAnnotationsByType(typeElement.getAnnotationMirrors());
        AnnotationParser annotationParser = AnnotationParser.create((AnnotationModelHelper)annotationModelHelper);
        annotationParser.expectString("portName", AnnotationParser.defaultValue((Object)(typeElement.getSimpleName().toString() + "Port")));
        annotationParser.expectString("name", AnnotationParser.defaultValue((Object)typeElement.getSimpleName().toString()));
        annotationParser.expectString("endpointInterface", AnnotationParser.defaultValue((Object)typeElement.getQualifiedName().toString()));
        annotationParser.expectString("targetNamespace", AnnotationParser.defaultValue((Object)("http://" + this.getPackageNameFromTypeElement(typeElement) + "/")));
        ParseResult parseResult = annotationParser.parse((AnnotationMirror)map.get("javax.jws.WebService"));
        String string = (String)parseResult.get("portName", String.class);
        String string2 = (String)parseResult.get("name", String.class);
        String string3 = (String)parseResult.get("endpointInterface", String.class);
        String string4 = (String)parseResult.get("targetNamespace", String.class);
        this.portComponents = new PortComponent[]{new PortComponentImpl(annotationModelHelper, typeElement, this.serviceName, string, string2, string3, string4)};
    }

    public Object clone() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setId(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDescription(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDescription() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDescriptionId(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDescriptionId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDescriptionXmlLang(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDescriptionXmlLang() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDisplayName(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDisplayNameId(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDisplayNameId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDisplayNameXmlLang(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDisplayNameXmlLang() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setIcon(Icon icon) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Icon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Icon newIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setWebserviceDescriptionName(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setWebserviceDescriptionNameId(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getWebserviceDescriptionNameId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setWsdlFile(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setJaxrpcMappingFile(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getJaxrpcMappingFile() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPortComponent(int n, PortComponent portComponent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPortComponent(PortComponent[] portComponentArray) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int addPortComponent(PortComponent portComponent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removePortComponent(PortComponent portComponent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PortComponent newPortComponent() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getValue(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private String getPackageNameFromTypeElement(TypeElement typeElement) {
        Element element = typeElement;
        while (ElementKind.PACKAGE != element.getKind()) {
            element = element.getEnclosingElement();
        }
        return ((PackageElement)element).getQualifiedName().toString();
    }
}

