/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ddloaders;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.deploy.shared.ModuleType;
import org.netbeans.modules.j2ee.sun.ddloaders.DDViewFactory;
import org.openide.ErrorManager;

public final class DDType {
    private static final String NAME_SUNAPPCLIENT = "sun-application-client.xml";
    private static final String NAME_SUNAPPLICATION = "sun-application.xml";
    private static final String NAME_SUNCMPMAPPING = "sun-cmp-mappings.xml";
    private static final String NAME_SUNEJBJAR = "sun-ejb-jar.xml";
    private static final String NAME_SUNWEBAPP = "sun-web.xml";
    private static final String NAME_SUNRESOURCE = "sun-resources.xml";
    public static DDType DD_SUN_WEB_APP = new DDType("sun-web.xml", ModuleType.WAR, DDViewFactory.SunWebDDViewFactory.class);
    public static DDType DD_SUN_EJB_JAR = new DDType("sun-ejb-jar.xml", ModuleType.EJB, DDViewFactory.SunEjbJarDDViewFactory.class);
    public static DDType DD_SUN_APP_CLIENT = new DDType("sun-application-client.xml", ModuleType.CAR, DDViewFactory.SunAppClientDDViewFactory.class);
    public static DDType DD_SUN_APPLICATION = new DDType("sun-application.xml", ModuleType.EAR, DDViewFactory.SunApplicationDDViewFactory.class);
    public static DDType DD_SUN_CMP_MAPPINGS = new DDType("sun-cmp-mappings.xml", ModuleType.EJB, DDViewFactory.SunCmpMappingsDDViewFactory.class);
    public static DDType DD_SUN_RESOURCE = new DDType("sun-resources.xml", null, DDViewFactory.SunResourceDDViewFactory.class);
    private static Map<String, DDType> fileToTypeMap = new HashMap<String, DDType>(11);
    private final String descriptorName;
    private final ModuleType moduleType;
    private final Class viewFactoryClass;

    public static DDType getDDType(String string) {
        return fileToTypeMap.get(string);
    }

    private DDType(String string, ModuleType moduleType, Class clazz) {
        this.descriptorName = string;
        this.moduleType = moduleType;
        this.viewFactoryClass = clazz;
    }

    public String getDescriptorFileName() {
        return this.descriptorName;
    }

    public ModuleType getEditorModuleType() {
        return this.moduleType;
    }

    public DDViewFactory createViewFactory() {
        DDViewFactory dDViewFactory = null;
        try {
            dDViewFactory = (DDViewFactory)this.viewFactoryClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            ErrorManager.getDefault().notify(1, (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ErrorManager.getDefault().notify(1, (Throwable)illegalAccessException);
        }
        return dDViewFactory;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DDType dDType = (DDType)object;
        if (!this.viewFactoryClass.equals(dDType.viewFactoryClass)) {
            return false;
        }
        if (!this.moduleType.equals(dDType.moduleType)) {
            return false;
        }
        return this.descriptorName.equals(dDType.descriptorName);
    }

    public int hashCode() {
        int n = 7;
        n = 37 * n + (this.descriptorName != null ? this.descriptorName.hashCode() : 0);
        n = 37 * n + (this.viewFactoryClass != null ? this.viewFactoryClass.hashCode() : 0);
        return n;
    }

    static {
        fileToTypeMap.put(NAME_SUNWEBAPP, DD_SUN_WEB_APP);
        fileToTypeMap.put(NAME_SUNEJBJAR, DD_SUN_EJB_JAR);
        fileToTypeMap.put(NAME_SUNAPPLICATION, DD_SUN_APPLICATION);
        fileToTypeMap.put(NAME_SUNAPPCLIENT, DD_SUN_APP_CLIENT);
        fileToTypeMap.put(NAME_SUNCMPMAPPING, DD_SUN_CMP_MAPPINGS);
        fileToTypeMap.put(NAME_SUNRESOURCE, DD_SUN_RESOURCE);
    }
}

