/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import com.sun.jdi.AbsentInformationException;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.openide.ErrorManager;
import org.openide.util.Exceptions;

public class SourcePath {
    private ContextProvider contextProvider;
    private SourcePathProvider sourcePathProvider;
    private JPDADebugger debugger;

    public SourcePath(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.getContext();
    }

    private SourcePathProvider getContext() {
        if (this.sourcePathProvider == null) {
            List list = this.contextProvider.lookup(null, SourcePathProvider.class);
            this.sourcePathProvider = (SourcePathProvider)list.get(0);
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                this.sourcePathProvider = new CompoundContextProvider((SourcePathProvider)list.get(i), this.sourcePathProvider);
            }
        }
        return this.sourcePathProvider;
    }

    static SourcePathProvider getDefaultContext() {
        List list = DebuggerManager.getDebuggerManager().lookup("netbeans-JPDASession", SourcePathProvider.class);
        for (Object e : list) {
            if (!e.getClass().getName().equals("org.netbeans.modules.debugger.jpda.projects.SourcePathProviderImpl")) continue;
            return (SourcePathProvider)e;
        }
        return null;
    }

    public String getRelativePath(String string, char c, boolean bl) {
        return this.getContext().getRelativePath(string, c, bl);
    }

    public String getURL(String string, boolean bl) {
        String string2 = this.getContext().getURL(string, bl);
        if (string2 != null) {
            try {
                new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                Logger.getLogger(SourcePath.class.getName()).log(Level.WARNING, "Malformed URL '" + string2 + "' produced by " + this.getContext(), malformedURLException);
                return null;
            }
        }
        return string2;
    }

    public String[] getSourceRoots() {
        return this.getContext().getSourceRoots();
    }

    public String[] getOriginalSourceRoots() {
        return this.getContext().getOriginalSourceRoots();
    }

    public String[] getAdditionalSourceRoots() {
        try {
            Method method = this.getContext().getClass().getMethod("getAdditionalSourceRoots", new Class[0]);
            String[] stringArray = (String[])method.invoke((Object)this.getContext(), new Object[0]);
            return stringArray;
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return new String[0];
        }
    }

    public void setSourceRoots(String[] stringArray, String[] stringArray2) {
        try {
            Method method = this.getContext().getClass().getMethod("setSourceRoots", String[].class, String[].class);
            method.invoke((Object)this.getContext(), stringArray, stringArray2);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    public void reorderOriginalSourceRoots(int[] nArray) {
        try {
            Method method = this.getContext().getClass().getMethod("reorderOriginalSourceRoots", int[].class);
            method.invoke((Object)this.getContext(), new Object[]{nArray});
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getContext().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getContext().removePropertyChangeListener(propertyChangeListener);
    }

    public boolean sourceAvailable(String string, boolean bl) {
        return this.getURL(string, bl) != null;
    }

    public boolean sourceAvailable(JPDAThread jPDAThread, String string, boolean bl) {
        try {
            return this.sourceAvailable(SourcePath.convertSlash(jPDAThread.getSourcePath(string)), bl);
        }
        catch (AbsentInformationException absentInformationException) {
            return this.sourceAvailable(SourcePath.convertClassNameToRelativePath(jPDAThread.getClassName()), bl);
        }
    }

    public boolean sourceAvailable(Field field) {
        String string = field.getClassName();
        return this.sourceAvailable(string, true);
    }

    public boolean sourceAvailable(CallStackFrame callStackFrame, String string) {
        try {
            return this.sourceAvailable(SourcePath.convertSlash(callStackFrame.getSourcePath(string)), true);
        }
        catch (AbsentInformationException absentInformationException) {
            return this.sourceAvailable(SourcePath.convertClassNameToRelativePath(callStackFrame.getClassName()), true);
        }
    }

    public String getURL(CallStackFrame callStackFrame, String string) {
        try {
            return this.getURL(SourcePath.convertSlash(callStackFrame.getSourcePath(string)), true);
        }
        catch (AbsentInformationException absentInformationException) {
            return this.getURL(SourcePath.convertClassNameToRelativePath(callStackFrame.getClassName()), true);
        }
    }

    public void showSource(JPDAThread jPDAThread, String string) {
        String string2;
        int n = jPDAThread.getLineNumber(string);
        if (n < 1) {
            n = 1;
        }
        try {
            string2 = this.getURL(SourcePath.convertSlash(jPDAThread.getSourcePath(string)), true);
        }
        catch (AbsentInformationException absentInformationException) {
            string2 = this.getURL(SourcePath.convertClassNameToRelativePath(jPDAThread.getClassName()), true);
        }
        final int n2 = n;
        final String string3 = string2;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorContextBridge.getContext().showSource(string3, n2, (Object)SourcePath.this.debugger);
            }
        });
    }

    public void showSource(CallStackFrame callStackFrame, String string) {
        int n;
        String string2;
        block6: {
            try {
                string2 = this.getURL(SourcePath.convertSlash(callStackFrame.getSourcePath(string)), true);
                if (string2 == null) {
                    string = callStackFrame.getDefaultStratum();
                    string2 = this.getURL(SourcePath.convertSlash(callStackFrame.getSourcePath(string)), true);
                }
                if (string2 == null) {
                    ErrorManager.getDefault().log(16, "Show Source: No URL for source path " + callStackFrame.getSourcePath(string) + "\nThe reason is likely no opened project for this source file.");
                    return;
                }
                n = callStackFrame.getLineNumber(string);
                if (n < 1) {
                    n = 1;
                }
            }
            catch (AbsentInformationException absentInformationException) {
                string2 = this.getURL(SourcePath.convertClassNameToRelativePath(callStackFrame.getClassName()), true);
                if (string2 == null) {
                    ErrorManager.getDefault().log(16, "Show Source: No source URL for class " + callStackFrame.getClassName() + "\nThe reason is likely no opened project for the source file.");
                    return;
                }
                n = callStackFrame.getLineNumber(string);
                if (n >= 1) break block6;
                n = 1;
            }
        }
        final int n2 = n;
        final String string3 = string2;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorContextBridge.getContext().showSource(string3, n2, (Object)SourcePath.this.debugger);
            }
        });
    }

    public void showSource(Field field) {
        String string = field.getName();
        String string2 = field.getClassName();
        String string3 = this.getURL(EditorContextBridge.getRelativePath(string2), true);
        if (string3 == null) {
            return;
        }
        int n = EditorContextBridge.getContext().getFieldLineNumber(string3, string2, string);
        if (n < 1) {
            n = 1;
        }
        final int n2 = n;
        final String string4 = string3;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorContextBridge.getContext().showSource(string4, n2, (Object)SourcePath.this.debugger);
            }
        });
    }

    private static String convertSlash(String string) {
        return string.replace(File.separatorChar, '/');
    }

    public static String convertClassNameToRelativePath(String string) {
        int n = string.indexOf(36);
        if (n > 0) {
            string = string.substring(0, n);
        }
        String string2 = string.replace('.', '/') + ".java";
        return string2;
    }

    public Object annotate(JPDAThread jPDAThread, String string) {
        return this.annotate(jPDAThread, string, true);
    }

    public Object annotate(JPDAThread jPDAThread, String string, boolean bl) {
        List list;
        EditorContext.Operation operation;
        String string2;
        int n = jPDAThread.getLineNumber(string);
        if (n < 1) {
            return null;
        }
        try {
            string2 = this.getURL(SourcePath.convertSlash(jPDAThread.getSourcePath(string)), true);
        }
        catch (AbsentInformationException absentInformationException) {
            string2 = this.getURL(SourcePath.convertClassNameToRelativePath(jPDAThread.getClassName()), true);
        }
        if (bl) {
            operation = jPDAThread.getCurrentOperation();
            list = SourcePath.annotateOperations(this.debugger, string2, operation, jPDAThread.getLastOperations(), n);
        } else {
            operation = null;
            list = Collections.EMPTY_LIST;
        }
        if (operation == null && list.size() == 0) {
            return EditorContextBridge.getContext().annotate(string2, n, bl ? "CurrentPC" : "OtherThread", (Object)this.debugger, jPDAThread);
        }
        return list;
    }

    public Object annotate(CallStackFrame callStackFrame, String string) {
        int n = callStackFrame.getLineNumber(string);
        if (n < 1) {
            return null;
        }
        EditorContext.Operation operation = callStackFrame.getCurrentOperation(string);
        try {
            if (operation != null) {
                int n2;
                int n3;
                if (operation.getMethodName() != null) {
                    n3 = operation.getMethodStartPosition().getOffset();
                    n2 = operation.getMethodEndPosition().getOffset();
                } else {
                    n3 = operation.getStartPosition().getOffset();
                    n2 = operation.getEndPosition().getOffset();
                }
                return EditorContextBridge.getContext().annotate(this.getURL(SourcePath.convertSlash(callStackFrame.getSourcePath(string)), true), n3, n2, "CallSite", (Object)this.debugger);
            }
            return EditorContextBridge.getContext().annotate(this.getURL(SourcePath.convertSlash(callStackFrame.getSourcePath(string)), true), n, "CallSite", (Object)this.debugger);
        }
        catch (AbsentInformationException absentInformationException) {
            return EditorContextBridge.getContext().annotate(this.getURL(SourcePath.convertClassNameToRelativePath(callStackFrame.getClassName()), true), n, "CallSite", (Object)this.debugger);
        }
    }

    private static List annotateOperations(JPDADebugger jPDADebugger, String string, EditorContext.Operation operation, List list, int n) {
        Object object;
        int n2;
        ArrayList<Object> arrayList = null;
        int n3 = -1;
        if (operation != null) {
            arrayList = new ArrayList<Object>();
            Object object2 = SourcePath.createAnnotation(jPDADebugger, string, operation, "CurrentPC", true);
            if (object2 != null) {
                arrayList.add(object2);
            }
            n2 = operation.getMethodName() != null ? operation.getMethodStartPosition().getLine() : operation.getStartPosition().getLine();
            object2 = EditorContextBridge.getContext().annotate(string, n2, "CurrentExpressionLine", (Object)jPDADebugger);
            n3 = n2;
            if (object2 != null) {
                arrayList.add(object2);
            }
        }
        boolean bl = false;
        if (list != null && list.size() > 0) {
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            bl = operation == null;
            for (n2 = 0; n2 < list.size(); ++n2) {
                Object object3;
                EditorContext.Operation operation2 = (EditorContext.Operation)list.get(n2);
                if (operation == operation2 && n2 == list.size() - 1) {
                    int n4;
                    object3 = SourcePath.createAnnotation(jPDADebugger, string, operation2, "StepOutOperation", false);
                    if (object3 != null) {
                        arrayList.add(object3);
                    }
                    if (n3 != (n4 = operation2.getEndPosition().getLine()) && (object3 = EditorContextBridge.getContext().annotate(string, n4, "CurrentExpressionLine", (Object)jPDADebugger)) != null) {
                        arrayList.add(object3);
                    }
                    bl = false;
                    continue;
                }
                object3 = SourcePath.createAnnotation(jPDADebugger, string, operation2, "LastOperation", true);
                if (object3 == null) continue;
                arrayList.add(object3);
            }
        }
        if (bl && (object = EditorContextBridge.getContext().annotate(string, n, "CurrentPC", (Object)jPDADebugger)) != null) {
            arrayList.add(object);
        }
        if (arrayList != null) {
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    private static Object createAnnotation(JPDADebugger jPDADebugger, String string, EditorContext.Operation operation, String string2, boolean bl) {
        int n;
        int n2;
        if (bl && operation.getMethodName() != null) {
            n2 = operation.getMethodStartPosition().getOffset();
            n = operation.getMethodEndPosition().getOffset();
        } else {
            n2 = operation.getStartPosition().getOffset();
            n = operation.getEndPosition().getOffset();
        }
        return EditorContextBridge.getContext().annotate(string, n2, n, string2, (Object)jPDADebugger);
    }

    private static class CompoundAnnotation {
        Object annotation1;
        Object annotation2;

        private CompoundAnnotation() {
        }
    }

    private static class CompoundContextProvider
    extends SourcePathProvider {
        private SourcePathProvider cp1;
        private SourcePathProvider cp2;

        CompoundContextProvider(SourcePathProvider sourcePathProvider, SourcePathProvider sourcePathProvider2) {
            this.cp1 = sourcePathProvider;
            this.cp2 = sourcePathProvider2;
        }

        public String getURL(String string, boolean bl) {
            String string2 = this.cp1.getURL(string, bl);
            if (string2 != null) {
                try {
                    new URL(string2);
                    return string2;
                }
                catch (MalformedURLException malformedURLException) {
                    Logger.getLogger(SourcePath.class.getName()).log(Level.WARNING, "Malformed URL '" + string2 + "' produced by " + this.cp1, malformedURLException);
                }
            }
            if ((string2 = this.cp2.getURL(string, bl)) != null) {
                try {
                    new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    Logger.getLogger(SourcePath.class.getName()).log(Level.WARNING, "Malformed URL '" + string2 + "' produced by " + this.cp2, malformedURLException);
                    string2 = null;
                }
            }
            return string2;
        }

        public String getRelativePath(String string, char c, boolean bl) {
            String string2 = this.cp1.getRelativePath(string, c, bl);
            if (string2 != null) {
                return string2;
            }
            return this.cp2.getRelativePath(string, c, bl);
        }

        public String[] getSourceRoots() {
            String[] stringArray = this.cp1.getSourceRoots();
            String[] stringArray2 = this.cp2.getSourceRoots();
            String[] stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
            return stringArray3;
        }

        public String[] getOriginalSourceRoots() {
            String[] stringArray = this.cp1.getOriginalSourceRoots();
            String[] stringArray2 = this.cp2.getOriginalSourceRoots();
            String[] stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
            return stringArray3;
        }

        public void setSourceRoots(String[] stringArray) {
            this.cp1.setSourceRoots(stringArray);
            this.cp2.setSourceRoots(stringArray);
        }

        public String[] getAdditionalSourceRoots() {
            String[] stringArray;
            String[] stringArray2;
            String[] stringArray3;
            try {
                stringArray3 = this.cp1.getClass().getMethod("getAdditionalSourceRoots", new Class[0]);
                stringArray2 = (String[])stringArray3.invoke((Object)this.cp1, new Object[0]);
            }
            catch (Exception exception) {
                stringArray2 = new String[]{};
            }
            try {
                stringArray3 = this.cp2.getClass().getMethod("getAdditionalSourceRoots", new Class[0]);
                stringArray = (String[])stringArray3.invoke((Object)this.cp2, new Object[0]);
            }
            catch (Exception exception) {
                stringArray = new String[]{};
            }
            if (stringArray2.length == 0) {
                return stringArray;
            }
            if (stringArray.length == 0) {
                return stringArray2;
            }
            stringArray3 = new String[stringArray2.length + stringArray.length];
            System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
            System.arraycopy(stringArray, 0, stringArray3, stringArray2.length, stringArray.length);
            return stringArray3;
        }

        public void setSourceRoots(String[] stringArray, String[] stringArray2) {
            Method method;
            try {
                method = this.cp1.getClass().getMethod("setSourceRoots", String[].class, String[].class);
                method.invoke((Object)this.cp1, stringArray, stringArray2);
            }
            catch (Exception exception) {
                this.cp1.setSourceRoots(stringArray);
            }
            try {
                method = this.cp2.getClass().getMethod("setSourceRoots", String[].class, String[].class);
                method.invoke((Object)this.cp2, stringArray, stringArray2);
            }
            catch (Exception exception) {
                this.cp2.setSourceRoots(stringArray);
            }
        }

        public void reorderOriginalSourceRoots(int[] nArray) {
            Method method;
            try {
                method = this.cp1.getClass().getMethod("reorderOriginalSourceRoots", int[].class);
                method.invoke((Object)this.cp1, new Object[]{nArray});
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                method = this.cp2.getClass().getMethod("reorderOriginalSourceRoots", int[].class);
                method.invoke((Object)this.cp2, new Object[]{nArray});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.cp1.addPropertyChangeListener(propertyChangeListener);
            this.cp2.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.cp1.removePropertyChangeListener(propertyChangeListener);
            this.cp2.removePropertyChangeListener(propertyChangeListener);
        }
    }
}

