/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.editor.SpringXMLConfigEditorUtils;
import org.netbeans.modules.spring.beans.utils.StringUtils;
import org.netbeans.modules.spring.java.JavaUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class BeanClassFinder {
    private FileObject fileObject;
    private Set<String> walkedBeanNames;
    private String startBeanName;
    private SpringBean startBean;

    public BeanClassFinder(Map<String, String> map, FileObject fileObject) {
        this(fileObject, SpringXMLConfigEditorUtils.getMergedBean(map, fileObject), BeanClassFinder.getBeanIdOrName(map));
    }

    public BeanClassFinder(SpringBean springBean, FileObject fileObject) {
        this(fileObject, SpringXMLConfigEditorUtils.getMergedBean(springBean, fileObject), BeanClassFinder.getBeanIdOrName(springBean));
    }

    private BeanClassFinder(FileObject fileObject, SpringBean springBean, String string) {
        this.fileObject = fileObject;
        this.startBean = springBean;
        this.startBeanName = string;
        this.walkedBeanNames = new HashSet<String>();
    }

    public String findImplementationClass() {
        this.walkedBeanNames.add(this.startBeanName);
        return this.findImplementationClass(this.startBean);
    }

    private String findImplementationClass(SpringBean springBean) {
        String string = null;
        if (springBean == null) {
            return null;
        }
        boolean bl = false;
        if (StringUtils.hasText(springBean.getFactoryBean())) {
            string = this.findImplementationClass(springBean.getFactoryBean());
            bl = false;
        } else if (StringUtils.hasText(springBean.getClassName())) {
            string = springBean.getClassName();
            bl = true;
        }
        if (springBean.getFactoryMethod() != null && string != null) {
            string = this.getFactoryMethodReturnTypeName(string, springBean.getFactoryMethod(), bl);
        }
        return string;
    }

    private String findImplementationClass(final String string) {
        if (this.walkedBeanNames.contains(string)) {
            return null;
        }
        final String[] stringArray = new String[]{null};
        try {
            SpringConfigModel springConfigModel = SpringConfigModel.forFileObject(this.fileObject);
            if (springConfigModel == null) {
                return null;
            }
            springConfigModel.runReadAction(new Action<SpringBeans>(){

                @Override
                public void run(SpringBeans springBeans) {
                    SpringBean springBean = springBeans.findBean(string);
                    if ((springBean = SpringXMLConfigEditorUtils.getMergedBean(springBean, BeanClassFinder.this.fileObject)) == null) {
                        return;
                    }
                    String string2 = BeanClassFinder.getBeanIdOrName(springBean);
                    BeanClassFinder.this.walkedBeanNames.add(string2);
                    stringArray[0] = BeanClassFinder.this.findImplementationClass(springBean);
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return stringArray[0];
    }

    private String getFactoryMethodReturnTypeName(final String string, final String string2, final boolean bl) {
        final String[] stringArray = new String[]{null};
        if (!StringUtils.hasText(string2)) {
            return null;
        }
        try {
            JavaSource javaSource = JavaUtils.getJavaSource(this.fileObject);
            if (javaSource == null) {
                return null;
            }
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    if (string == null) {
                        return;
                    }
                    TypeElement typeElement = JavaUtils.findClassElementByBinaryName(string, compilationController);
                    if (typeElement == null) {
                        return;
                    }
                    FactoryMethodFinder factoryMethodFinder = new FactoryMethodFinder(typeElement, string2, bl, compilationController.getElementUtilities());
                    List<ExecutableElement> list = factoryMethodFinder.findMethods();
                    if (list.size() != 1) {
                        return;
                    }
                    ExecutableElement executableElement = list.get(0);
                    if (executableElement.getReturnType().getKind() != TypeKind.DECLARED) {
                        return;
                    }
                    DeclaredType declaredType = (DeclaredType)executableElement.getReturnType();
                    stringArray[0] = ElementUtilities.getBinaryName((TypeElement)((TypeElement)declaredType.asElement()));
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return stringArray[0];
    }

    private static String getBeanIdOrName(SpringBean springBean) {
        if (springBean.getId() != null) {
            return springBean.getId();
        }
        if (springBean.getNames().size() > 0) {
            return springBean.getNames().get(0);
        }
        return null;
    }

    private static String getBeanIdOrName(Map<String, String> map) {
        String string = map.get("id");
        if (string != null) {
            return string;
        }
        string = map.get("name");
        if (StringUtils.hasText(string)) {
            string = StringUtils.tokenize(string, ",; ").get(0);
        }
        return string;
    }

    private static class FactoryMethodFinder {
        private TypeElement te;
        private String factoryMethodName;
        private boolean staticFlag;
        private ElementUtilities eu;

        public FactoryMethodFinder(TypeElement typeElement, String string, boolean bl, ElementUtilities elementUtilities) {
            this.te = typeElement;
            this.factoryMethodName = string;
            this.staticFlag = bl;
            this.eu = elementUtilities;
        }

        public List<ExecutableElement> findMethods() {
            Iterable iterable = this.eu.getMembers(this.te.asType(), new ElementUtilities.ElementAcceptor(){

                public boolean accept(Element element, TypeMirror typeMirror) {
                    if (element.getKind() == ElementKind.METHOD) {
                        TypeElement typeElement = (TypeElement)element.getEnclosingElement();
                        if (typeElement.getQualifiedName().contentEquals("java.lang.Object")) {
                            return false;
                        }
                        if (!element.getSimpleName().toString().equals(FactoryMethodFinder.this.factoryMethodName)) {
                            return false;
                        }
                        ExecutableElement executableElement = (ExecutableElement)element;
                        boolean bl = executableElement.getModifiers().contains((Object)Modifier.STATIC);
                        return bl == FactoryMethodFinder.this.staticFlag;
                    }
                    return false;
                }
            });
            ArrayList<ExecutableElement> arrayList = new ArrayList<ExecutableElement>();
            for (Element element : iterable) {
                ExecutableElement executableElement = (ExecutableElement)element;
                arrayList.add(executableElement);
            }
            return arrayList;
        }
    }
}

