/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sun.appserv;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.AppServerAdmin;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.LocalStringsManager;

public class AdminTask
extends AppServerAdmin {
    private String command;
    private String explicitCommand;
    private File commandFile;
    LocalStringsManager lsm = new LocalStringsManager();

    public void setCommand(String command) {
        this.command = command.trim();
    }

    public void setExplicitcommand(String explicitCommand) {
        this.explicitCommand = explicitCommand;
    }

    public void setCommandfile(File commandFile) {
        String msg = this.lsm.getString("DeprecatedAttribute", new Object[]{"commandfile", "- 'multimode --file <commandfile>'"});
        this.log(msg, 1);
        this.commandFile = commandFile;
    }

    public void execute() throws BuildException {
        this.checkCommandCount();
        if (this.command != null && this.servers.size() == 0 && this.server == null) {
            this.explicitCommand = this.command;
            this.command = null;
        }
        if (this.explicitCommand != null) {
            this.execAdminCommand(this.explicitCommand);
        } else {
            super.execute();
        }
    }

    private void checkCommandCount() throws BuildException {
        int commandCount = 0;
        if (this.command != null) {
            ++commandCount;
        }
        if (this.explicitCommand != null) {
            ++commandCount;
        }
        if (this.commandFile != null) {
            ++commandCount;
        }
        if (commandCount != 1) {
            String msg = this.lsm.getString("ExactlyOneCommandAttribute");
            throw new BuildException(msg, this.getLocation());
        }
    }

    protected void checkConfiguration(AppServerAdmin.Server aServer) throws BuildException {
    }

    protected void execute(AppServerAdmin.Server aServer) throws BuildException {
        StringBuffer cmd;
        String[] userOption = new String[]{"--user ", "-u "};
        String[] passwordOption = new String[]{"--password ", "-w ", "--passwordfile "};
        String[] hostOption = new String[]{"--host ", "-H "};
        String[] portOption = new String[]{"--port ", "-p "};
        String[] instanceOption = new String[]{"--instance ", "-i "};
        String[] secureOption = new String[]{"--secure ", "-s "};
        if (this.command != null) {
            cmd = new StringBuffer(this.command);
            if (!this.commandIncludes(cmd, userOption)) {
                this.insertCommandOption(cmd, " --user " + aServer.getUser());
            }
            if (aServer.hasPassword() && !this.commandIncludes(cmd, passwordOption)) {
                this.insertCommandOption(cmd, aServer.getPasswordCommand());
            }
            if (!this.commandIncludes(cmd, hostOption)) {
                String theHost = aServer.getHost();
                if (theHost == null) {
                    theHost = "localhost";
                }
                this.insertCommandOption(cmd, " --host " + theHost);
            }
            if (!this.commandIncludes(cmd, portOption)) {
                String thePort = aServer.getPort() == 0 ? "4848" : String.valueOf(aServer.getPort());
                this.insertCommandOption(cmd, " --port " + thePort);
            }
            if (aServer.getInstance() != null && !this.commandIncludes(cmd, instanceOption)) {
                this.insertCommandOption(cmd, " --instance " + aServer.getInstance());
            }
            if (aServer.getSecure() != null && !this.commandIncludes(cmd, secureOption)) {
                this.insertCommandOption(cmd, " --secure=" + aServer.getSecure());
            }
        } else {
            String filename;
            try {
                filename = this.commandFile.getCanonicalPath();
            }
            catch (Exception e) {
                filename = this.commandFile.getAbsolutePath();
            }
            filename = filename.replace('\\', '/');
            cmd = new StringBuffer("multimode --file " + filename + " ");
        }
        this.execAdminCommand(cmd.toString());
    }

    private boolean commandIncludes(StringBuffer cmd, String[] options) {
        for (int i = 0; i < options.length; ++i) {
            if (cmd.indexOf(options[i]) <= 0) continue;
            return true;
        }
        return false;
    }

    private void insertCommandOption(StringBuffer cmdLine, String commandOption) {
        int index = cmdLine.indexOf(" ");
        index = index >= 0 ? index : cmdLine.length();
        cmdLine.insert(index, commandOption).append(' ');
    }
}

