/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.io.File;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.TestsuiteNode;
import org.netbeans.modules.ruby.platform.execution.ExecutionUtils;
import org.netbeans.modules.ruby.platform.execution.OutputProcessor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;

final class OutputUtils {
    private static final Logger LOGGER = Logger.getLogger(OutputUtils.class.getName());

    private OutputUtils() {
    }

    static void openCallstackFrame(Node node, String frameInfo, int line) {
        FileObject fo;
        Report report = OutputUtils.getTestsuiteNode(node).getReport();
        ExecutionUtils.FileLocation location = ExecutionUtils.getLocation((String)frameInfo);
        if (location != null && (fo = OutputUtils.findFile(location.file, report.getFileLocator())) != null) {
            if (line == -1) {
                line = location.line;
            }
            OutputProcessor.open((FileObject)fo, (int)line);
            return;
        }
        LOGGER.info("Could not open a file for " + frameInfo);
    }

    static TestsuiteNode getTestsuiteNode(Node node) {
        while (!(node instanceof TestsuiteNode)) {
            node = node.getParentNode();
        }
        return (TestsuiteNode)node;
    }

    static FileObject findFile(String path, LineConvertors.FileLocator fileLocator) {
        FileObject fo;
        if (fileLocator != null && (fo = fileLocator.find(path)) != null) {
            return fo;
        }
        File file = new File(path);
        if (file.isFile()) {
            return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        }
        LOGGER.warning("Cannot resolve file for \"" + path + "\" path.");
        return null;
    }
}

