/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.security;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.netbeans.modules.mobility.project.security.KeyStoreRepository;
import org.netbeans.modules.mobility.project.ui.customizer.ErrorPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class EnterPasswordPanel
extends JPanel
implements ActionListener {
    private ErrorPanel errorPanel1;
    private JCheckBox jCheckBoxRemember;
    private JLabel jLabelMessage;
    private JLabel jLabelPassword;
    private JLabel jLabelUsername;
    private JPasswordField jPasswordField;
    private JTextField jTextFieldUsername;

    public static String getKeystorePassword(String keystorePath) {
        if (keystorePath == null) {
            return null;
        }
        return EnterPasswordPanel.getKeystorePassword(KeyStoreRepository.getDefault().getKeyStore(keystorePath, true));
    }

    public static String getAliasPassword(String keystorePath, String alias) {
        if (keystorePath == null || alias == null) {
            return null;
        }
        KeyStoreRepository.KeyStoreBean ksb = KeyStoreRepository.getDefault().getKeyStore(keystorePath, false);
        if (ksb == null || !ksb.isOpened()) {
            return null;
        }
        return EnterPasswordPanel.getAliasPassword(ksb, ksb.getAlias(alias));
    }

    public static String getKeyfilePassword(String keyFile) {
        EnterPasswordPanel panel = new EnterPasswordPanel(NbBundle.getMessage(EnterPasswordPanel.class, (String)"LBL_EnterKeyfilePassword", (Object)keyFile), null, false, true, true);
        Object o = KeyStoreRepository.getDefault().getPassword(keyFile);
        if (o instanceof String) {
            panel.jPasswordField.setText((String)o);
        }
        String password = panel.showDialog();
        if (KeyStoreRepository.rememberPasswords) {
            if (password != null) {
                KeyStoreRepository.getDefault().putPassword(keyFile, password);
            }
        } else {
            KeyStoreRepository.getDefault().removePassword(keyFile);
        }
        return password;
    }

    public static String[] getConnectionUsernameAndPassword(String connectionId, String userName) {
        String[] stringArray;
        EnterPasswordPanel panel = new EnterPasswordPanel(NbBundle.getMessage(EnterPasswordPanel.class, (String)"LBL_EnterConnectionPassword", (Object)connectionId), userName == null ? "" : userName, true, false, true);
        Object o = KeyStoreRepository.getDefault().getPassword(EnterPasswordPanel.getKey(connectionId, userName));
        if (o instanceof String) {
            panel.jPasswordField.setText((String)o);
        } else if (o instanceof String[]) {
            panel.jTextFieldUsername.setText(((String[])o)[0]);
            panel.jPasswordField.setText(((String[])o)[1]);
        }
        String password = panel.showDialog();
        userName = panel.jTextFieldUsername.getText();
        if (KeyStoreRepository.rememberPasswords) {
            if (password != null) {
                KeyStoreRepository.getDefault().putPassword(connectionId, new String[]{userName, password});
                KeyStoreRepository.getDefault().putPassword(EnterPasswordPanel.getKey(connectionId, userName), password);
            }
        } else {
            KeyStoreRepository.getDefault().removePassword(connectionId);
            KeyStoreRepository.getDefault().removePassword(EnterPasswordPanel.getKey(connectionId, userName));
        }
        if (password == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = userName;
            stringArray = stringArray2;
            stringArray2[1] = password;
        }
        return stringArray;
    }

    private static String getKey(String connectionId, String userName) {
        return userName == null || userName.length() == 0 ? connectionId : userName + '@' + connectionId;
    }

    public static String getConnectionPassword(String connectionId, String userName) {
        EnterPasswordPanel panel = new EnterPasswordPanel(NbBundle.getMessage(EnterPasswordPanel.class, (String)"LBL_EnterConnectionPassword", (Object)connectionId), userName == null ? "" : userName, false, false, true);
        Object o = KeyStoreRepository.getDefault().getPassword(EnterPasswordPanel.getKey(connectionId, userName));
        if (o instanceof String) {
            panel.jPasswordField.setText((String)o);
        }
        String password = panel.showDialog();
        if (KeyStoreRepository.rememberPasswords) {
            if (password != null) {
                KeyStoreRepository.getDefault().putPassword(EnterPasswordPanel.getKey(connectionId, userName), password);
            }
        } else {
            KeyStoreRepository.getDefault().removePassword(EnterPasswordPanel.getKey(connectionId, userName));
        }
        return password;
    }

    public static String getKeystorePassword(KeyStoreRepository.KeyStoreBean ksb) {
        String password;
        if (ksb == null) {
            return null;
        }
        if (ksb.isOpened()) {
            return ksb.getPassword();
        }
        EnterPasswordPanel panel = new EnterPasswordPanel(NbBundle.getMessage(EnterPasswordPanel.class, (String)"LBL_EnterKeystorePassword", (Object)ksb.getKeyStorePath()), null, false, false, false);
        while ((password = panel.showDialog()) != null) {
            ksb.setPassword(password);
            if (ksb.openKeyStore()) {
                return password;
            }
            panel.setKeystoreErrorMessage();
        }
        return null;
    }

    public static String getAliasPassword(KeyStoreRepository.KeyStoreBean ksb, KeyStoreRepository.KeyStoreBean.KeyAliasBean kab) {
        String password;
        if (ksb == null || kab == null || !ksb.isOpened()) {
            return null;
        }
        if (kab.isOpened()) {
            return kab.getPassword();
        }
        EnterPasswordPanel panel = new EnterPasswordPanel(NbBundle.getMessage(EnterPasswordPanel.class, (String)"LBL_EnterAliasPassword", (Object)ksb.getKeyStorePath(), (Object)kab.getAlias()), null, false, false, false);
        while ((password = panel.showDialog()) != null) {
            kab.setPassword(password.length() == 0 ? ksb.getPassword() : password);
            if (kab.open()) {
                return kab.getPassword();
            }
            panel.setAliasErrorMessage();
        }
        return null;
    }

    private EnterPasswordPanel(String label, String userName, boolean userNameEditable, boolean passphrase, boolean showRemember) {
        this.initComponents();
        this.initAccessibility();
        this.jLabelMessage.setText(label);
        if (userName == null) {
            this.jLabelUsername.setVisible(false);
            this.jTextFieldUsername.setVisible(false);
        } else {
            this.jTextFieldUsername.setText(userName);
            if (!userNameEditable) {
                this.jTextFieldUsername.setEditable(false);
            }
        }
        if (passphrase) {
            this.jLabelPassword.setText(NbBundle.getMessage(EnterPasswordPanel.class, (String)"LBL_Password_Passphrase"));
        }
        if (showRemember) {
            this.jCheckBoxRemember.setSelected(KeyStoreRepository.rememberPasswords);
            this.jCheckBoxRemember.addActionListener(this);
        } else {
            this.jCheckBoxRemember.setVisible(false);
        }
    }

    private String showDialog() {
        DialogDescriptor dd = new DialogDescriptor((Object)this, NbBundle.getMessage(EnterPasswordPanel.class, (String)"TITLE_EnterPassword"), true, 2, NotifyDescriptor.OK_OPTION, null);
        dd.setHelpCtx(new HelpCtx(EnterPasswordPanel.class));
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dd))) {
            return String.valueOf(this.jPasswordField.getPassword());
        }
        return null;
    }

    private void setKeystoreErrorMessage() {
        this.errorPanel1.setErrorMessage(NbBundle.getMessage(EnterPasswordPanel.class, (String)"ERR_KeystoreError"));
    }

    private void setAliasErrorMessage() {
        this.errorPanel1.setErrorMessage(NbBundle.getMessage(EnterPasswordPanel.class, (String)"ERR_AliasError"));
    }

    private void initComponents() {
        this.jLabelMessage = new JLabel();
        this.jLabelUsername = new JLabel();
        this.jTextFieldUsername = new JTextField();
        this.jLabelPassword = new JLabel();
        this.jPasswordField = new JPasswordField();
        this.jCheckBoxRemember = new JCheckBox();
        this.errorPanel1 = new ErrorPanel();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabelMessage, gridBagConstraints);
        this.jLabelUsername.setLabelFor(this.jTextFieldUsername);
        Mnemonics.setLocalizedText((JLabel)this.jLabelUsername, (String)NbBundle.getMessage(EnterPasswordPanel.class, (String)"LBL_PasswordPanel_Username"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabelUsername, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 12, 0);
        this.add((Component)this.jTextFieldUsername, gridBagConstraints);
        this.jLabelPassword.setLabelFor(this.jPasswordField);
        Mnemonics.setLocalizedText((JLabel)this.jLabelPassword, (String)NbBundle.getMessage(EnterPasswordPanel.class, (String)"LBL_Password_Password"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabelPassword, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 12, 0);
        this.add((Component)this.jPasswordField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxRemember, (String)NbBundle.getMessage(EnterPasswordPanel.class, (String)"LBL_PasswordPanel_Remember"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jCheckBoxRemember, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.errorPanel1, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EnterPasswordPanel.class, (String)"ACSN_EnterKeystorePassword"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EnterPasswordPanel.class, (String)"ACSD_EnterKeystorePassword"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        KeyStoreRepository.rememberPasswords = this.jCheckBoxRemember.isSelected();
    }
}

