/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.navigation;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.web.beans.navigation.PopupUtil;
import org.netbeans.modules.web.beans.navigation.Utils;

public class InjectablesPopup
extends JPanel
implements FocusListener {
    private JLabel jLabel1;
    private JList jList1;
    private JScrollPane jScrollPane1;
    private String myTitle;
    private List<ElementHandle<Element>> myHandles;
    private CompilationController myController;

    public InjectablesPopup(String string, List<ElementHandle<Element>> list, CompilationController compilationController) {
        this.myTitle = string;
        this.myHandles = list;
        this.myController = compilationController;
        this.initComponents();
        this.jList1.setCursor(Cursor.getPredefinedCursor(12));
        this.addFocusListener(this);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.setFocusCycleRoot(true);
        this.setLayout(new GridBagLayout());
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText(this.myTitle);
        this.jLabel1.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jList1.setModel(this.createListModel());
        this.jList1.setCellRenderer(new RendererImpl(this.myController));
        this.jList1.setSelectedIndex(0);
        this.jList1.setVisibleRowCount(this.myHandles.size());
        this.jList1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                InjectablesPopup.this.jList1KeyPressed(keyEvent);
            }
        });
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                InjectablesPopup.this.jList1MouseClicked(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void jList1MouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1) {
            this.openSelected();
        }
    }

    private void jList1KeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && keyEvent.getModifiers() == 0) {
            this.openSelected();
        }
    }

    private void openSelected() {
        ElementHandle elementHandle = (ElementHandle)this.jList1.getSelectedValue();
        ElementOpen.open((ClasspathInfo)this.myController.getClasspathInfo(), (ElementHandle)elementHandle);
        PopupUtil.hidePopup();
    }

    private ListModel createListModel() {
        DefaultListModel<ElementHandle<Element>> defaultListModel = new DefaultListModel<ElementHandle<Element>>();
        for (ElementHandle<Element> elementHandle : this.myHandles) {
            defaultListModel.addElement(elementHandle);
        }
        return defaultListModel;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.jList1.requestFocus();
        this.jList1.requestFocusInWindow();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    private static class RendererImpl
    extends DefaultListCellRenderer {
        private CompilationController myController;

        RendererImpl(CompilationController compilationController) {
            this.myController = compilationController;
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ElementHandle elementHandle;
            Element element;
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof ElementHandle && (element = (elementHandle = (ElementHandle)object).resolve((CompilationInfo)this.myController)) != null) {
                DeclaredType declaredType = null;
                if (element instanceof VariableElement || element instanceof ExecutableElement) {
                    TypeElement typeElement = this.myController.getElementUtilities().enclosingTypeElement(element);
                    declaredType = (DeclaredType)typeElement.asType();
                }
                this.setIcon(ElementIcons.getElementIcon((ElementKind)element.getKind(), element.getModifiers()));
                this.setText(Utils.format(element, declaredType, (CompilationInfo)this.myController));
            }
            return component;
        }
    }
}

