/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.heapwalk.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.heapwalk.views.ClassesCountsView;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class InstancesView
extends TopComponent {
    private JPanel hfwPanel;
    private HeapFragmentWalker hfw;
    private HeapFragmentWalkerProvider provider;
    private DebuggerSessionListener listener;

    public InstancesView() {
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/debugger/jpda/resources/root.gif"));
        this.setLayout(new BorderLayout());
        this.putClientProperty("KeepNonPersistentTCInModelWhenClosed", Boolean.TRUE);
    }

    protected void componentShowing() {
        super.componentShowing();
        this.listener = new DebuggerSessionListener();
        DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)this.listener);
        this.showContent(this.listener.getState());
    }

    protected void componentClosed() {
        super.componentClosed();
        this.provider = null;
    }

    private void showContent(final int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showTheContent(n);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InstancesView.this.showTheContent(n);
                }
            });
        }
    }

    private void showTheContent(int n) {
        if (n == 3) {
            HeapFragmentWalker heapFragmentWalker;
            ClassesCountsView classesCountsView = (ClassesCountsView)WindowManager.getDefault().findTopComponent("classes");
            if (classesCountsView != null && (heapFragmentWalker = classesCountsView.getCurrentFragmentWalker()) != null) {
                this.setHeapFragmentWalker(heapFragmentWalker);
                this.provider = null;
            } else if (this.provider != null) {
                this.setHeapFragmentWalker(this.provider.getHeapFragmentWalker());
            } else if (this.hfw != null) {
                this.setHeapFragmentWalker(this.hfw);
            } else {
                this.close();
            }
        } else if (n == 2) {
            if (this.hfwPanel != null) {
                this.remove(this.hfwPanel);
            }
            this.hfw = null;
            this.hfwPanel = new SuspendInfoPanel();
            this.add(this.hfwPanel, "Center");
        } else {
            if (this.hfwPanel != null) {
                this.remove(this.hfwPanel);
                this.hfwPanel = null;
            }
            this.hfw = null;
            this.close();
        }
    }

    protected void componentHidden() {
        super.componentHidden();
        if (this.hfwPanel != null) {
            this.remove(this.hfwPanel);
            this.hfwPanel = null;
        }
        this.hfw = null;
        DebuggerManager.getDebuggerManager().removeDebuggerListener((DebuggerManagerListener)this.listener);
        this.listener = null;
    }

    public void setHeapFragmentWalkerProvider(HeapFragmentWalkerProvider heapFragmentWalkerProvider) {
        this.provider = heapFragmentWalkerProvider;
        this.setHeapFragmentWalker(heapFragmentWalkerProvider.getHeapFragmentWalker());
    }

    private void setHeapFragmentWalker(HeapFragmentWalker heapFragmentWalker) {
        if (this.hfwPanel != null) {
            this.remove(this.hfwPanel);
            this.hfwPanel = null;
        }
        this.hfw = heapFragmentWalker;
        if (heapFragmentWalker == null) {
            return;
        }
        Container container = (Container)heapFragmentWalker.getInstancesController().getFieldsBrowserController().getPanel().getComponent(0);
        container.getComponent(1).setVisible(false);
        container = (Container)heapFragmentWalker.getInstancesController().getInstancesListController().getPanel().getComponent(0);
        container.getComponent(1).setVisible(false);
        container = (Container)heapFragmentWalker.getInstancesController().getReferencesBrowserController().getPanel().getComponent(0);
        container.getComponent(1).setVisible(false);
        this.hfwPanel = heapFragmentWalker.getInstancesController().getPanel();
        this.add(this.hfwPanel, "Center");
        this.repaint();
    }

    public HeapFragmentWalker getCurrentFragmentWalker() {
        return this.hfw;
    }

    public String getName() {
        return NbBundle.getMessage(InstancesView.class, (String)"CTL_Instances_view");
    }

    public String getToolTipText() {
        return NbBundle.getMessage(InstancesView.class, (String)"CTL_Instances_tooltip");
    }

    public int getPersistenceType() {
        return 2;
    }

    private static class SuspendInfoPanel
    extends JPanel {
        public SuspendInfoPanel() {
            this.setLayout(new GridBagLayout());
            JTextArea jTextArea = new JTextArea(NbBundle.getMessage(InstancesView.class, (String)"MSG_NotSuspendedApp"));
            jTextArea.setEditable(false);
            jTextArea.setEnabled(false);
            jTextArea.setBackground(this.getBackground());
            jTextArea.setDisabledTextColor(new JLabel().getForeground());
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setPreferredSize(new Dimension(jTextArea.getFontMetrics(jTextArea.getFont()).stringWidth(jTextArea.getText()), jTextArea.getPreferredSize().height));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.add((Component)jTextArea, gridBagConstraints);
            jTextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstancesView.class, (String)"MSG_NotSuspendedApp"));
            JButton jButton = new JButton();
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SuspendInfoPanel.this.doStopCurrentDebugger();
                }
            });
            Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(InstancesView.class, (String)"CTL_Pause"));
            jButton.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/resources/actions/Pause.gif", (boolean)false));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.add((Component)jButton, gridBagConstraints);
        }

        private void doStopCurrentDebugger() {
            DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
            if (debuggerEngine != null) {
                debuggerEngine.getActionsManager().postAction(ActionsManager.ACTION_PAUSE);
            }
        }
    }

    private class DebuggerSessionListener
    extends DebuggerManagerAdapter {
        private Set attachedTo = new WeakSet();
        private int lastState = -1;

        private DebuggerSessionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getState() {
            int n = this.getTheState();
            DebuggerSessionListener debuggerSessionListener = this;
            synchronized (debuggerSessionListener) {
                this.lastState = n;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getTheState() {
            JPDADebugger jPDADebugger;
            int n = 4;
            DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
            if (debuggerEngine != null && (jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class)) != null) {
                n = this.getThreadsState(jPDADebugger);
                DebuggerSessionListener debuggerSessionListener = this;
                synchronized (debuggerSessionListener) {
                    if (!this.attachedTo.contains(jPDADebugger)) {
                        this.attachedTo.add(jPDADebugger);
                        jPDADebugger.addPropertyChangeListener((PropertyChangeListener)((Object)this));
                    }
                }
            }
            return n;
        }

        private int getThreadsState(JPDADebugger jPDADebugger) {
            if (jPDADebugger.getState() != 3) {
                return jPDADebugger.getState();
            }
            try {
                Method method = jPDADebugger.getClass().getMethod("getAllThreads", new Class[0]);
                List list = (List)method.invoke((Object)jPDADebugger, new Object[0]);
                for (JPDAThread jPDAThread : list) {
                    if (jPDAThread.isSuspended()) continue;
                    return 2;
                }
                return 3;
            }
            catch (Exception exception) {
                return jPDADebugger.getState();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("currentEngine") || string.equals("state")) {
                int n = this.getTheState();
                DebuggerSessionListener debuggerSessionListener = this;
                synchronized (debuggerSessionListener) {
                    if (n == this.lastState) {
                        return;
                    }
                    this.lastState = n;
                }
                InstancesView.this.showContent(n);
            }
        }
    }

    public static interface HeapFragmentWalkerProvider {
        public HeapFragmentWalker getHeapFragmentWalker();
    }
}

