/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.View;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.editor.util.GapList;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorBoxView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.HighlightsView;
import org.netbeans.modules.editor.lib2.view.PaintState;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.ParagraphViewChildren;
import org.netbeans.modules.editor.lib2.view.ViewUtils;
import org.netbeans.modules.editor.lib2.view.WrapLine;

final class WrapInfo
extends GapList<WrapLine> {
    private static final Logger LOG = Logger.getLogger(WrapInfo.class.getName());
    private static final long serialVersionUID = 0L;
    double childrenWidth;
    float childrenHeight;

    WrapInfo(double childrenWidth, float childrenHeight) {
        super(2);
        this.childrenWidth = childrenWidth;
        this.childrenHeight = childrenHeight;
    }

    float preferredHeight() {
        return (float)this.size() * this.childrenHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintWrapLines(ParagraphViewChildren children, ParagraphView paragraphView, int startIndex, int endIndex, Graphics2D g, Shape alloc, Rectangle clipBounds) {
        DocumentView docView = paragraphView.getDocumentView();
        if (docView == null) {
            return;
        }
        TextLayout lineContinuationTextLayout = docView.getLineContinuationCharTextLayout();
        Rectangle2D.Double allocBounds = ViewUtils.shape2Bounds(alloc);
        double allocOrigX = allocBounds.x;
        allocBounds.y += (double)((float)startIndex * this.childrenHeight);
        allocBounds.height = this.childrenHeight;
        int lastWrapLineIndex = this.size() - 1;
        for (int i = startIndex; i < endIndex; ++i) {
            EditorView endViewPart;
            WrapLine wrapLine = (WrapLine)this.get(i);
            EditorView startViewPart = wrapLine.startViewPart;
            if (startViewPart != null) {
                float width = startViewPart.getPreferredSpan(0);
                allocBounds.width = width;
                startViewPart.paint(g, allocBounds, clipBounds);
                allocBounds.x += (double)width;
            }
            if (wrapLine.hasFullViews()) {
                int j;
                double nextVisualOffset = paragraphView.getViewVisualOffset(j);
                assert (wrapLine.endViewIndex <= children.size()) : "Invalid for endViewIndex=" + wrapLine.endViewIndex + ", wrapInfo:\n" + this.toString(paragraphView) + "\nParagraphView:\n" + paragraphView;
                for (j = wrapLine.startViewIndex; j < wrapLine.endViewIndex; ++j) {
                    EditorView childView = (EditorView)children.get(j);
                    double visualOffset = nextVisualOffset;
                    nextVisualOffset = paragraphView.getViewVisualOffset(j + 1);
                    allocBounds.width = nextVisualOffset - visualOffset;
                    childView.paint(g, allocBounds, clipBounds);
                    allocBounds.x += allocBounds.width;
                }
            }
            if ((endViewPart = wrapLine.endViewPart) != null) {
                float width = endViewPart.getPreferredSpan(0);
                allocBounds.width = width;
                endViewPart.paint(g, allocBounds, clipBounds);
                allocBounds.x += (double)width;
            }
            if (i != lastWrapLineIndex) {
                PaintState paintState = PaintState.save(g);
                try {
                    HighlightsView.paintForeground(g, allocBounds, docView, lineContinuationTextLayout, paragraphView.getAttributes());
                }
                finally {
                    paintState.restore();
                }
            }
            allocBounds.x = allocOrigX;
            allocBounds.y += (double)this.childrenHeight;
        }
    }

    public void checkIntegrity(ParagraphView paragraphView) {
        String err;
        if (LOG.isLoggable(Level.FINER) && (err = this.findIntegrityError(paragraphView)) != null) {
            String msg = "WrapInfo INTEGRITY ERROR! - " + err;
            LOG.finer(msg + "\n");
            LOG.finer(this.toString(paragraphView));
            if (LOG.isLoggable(Level.FINEST)) {
                throw new IllegalStateException(msg);
            }
            LOG.log(Level.INFO, msg, new Exception());
        }
    }

    public String findIntegrityError(ParagraphView paragraphView) {
        String err = null;
        int lastOffset = paragraphView.getStartOffset();
        for (int i = 0; i < this.size(); ++i) {
            EditorView endViewPart;
            int endViewIndex;
            int startViewIndex;
            WrapLine wrapLine = (WrapLine)this.get(i);
            EditorView startViewPart = wrapLine.startViewPart;
            boolean nonEmptyLine = false;
            if (startViewPart != null) {
                nonEmptyLine = true;
                if (startViewPart.getStartOffset() != lastOffset) {
                    err = "startViewPart.getStartOffset()=" + startViewPart.getStartOffset() + " != lastOffset=" + lastOffset;
                }
                lastOffset = startViewPart.getEndOffset();
            }
            if ((startViewIndex = wrapLine.startViewIndex) != (endViewIndex = wrapLine.endViewIndex)) {
                nonEmptyLine = true;
                boolean validIndices = true;
                if (startViewIndex < 0) {
                    validIndices = false;
                    if (err == null) {
                        err = "startViewIndex=" + startViewIndex + " < 0";
                    }
                }
                if (endViewIndex < startViewIndex) {
                    validIndices = false;
                    if (err == null) {
                        err = "endViewIndex=" + endViewIndex + " < startViewIndex=" + startViewIndex;
                    }
                }
                if (endViewIndex > paragraphView.getViewCount()) {
                    validIndices = false;
                    if (err == null) {
                        err = "endViewIndex=" + endViewIndex + " > getViewCount()=" + paragraphView.getViewCount();
                    }
                }
                if (validIndices) {
                    Object childView = paragraphView.getEditorView(startViewIndex);
                    if (err == null && ((View)childView).getStartOffset() != lastOffset) {
                        err = "startChildView.getStartOffset()=" + ((View)childView).getStartOffset() + " != lastOffset=" + lastOffset;
                    }
                    childView = paragraphView.getEditorView(endViewIndex - 1);
                    lastOffset = ((View)childView).getEndOffset();
                }
            }
            if ((endViewPart = wrapLine.endViewPart) != null) {
                nonEmptyLine = true;
                if (err == null && lastOffset != endViewPart.getStartOffset()) {
                    err = "endViewPart.getStartOffset()=" + endViewPart.getStartOffset() + " != lastOffset=" + lastOffset;
                }
                lastOffset = endViewPart.getEndOffset();
            }
            if (!nonEmptyLine && err == null) {
                err = "Empty";
            }
            if (err == null) continue;
            err = "WrapLine[" + i + "]: " + err;
            break;
        }
        return err;
    }

    String dumpWrapLine(EditorBoxView boxView, int wrapLineIndex) {
        return "Invalid wrapLine[" + wrapLineIndex + "]:\n" + this.toString((ParagraphView)boxView);
    }

    public String appendInfo(StringBuilder sb, ParagraphView paragraphView, int indent) {
        DocumentView docView;
        sb.append("\n");
        ArrayUtilities.appendSpaces((StringBuilder)sb, (int)indent);
        sb.append("childrenSpan:[").append(this.childrenWidth);
        sb.append(",").append(this.childrenHeight);
        sb.append("], realSpan:[");
        if (paragraphView != null) {
            sb.append(paragraphView.getMajorAxisSpan()).append(",");
            sb.append(paragraphView.getMinorAxisSpan());
        } else {
            sb.append("<NULL>");
        }
        sb.append("]");
        if (paragraphView != null && (docView = paragraphView.getDocumentView()) != null) {
            float visibleWidth = docView.getVisibleWidth();
            sb.append(" visibleWidth=").append(visibleWidth);
        }
        int wrapLineCount = this.size();
        int digitCount = ArrayUtilities.digitCount((int)wrapLineCount);
        for (int i = 0; i < wrapLineCount; ++i) {
            sb.append("\n");
            ArrayUtilities.appendSpaces((StringBuilder)sb, (int)(indent + 2));
            ArrayUtilities.appendBracketedIndex((StringBuilder)sb, (int)i, (int)digitCount);
            WrapLine wrapLine = (WrapLine)this.get(i);
            sb.append("SV:");
            EditorView startViewPart = wrapLine.startViewPart;
            if (startViewPart != null) {
                sb.append("<").append(startViewPart.getStartOffset()).append(",");
                sb.append(startViewPart.getEndOffset()).append(">");
            } else {
                sb.append("NULL");
            }
            sb.append("; x=").append(wrapLine.startViewX);
            int startViewIndex = wrapLine.startViewIndex;
            int endViewIndex = wrapLine.endViewIndex;
            sb.append(" [").append(startViewIndex).append(",");
            sb.append(endViewIndex).append("] ");
            if (paragraphView != null && startViewIndex != endViewIndex) {
                if (startViewIndex > endViewIndex) {
                    sb.append("ERROR!!! startViewIndex=").append(startViewIndex);
                    sb.append(" > endViewIndex=").append(endViewIndex);
                } else {
                    int childCount = paragraphView.getViewCount();
                    if (startViewIndex == childCount) {
                        sb.append("<").append(paragraphView.getEndOffset()).append(">");
                    } else {
                        Object startChild = paragraphView.getEditorView(startViewIndex);
                        Object lastChild = paragraphView.getEditorView(endViewIndex - 1);
                        sb.append("<").append(((View)startChild).getStartOffset());
                        sb.append(",").append(((View)lastChild).getEndOffset()).append("> ");
                    }
                }
            }
            sb.append("EV:");
            EditorView endViewPart = wrapLine.endViewPart;
            if (endViewPart != null) {
                sb.append("<").append(endViewPart.getStartOffset()).append(",");
                sb.append(endViewPart.getEndOffset()).append(">");
                continue;
            }
            sb.append("NULL");
        }
        return sb.toString();
    }

    public String toString(ParagraphView paragraphView) {
        return this.appendInfo(new StringBuilder(200), paragraphView, 0);
    }

    public String toString() {
        return this.toString(null);
    }
}

