/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.Variable;
import org.netbeans.modules.cnd.debugger.gdb.models.AbstractVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.ValuePresenter;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class VariablesTableModel
implements TableModel,
Constants {
    private final GdbDebugger debugger;
    private static final Logger log = Logger.getLogger("gdb.logger");

    public VariablesTableModel(ContextProvider lookupProvider) {
        this.debugger = (GdbDebugger)lookupProvider.lookupFirst(null, GdbDebugger.class);
    }

    public Object getValueAt(Object row, String columnID) throws UnknownTypeException {
        if (this.debugger == null || !this.debugger.isStopped()) {
            return "";
        }
        if (columnID.equals("LocalsToString") || columnID.equals("WatchToString")) {
            if (row instanceof Variable) {
                return ValuePresenter.getValue((Variable)row);
            }
        } else if (columnID.equals("LocalsType") || columnID.equals("WatchType")) {
            if (row instanceof Variable) {
                return ((Variable)row).getType();
            }
        } else if ((columnID.equals("LocalsValue") || columnID.equals("WatchValue")) && row instanceof Variable) {
            return ValuePresenter.getValue((Variable)row);
        }
        if (row instanceof JToolTip) {
            if ((row = ((JToolTip)row).getClientProperty("getShortDescrption")) instanceof AbstractVariable) {
                return ((AbstractVariable)row).getType();
            }
            if (row == null) {
                return "";
            }
        }
        if (row.toString().startsWith("No current thread")) {
            return NbBundle.getMessage(VariablesTableModel.class, (String)"NoCurrentThreadVar");
        }
        throw new UnknownTypeException(row);
    }

    public boolean isReadOnly(Object row, String columnID) throws UnknownTypeException {
        if (row instanceof AbstractVariable) {
            AbstractVariable var = (AbstractVariable)row;
            if (this.debugger == null || !this.debugger.isStopped()) {
                return true;
            }
            if (columnID.equals("LocalsToString") || columnID.equals("WatchToString") || columnID.equals("LocalsType") || columnID.equals("WatchType")) {
                return true;
            }
            if (columnID.equals("LocalsValue") || columnID.equals("WatchValue")) {
                String t = var.getType();
                if (t == null) {
                    if (log.isLoggable(Level.FINE) && this.debugger.isStopped() && !SwingUtilities.isEventDispatchThread()) {
                        log.fine("VTM.isReadOnly: null type for " + var.getName() + " (state is " + (Object)((Object)this.debugger.getState()) + ")");
                    }
                    return false;
                }
                if (GdbUtils.isPointer(t)) {
                    return false;
                }
                if (t.length() == 0 && var.getValue() != null && var.getValue().equals("...")) {
                    return true;
                }
                return var.getFieldsCount() != 0;
            }
        } else {
            if (row.toString().startsWith("No current thread")) {
                return true;
            }
            if (row instanceof AbstractVariable.ErrorField) {
                return true;
            }
        }
        throw new UnknownTypeException(row);
    }

    public void setValueAt(Object row, String columnID, Object value) throws UnknownTypeException {
        if (this.debugger == null || !this.debugger.isStopped()) {
            return;
        }
        if (row instanceof Variable && (columnID.equals("LocalsValue") || columnID.equals("WatchValue"))) {
            ((Variable)row).setValue((String)value);
            return;
        }
        throw new UnknownTypeException(row);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }
}

