/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.modules.cnd.debugger.common.ui.VariablesViewButtons;
import org.netbeans.modules.cnd.debugger.gdb.GdbCallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.models.AbstractVariable;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class LocalsTreeModel
implements TreeModel,
PropertyChangeListener {
    private GdbDebugger debugger;
    private Listener listener;
    private final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();
    private static final Logger log = Logger.getLogger("gdb.logger");
    private Preferences preferences = NbPreferences.forModule(VariablesViewButtons.class).node("variables_view");
    private VariablesPreferenceChangeListener prefListener = new VariablesPreferenceChangeListener();
    private PropertyChangeListener[] varListeners;

    public LocalsTreeModel(ContextProvider lookupProvider) {
        this.debugger = (GdbDebugger)lookupProvider.lookupFirst(null, GdbDebugger.class);
        this.preferences.addPreferenceChangeListener(this.prefListener);
    }

    public Object getRoot() {
        return "Root";
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if ("var_value".equals(ev.getPropertyName())) {
            this.fireNodeChanged(ev.getSource());
        }
    }

    public Object[] getChildren(Object o, int from, int to) throws UnknownTypeException {
        Object[] ch;
        for (Object av : ch = this.getChildrenImpl(o)) {
            if (!(av instanceof AbstractVariable)) continue;
            ((AbstractVariable)av).addPropertyChangeListener(this);
        }
        return ch;
    }

    public Object[] getChildrenImpl(Object o) throws UnknownTypeException {
        if (o.equals("Root")) {
            Object[] res = VariablesViewButtons.isShowAutos() ? this.getAutos() : this.getLocalVariables();
            this.updateVarListeners((AbstractVariable[])res);
            return res;
        }
        if (o instanceof AbstractVariable) {
            AbstractVariable abstractVariable = (AbstractVariable)o;
            return abstractVariable.getFields();
        }
        return new AbstractVariable[0];
    }

    private void updateVarListeners(AbstractVariable[] vars) {
        this.varListeners = new PropertyChangeListener[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            PropertyChangeListener l;
            AbstractVariable var = vars[i];
            this.varListeners[i] = l = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    LocalsTreeModel.this.fireNodeChanged(evt.getSource());
                }
            };
            var.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)l, (Object)var));
        }
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node.equals("Root")) {
            return Integer.MAX_VALUE;
        }
        if (node instanceof AbstractVariable) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }

    public boolean isLeaf(Object o) throws UnknownTypeException {
        if (o.equals("Root")) {
            return false;
        }
        if (o instanceof AbstractVariable) {
            int i = ((AbstractVariable)o).getFieldsCount();
            return i == 0;
        }
        if (o.equals("NoInfo")) {
            return true;
        }
        if (o.equals("No current thread")) {
            return true;
        }
        if (o instanceof AbstractVariable.ErrorField) {
            return true;
        }
        throw new UnknownTypeException(o);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
        if (this.listener == null) {
            this.listener = new Listener(this, this.debugger);
        }
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
        if (this.listeners.isEmpty()) {
            this.listener.destroy();
            this.listener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireTreeChanged() {
        ArrayList<ModelListener> ls;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            ls = new ArrayList<ModelListener>(this.listeners);
        }
        for (ModelListener l : ls) {
            l.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTableValueChanged(Object node, String propertyName) {
        ArrayList<ModelListener> ls;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            ls = new ArrayList<ModelListener>(this.listeners);
        }
        for (ModelListener l : ls) {
            l.modelChanged((ModelEvent)new ModelEvent.TableValueChanged((Object)this, node, propertyName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeChanged(Object node) {
        ArrayList<ModelListener> ls;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            ls = new ArrayList<ModelListener>(this.listeners);
        }
        for (ModelListener l : ls) {
            l.modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, node));
        }
    }

    private AbstractVariable[] getLocalVariables() {
        GdbCallStackFrame callStackFrame = this.debugger.getCurrentCallStackFrame();
        if (callStackFrame == null) {
            return new AbstractVariable[0];
        }
        return callStackFrame.getLocalVariables();
    }

    private AbstractVariable[] getAutos() {
        GdbCallStackFrame callStackFrame = this.debugger.getCurrentCallStackFrame();
        if (callStackFrame == null) {
            return new AbstractVariable[0];
        }
        AbstractVariable[] res = callStackFrame.getAutos();
        if (res != null) {
            return res;
        }
        return new AbstractVariable[0];
    }

    GdbDebugger getDebugger() {
        return this.debugger;
    }

    private class VariablesPreferenceChangeListener
    implements PreferenceChangeListener {
        private VariablesPreferenceChangeListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            String key = evt.getKey();
            if ("show_autos".equals(key)) {
                this.refresh();
            }
        }

        private void refresh() {
            try {
                LocalsTreeModel.this.fireTableValueChanged("Root", null);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                Exceptions.printStackTrace((Throwable)t);
            }
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private final GdbDebugger debugger;
        private final WeakReference<LocalsTreeModel> model;
        private RequestProcessor.Task task;

        public Listener(LocalsTreeModel tm, GdbDebugger debugger) {
            this.debugger = debugger;
            this.model = new WeakReference<LocalsTreeModel>(tm);
            debugger.addPropertyChangeListener(this);
        }

        void destroy() {
            this.debugger.removePropertyChangeListener(this);
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }

        private LocalsTreeModel getModel() {
            LocalsTreeModel tm = (LocalsTreeModel)this.model.get();
            if (tm == null) {
                this.destroy();
            }
            return tm;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ((e.getPropertyName().equals("currentCallStackFrame") || e.getPropertyName().equals("currentThread")) && this.debugger.isStopped()) {
                log.fine("LTM.propertyChange: Change for " + e.getPropertyName());
                final LocalsTreeModel ltm = this.getModel();
                if (ltm == null) {
                    return;
                }
                if (this.task != null) {
                    this.task.cancel();
                    this.task = null;
                }
                this.task = this.debugger.getRequestProcessor().post(new Runnable(){

                    @Override
                    public void run() {
                        if (Listener.this.debugger.isStopped()) {
                            ltm.fireTreeChanged();
                        }
                    }
                }, 500);
            } else if (e.getPropertyName().equals("state") && !this.debugger.isStopped() && this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
    }
}

