/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.modules.cnd.debugger.gdb.GdbCallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;

public class MakeCallerCurrentActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private GdbDebugger debugger;

    public MakeCallerCurrentActionProvider(ContextProvider lookupProvider) {
        this.debugger = (GdbDebugger)lookupProvider.lookupFirst(null, GdbDebugger.class);
        this.debugger.addPropertyChangeListener("currentCallStackFrame", this);
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_MAKE_CALLER_CURRENT);
    }

    public void doAction(Object action) {
        int i = MakeCallerCurrentActionProvider.getCurrentCallStackFrameIndex(this.debugger);
        if (i < this.debugger.getStackDepth() - 1) {
            MakeCallerCurrentActionProvider.setCurrentCallStackFrameIndex(this.debugger, i + 1);
        }
    }

    private void checkEnabled(boolean stoppped) {
        if (stoppped) {
            int i = MakeCallerCurrentActionProvider.getCurrentCallStackFrameIndex(this.debugger);
            this.setEnabled(ActionsManager.ACTION_MAKE_CALLER_CURRENT, i < this.debugger.getStackDepth() - 1);
        } else {
            this.setEnabled(ActionsManager.ACTION_MAKE_CALLER_CURRENT, false);
        }
    }

    static int getCurrentCallStackFrameIndex(GdbDebugger debugger) {
        GdbCallStackFrame csf = debugger.getCurrentCallStackFrame();
        if (csf != null) {
            return csf.getFrameNumber();
        }
        return -1;
    }

    static void setCurrentCallStackFrameIndex(GdbDebugger debugger, int index) {
        if (index < debugger.getStackDepth()) {
            GdbCallStackFrame csf = debugger.getCallStack().get(index);
            csf.makeCurrent();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.checkEnabled(this.debugger.isStopped());
    }
}

