/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.collab.chat.ChatNotifications;
import org.netbeans.modules.kenai.collab.chat.ChatTopComponent;
import org.netbeans.modules.kenai.collab.chat.CreateChatAction;
import org.netbeans.modules.kenai.collab.chat.KenaiConnection;
import org.netbeans.modules.kenai.collab.chat.MessagingHandleImpl;
import org.netbeans.modules.kenai.ui.spi.MessagingAccessor;
import org.netbeans.modules.kenai.ui.spi.MessagingHandle;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;

public class MessagingAccessorImpl
extends MessagingAccessor {
    @Override
    public MessagingHandle getMessaging(ProjectHandle project) {
        Kenai k = project.getKenaiProject().getKenai();
        KenaiConnection kc = KenaiConnection.getDefault(k);
        try {
            KenaiProject prj = project.getKenaiProject();
            if (prj.isMyProject() && k.getStatus() == Kenai.Status.ONLINE) {
                MultiUserChat chat = kc.getChat(project.getId());
                if (chat == null) {
                    KenaiFeature[] f = prj.getFeatures(KenaiService.Type.CHAT);
                    if (!(f.length != 1 || (chat = kc.getChat(f[0])) != null && chat.isJoined())) {
                        throw new RuntimeException();
                    }
                } else if (!chat.isJoined()) {
                    kc.tryJoinChat(chat);
                    if (!chat.isJoined()) {
                        throw new RuntimeException();
                    }
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(MessagingAccessorImpl.class.getName()).log(Level.INFO, ex.getMessage(), ex);
            MessagingHandleImpl m = new MessagingHandleImpl(project.getKenaiProject());
            m.setMessageCount(0);
            m.setOnlineCount(-3);
            return m;
        }
        return ChatNotifications.getDefault().getMessagingHandle(project.getKenaiProject());
    }

    @Override
    public Action getOpenMessagesAction(final ProjectHandle project) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ChatTopComponent chatTC = ChatTopComponent.findInstance();
                chatTC.open();
                chatTC.setActiveGroup(project.getId() + "@muc." + project.getKenaiProject().getKenai().getUrl().getHost());
                chatTC.requestActive(false);
            }
        };
    }

    @Override
    public Action getCreateChatAction(ProjectHandle project) {
        return new CreateChatAction(project.getKenaiProject());
    }

    @Override
    public Action getReconnectAction(final ProjectHandle project) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                project.firePropertyChange("content", null, null);
            }
        };
    }
}

