/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.kenai.collab.chat.ChatNotifications;
import org.netbeans.modules.kenai.collab.chat.ChatTopComponent;
import org.netbeans.modules.kenai.collab.chat.ContactListItem;
import org.netbeans.modules.kenai.collab.chat.FakeRosterGroup;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class GroupListItem
implements ContactListItem {
    private FakeRosterGroup group;
    private static ImageIcon GROUP = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/kenai/collab/resources/chatroom_online.png"));

    public GroupListItem(FakeRosterGroup group) {
        this.group = group;
    }

    public String toString() {
        return NbBundle.getMessage(GroupListItem.class, (String)"ChatRoomRenderer", (Object)this.group.getDisplayName());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupListItem other = (GroupListItem)obj;
        return this.group == other.group || this.group != null && this.group.equals(other.group);
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.group != null ? this.group.hashCode() : 0);
        return hash;
    }

    @Override
    public void openChat() {
        ChatTopComponent.findInstance().setActiveGroup(this.group.getJid());
    }

    @Override
    public Icon getIcon() {
        return GROUP;
    }

    @Override
    public boolean hasMessages() {
        return ChatNotifications.getDefault().getMessagingHandle(this.group.getKenaiProject()).getMessageCount() > 0;
    }

    @Override
    public String getKenaiName() {
        return this.group.getKenaiProject().getKenai().getName();
    }
}

