/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.refactoring.PositionBoundsResolver;
import org.netbeans.modules.web.refactoring.WebRefactoring;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public abstract class TldRefactoring
implements WebRefactoring {
    private static final Logger LOGGER = Logger.getLogger(TldRefactoring.class.getName());

    @Override
    public Problem preCheck() {
        return null;
    }

    protected List<TaglibHandle> getTaglibs(WebModule webModule) {
        FileObject fileObject = webModule.getWebInf();
        if (fileObject == null) {
            return Collections.emptyList();
        }
        ArrayList<TaglibHandle> arrayList = new ArrayList<TaglibHandle>();
        Enumeration enumeration = fileObject.getChildren(true);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (!this.isTld(fileObject2)) continue;
            Taglib taglib = null;
            try {
                taglib = this.getTaglib(fileObject2);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.FINE, "Failed to create Taglib graph for " + fileObject2, iOException);
            }
            arrayList.add(new TaglibHandle(taglib, fileObject2));
        }
        return arrayList;
    }

    private boolean isTld(FileObject fileObject) {
        return "tld".equalsIgnoreCase(fileObject.getExt());
    }

    private Taglib getTaglib(FileObject fileObject) throws IOException {
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        Taglib taglib = null;
        if (dataObject instanceof TLDDataObject) {
            taglib = ((TLDDataObject)dataObject).getTaglib();
        }
        return taglib;
    }

    protected static abstract class TldRefactoringElement
    extends SimpleRefactoringElementImplementation {
        protected final Taglib taglib;
        protected final FileObject tldFile;
        protected final String clazz;

        public TldRefactoringElement(String string, Taglib taglib, FileObject fileObject) {
            this.clazz = string;
            this.taglib = taglib;
            this.tldFile = fileObject;
        }

        public String getText() {
            return this.getDisplayText();
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.tldFile;
        }

        public PositionBounds getPosition() {
            try {
                return new PositionBoundsResolver(DataObject.find((FileObject)this.tldFile), this.clazz).getPositionBounds();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                return null;
            }
        }

        protected void write() {
            try {
                TLDDataObject tLDDataObject = (TLDDataObject)DataObject.find((FileObject)this.tldFile);
                if (tLDDataObject != null) {
                    tLDDataObject.write(this.taglib);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    protected static class TaglibHandle {
        private final Taglib taglib;
        private final FileObject tldFile;
        private final boolean valid;

        private TaglibHandle(Taglib taglib, FileObject fileObject) {
            this.taglib = taglib;
            this.tldFile = fileObject;
            this.valid = taglib != null;
        }

        public Taglib getTaglib() {
            return this.taglib;
        }

        public FileObject getTldFile() {
            return this.tldFile;
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

