/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.navigator;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.model.Model;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.build.model.ModelLineage;
import org.apache.maven.project.build.model.ModelLineageIterator;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.navigator.ROUtil;
import org.openide.actions.EditAction;
import org.openide.cookies.EditCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class POMInheritancePanel
extends JPanel
implements ExplorerManager.Provider,
Runnable {
    private transient ExplorerManager explorerManager = new ExplorerManager();
    private BeanTreeView treeView;
    private DataObject current;
    private FileChangeAdapter adapter = new FileChangeAdapter(){

        public void fileChanged(FileEvent fe) {
            POMInheritancePanel.this.showWaitNode();
            RequestProcessor.getDefault().post((Runnable)POMInheritancePanel.this);
        }
    };
    private JScrollPane jScrollPane1;

    public POMInheritancePanel() {
        this.initComponents();
        this.treeView = (BeanTreeView)this.jScrollPane1;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    void navigate(DataObject d) {
        if (this.current != null) {
            this.current.getPrimaryFile().removeFileChangeListener((FileChangeListener)this.adapter);
        }
        this.current = d;
        this.current.getPrimaryFile().addFileChangeListener((FileChangeListener)this.adapter);
        this.showWaitNode();
        RequestProcessor.getDefault().post((Runnable)this);
    }

    @Override
    public void run() {
        if (this.current != null && "text/x-maven-pom+xml".equals(this.current.getPrimaryFile().getMIMEType())) {
            File file = FileUtil.toFile((FileObject)this.current.getPrimaryFile());
            if (file != null) {
                try {
                    ModelLineage lin = EmbedderFactory.createModelLineage((File)file, (MavenEmbedder)EmbedderFactory.getOnlineEmbedder(), (boolean)false);
                    PomChildren ch = new PomChildren(lin);
                    SwingUtilities.invokeLater(new Runnable((Children)ch){
                        final /* synthetic */ Children val$ch;
                        {
                            this.val$ch = children;
                        }

                        @Override
                        public void run() {
                            POMInheritancePanel.this.treeView.setRootVisible(false);
                            POMInheritancePanel.this.explorerManager.setRootContext((Node)new AbstractNode(this.val$ch));
                        }
                    });
                }
                catch (ProjectBuildingException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Error reading model lineage", ex);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            POMInheritancePanel.this.treeView.setRootVisible(true);
                            POMInheritancePanel.this.explorerManager.setRootContext(POMInheritancePanel.createErrorNode());
                        }
                    });
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        POMInheritancePanel.this.treeView.setRootVisible(false);
                        POMInheritancePanel.this.explorerManager.setRootContext(POMInheritancePanel.createEmptyNode());
                    }
                });
            }
        }
    }

    void release() {
        if (this.current != null) {
            this.current.getPrimaryFile().removeFileChangeListener((FileChangeListener)this.adapter);
        }
        this.current = null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                POMInheritancePanel.this.treeView.setRootVisible(false);
                POMInheritancePanel.this.explorerManager.setRootContext(POMInheritancePanel.createEmptyNode());
            }
        });
    }

    public void showWaitNode() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                POMInheritancePanel.this.treeView.setRootVisible(true);
                POMInheritancePanel.this.explorerManager.setRootContext(POMInheritancePanel.createWaitNode());
            }
        });
    }

    private void initComponents() {
        this.jScrollPane1 = new BeanTreeView();
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 292, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 307, Short.MAX_VALUE));
    }

    private static Node createWaitNode() {
        AbstractNode an = new AbstractNode(Children.LEAF);
        an.setIconBaseWithExtension("org/netbeans/modules/maven/navigator/wait.gif");
        an.setDisplayName(NbBundle.getMessage(POMInheritancePanel.class, (String)"LBL_Wait"));
        return an;
    }

    private static Node createEmptyNode() {
        AbstractNode an = new AbstractNode(Children.LEAF);
        return an;
    }

    private static Node createErrorNode() {
        AbstractNode an = new AbstractNode(Children.LEAF);
        an.setDisplayName(NbBundle.getMessage(POMInheritancePanel.class, (String)"LBL_Error"));
        return an;
    }

    private static class POMNode
    extends AbstractNode {
        private Image icon = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/navigator/Maven2Icon.gif");
        private boolean readonly = false;

        private POMNode(File key, Model mdl, Lookup lkp, String parentVersion) {
            super(Children.LEAF, lkp);
            String version = mdl.getVersion();
            if (version == null) {
                version = parentVersion;
            }
            this.setDisplayName(NbBundle.getMessage(POMInheritancePanel.class, (String)"TITLE_PomNode", (Object)mdl.getArtifactId(), (Object)version));
            if (key.getName().endsWith("pom")) {
                this.readonly = true;
            }
            this.setShortDescription(key.getAbsolutePath());
        }

        public Action[] getActions(boolean context) {
            return new Action[]{new MyEditAction()};
        }

        public Action getPreferredAction() {
            return EditAction.get(EditAction.class);
        }

        public String getHtmlDisplayName() {
            if (this.readonly) {
                return NbBundle.getMessage(POMInheritancePanel.class, (String)"HTML_TITLE_PomNode", (Object)this.getDisplayName());
            }
            return null;
        }

        public Image getIcon(int type) {
            return this.icon;
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        private class MyEditAction
        extends AbstractAction {
            public MyEditAction() {
                this.putValue("Name", NbBundle.getMessage(POMInheritancePanel.class, (String)"ACTION_Edit"));
                this.setEnabled(true);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                EditCookie ec = (EditCookie)POMNode.this.getLookup().lookup(EditCookie.class);
                if (ec != null) {
                    ec.edit();
                }
            }
        }
    }

    private static class PomChildren
    extends Children.Keys<ModelLineage> {
        public PomChildren(ModelLineage lineage) {
            this.setKeys(new ModelLineage[]{lineage});
        }

        protected Node[] createNodes(ModelLineage key) {
            ModelLineageIterator it = key.reversedLineageIterator();
            ArrayList<POMNode> nds = new ArrayList<POMNode>();
            String parentVersion = null;
            while (it.hasNext()) {
                it.next();
                Model mdl = it.getModel();
                File fl = FileUtil.normalizeFile((File)it.getPOMFile());
                FileObject fo = FileUtil.toFileObject((File)fl);
                InstanceContent ic = new InstanceContent();
                if (fo != null) {
                    try {
                        DataObject dobj = DataObject.find((FileObject)ROUtil.checkPOMFileObjectReadOnly(fo, fl));
                        if (dobj != null) {
                            ic.add((Object)dobj);
                            EditCookie ec = (EditCookie)dobj.getLookup().lookup(EditCookie.class);
                            if (ec != null) {
                                ic.add((Object)ec);
                            }
                        }
                    }
                    catch (DataObjectNotFoundException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                nds.add(0, new POMNode(fl, mdl, (Lookup)new AbstractLookup((AbstractLookup.Content)ic), parentVersion));
                if (mdl.getVersion() == null) continue;
                parentVersion = mdl.getVersion();
            }
            return nds.toArray(new Node[0]);
        }
    }
}

