/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.palette;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import org.netbeans.modules.mobility.svgcore.palette.SVGPaletteItemData;
import org.netbeans.modules.mobility.svgcore.palette.SVGPaletteItemDataObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.ExTransferable;

public final class SVGPaletteItemDataNode
extends DataNode {
    private static final String IMAGE_ICON_BASE = "org/netbeans/modules/mobility/svgcore/resources/svg.png";

    SVGPaletteItemDataNode(SVGPaletteItemDataObject obj, Lookup lookup) {
        super((DataObject)obj, Children.LEAF, lookup);
        this.setIconBaseWithExtension(IMAGE_ICON_BASE);
    }

    public String getName() {
        return this.getData().getName();
    }

    public String getShortDescription() {
        return this.getData().getFilePath();
    }

    public Image getIcon(int type) {
        if (type == 2 || type == 4) {
            return this.getData().getIcon32();
        }
        return super.getIcon(type);
    }

    public String getDisplayName() {
        return this.getData().getDisplayName();
    }

    public boolean canRename() {
        return false;
    }

    private SVGPaletteItemData getData() {
        return ((SVGPaletteItemDataObject)this.getDataObject()).getData();
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable t = ExTransferable.create((Transferable)super.clipboardCopy());
        Lookup lookup = this.getLookup();
        ActiveEditorDrop drop = (ActiveEditorDrop)lookup.lookup(ActiveEditorDrop.class);
        ActiveEditorDropTransferable s = new ActiveEditorDropTransferable(drop);
        t.put((ExTransferable.Single)s);
        return new NoExternalDndTransferable((Transferable)t);
    }

    private static class NoExternalDndTransferable
    implements Transferable {
        private Transferable t;
        private DataFlavor uriListFlavor;

        public NoExternalDndTransferable(Transferable t) {
            this.t = t;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = this.t.getTransferDataFlavors();
            if (this.t.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || this.t.isDataFlavorSupported(this.getUriListFlavor())) {
                ArrayList<DataFlavor> tmp = new ArrayList<DataFlavor>(flavors.length);
                for (int i = 0; i < flavors.length; ++i) {
                    if (!this.isDataFlavorSupported(flavors[i])) continue;
                    tmp.add(flavors[i]);
                }
                flavors = tmp.toArray(new DataFlavor[tmp.size()]);
            }
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            if (DataFlavor.javaFileListFlavor.equals(flavor) || this.getUriListFlavor().equals(flavor)) {
                return false;
            }
            return this.t.isDataFlavorSupported(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.t.getTransferData(flavor);
        }

        private DataFlavor getUriListFlavor() {
            if (null == this.uriListFlavor) {
                try {
                    this.uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
                }
                catch (ClassNotFoundException ex) {
                    throw new AssertionError((Object)ex);
                }
            }
            return this.uriListFlavor;
        }
    }

    private static class ActiveEditorDropTransferable
    extends ExTransferable.Single {
        private ActiveEditorDrop drop;

        ActiveEditorDropTransferable(ActiveEditorDrop drop) {
            super(ActiveEditorDrop.FLAVOR);
            this.drop = drop;
        }

        public Object getData() {
            return this.drop;
        }
    }
}

