/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.model;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.microedition.m2g.SVGImage;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.CharSeq;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentModel;
import org.netbeans.modules.editor.structure.api.DocumentModelException;
import org.netbeans.modules.editor.structure.api.DocumentModelListener;
import org.netbeans.modules.editor.structure.api.DocumentModelStateListener;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.PerseusController;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.model.ElementMapping;
import org.netbeans.modules.mobility.svgcore.model.EncodingInputStream;
import org.netbeans.modules.mobility.svgcore.view.source.SVGSourceMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewEditorSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.w3c.dom.svg.SVGRect;

public final class SVGFileModel {
    protected static final int MAX_TOOLTIP_ATTR_SIZE = 100;
    protected static final String XML_TAG = "tag";
    protected static final String XML_EMPTY_TAG = "empty_tag";
    protected static final String XML_ERROR_TAG = "error";
    protected static final String[] ANIMATION_TAGS = new String[]{"animate", "animateTransform", "animateMotion", "animateColor", "set"};
    protected static final String TRANSACTION_TOKEN = "transaction";
    protected static final String MODEL_UPDATE_TOKEN = "update";
    private static final Logger LOG = Logger.getLogger(SVGFileModel.class.getName());
    private final XmlMultiViewEditorSupport m_edSup;
    private final ElementMapping m_mapping;
    private final List<ModelListener> m_modelListeners = new ArrayList<ModelListener>();
    private final Object m_lock = new Object();
    private final Object m_transactionLock = new Object();
    private volatile BaseDocument m_bDoc;
    private DocumentModel m_model;
    private boolean m_isChanged = true;
    private volatile boolean m_eventInProgress = false;
    private volatile boolean m_sourceChanged = false;
    private volatile boolean m_updateInProgress = false;
    private volatile boolean m_updateInProcess = false;
    private volatile int[] m_transactionCounter = new int[]{0};
    private final DocumentListener m_docListener = new DocumentListener(){

        @Override
        public void removeUpdate(DocumentEvent e) {
            SVGFileModel.this.documentModified(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SVGFileModel.this.documentModified(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (e.getLength() > 0 || e.getOffset() > 0 || e.getType() != DocumentEvent.EventType.CHANGE) {
                SVGFileModel.this.documentModified(e);
            }
        }
    };
    private final DocumentModelListener m_modelListener = new DocumentModelListener(){

        public void documentElementRemoved(DocumentElement de) {
            if (SVGFileModel.isTagElement(de)) {
                SceneManager.log(Level.FINEST, "Element removed: " + de);
                SVGFileModel.this.m_mapping.remove(de);
                SVGFileModel.this.fireModelChange();
            }
        }

        public void documentElementChanged(DocumentElement de) {
            if (SVGFileModel.isTagElement(de)) {
                SceneManager.log(Level.FINEST, "Element changed: " + de);
                SVGFileModel.this.fireModelChange();
            }
        }

        public void documentElementAttributesChanged(DocumentElement de) {
            if (SVGFileModel.isTagElement(de)) {
                SceneManager.log(Level.FINEST, "Element attr changed: " + de);
                SVGFileModel.this.fireModelChange();
            }
        }

        public void documentElementAdded(DocumentElement de) {
            if (SVGFileModel.isTagElement(de)) {
                SceneManager.log(Level.FINEST, "Element added: " + de);
                SVGFileModel.this.m_mapping.add(de);
                SVGFileModel.this.fireModelChange();
            }
        }
    };
    private final DocumentModelStateListener m_modelStateListener = new DocumentModelStateListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sourceChanged() {
            Object object = SVGFileModel.this.m_lock;
            synchronized (object) {
                SceneManager.log(Level.FINEST, "Document source changed.");
                SVGFileModel.this.m_sourceChanged = true;
                SVGFileModel.this.m_lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scanningStarted() {
            Object object = SVGFileModel.this.m_lock;
            synchronized (object) {
                SceneManager.log(Level.FINEST, "Document scanning started.");
                SVGFileModel.this.getSceneManager().setBusyState(SVGFileModel.MODEL_UPDATE_TOKEN, true);
                SVGFileModel.this.m_updateInProgress = true;
                SVGFileModel.this.m_sourceChanged = false;
                SVGFileModel.this.m_lock.notifyAll();
            }
        }

        public void updateStarted() {
            SceneManager.log(Level.FINEST, "Model update started.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateFinished() {
            Object object = SVGFileModel.this.m_lock;
            synchronized (object) {
                SceneManager.log(Level.FINER, "Model update finished.");
                SVGFileModel.this.m_updateInProgress = false;
                SVGFileModel.this.m_lock.notifyAll();
                SVGFileModel.this.getSceneManager().setBusyState(SVGFileModel.MODEL_UPDATE_TOKEN, false);
            }
        }
    };
    private final Runnable m_updateTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SceneManager.log(Level.FINER, "Update task started.");
            try {
                List list = SVGFileModel.this.m_modelListeners;
                synchronized (list) {
                    for (int i = 0; i < SVGFileModel.this.m_modelListeners.size(); ++i) {
                        ((ModelListener)SVGFileModel.this.m_modelListeners.get(i)).modelChanged();
                    }
                }
            }
            finally {
                SceneManager.log(Level.FINER, "Update task finished.");
                SVGFileModel.this.m_eventInProgress = false;
            }
        }
    };

    public SVGFileModel(XmlMultiViewEditorSupport edSup) {
        this.m_edSup = edSup;
        this.m_model = null;
        this.m_mapping = new ElementMapping(this);
    }

    public synchronized void attachToOpenedDocument() {
        assert (SwingUtilities.isEventDispatchThread()) : "Model initialisation must be called from AWT thread!";
        if (this.m_bDoc == null) {
            this.m_bDoc = this.getOpenedDoc();
            SceneManager.log(Level.INFO, "Using already opened document.");
            assert (this.m_bDoc != null);
            this.m_bDoc.addDocumentListener(this.m_docListener);
        }
    }

    public synchronized void detachDocument() {
        this.m_model = null;
        this.m_bDoc = null;
        this.m_modelListeners.clear();
        SceneManager.log(Level.INFO, "Removing the document.");
    }

    private BaseDocument getOpenedDoc() {
        JEditorPane[] panes = this.m_edSup.getOpenedPanes();
        if (panes != null && panes.length > 0) {
            return (BaseDocument)panes[0].getDocument();
        }
        return null;
    }

    private SceneManager getSceneManager() {
        return this.getDataObject().getSceneManager();
    }

    public Object getTransactionMonitor() {
        return this.m_transactionLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int incrementTransactionCounter() {
        int[] nArray = this.m_transactionCounter;
        synchronized (this.m_transactionCounter) {
            this.m_transactionCounter[0] = this.m_transactionCounter[0] + 1;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_transactionCounter[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int decrementTransactionCounter() {
        int[] nArray = this.m_transactionCounter;
        synchronized (this.m_transactionCounter) {
            this.m_transactionCounter[0] = this.m_transactionCounter[0] - 1;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_transactionCounter[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTransactionCounter() {
        int[] nArray = this.m_transactionCounter;
        synchronized (this.m_transactionCounter) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_transactionCounter[0];
        }
    }

    private synchronized BaseDocument getDoc() {
        if (this.m_bDoc == null) {
            try {
                LOG.log(Level.INFO, "Opening new document.");
                this.m_bDoc = (BaseDocument)this.m_edSup.openDocument();
                assert (this.m_bDoc != null);
                this.m_bDoc.addDocumentListener(this.m_docListener);
            }
            catch (IOException ex) {
                LOG.warning("Could not open the document: " + ex.getMessage());
            }
        }
        return this.m_bDoc;
    }

    private synchronized void checkModel() {
        if (this.m_model == null) {
            try {
                BaseDocument doc = this.getDoc();
                if (doc != null && doc.getLength() > 0) {
                    this.m_model = DocumentModel.getDocumentModel((Document)doc);
                    this.m_model.addDocumentModelListener(this.m_modelListener);
                    this.m_model.addDocumentModelStateListener(this.m_modelStateListener);
                }
            }
            catch (DocumentModelException ex) {
                SceneManager.log(Level.WARNING, "Could not obtain document model ", ex);
            }
        }
    }

    public SVGDataObject getDataObject() {
        return (SVGDataObject)this.m_edSup.getDataObject();
    }

    public SVGImage parseSVGImage() throws IOException, BadLocationException, InterruptedException {
        SceneManager.log(Level.INFO, "Parsing image...");
        this.checkModel();
        SVGImage svgImage = this.m_mapping.parseDocument(true);
        SceneManager.log(Level.INFO, "Image parsed.");
        return svgImage;
    }

    public boolean isChanged() {
        return this.m_isChanged;
    }

    public void setChanged(boolean isChanged) {
        this.m_isChanged = isChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener listener) {
        List<ModelListener> list = this.m_modelListeners;
        synchronized (list) {
            this.m_modelListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener listener) {
        List<ModelListener> list = this.m_modelListeners;
        synchronized (list) {
            this.m_modelListeners.remove(listener);
        }
    }

    protected void documentModified(DocumentEvent e) {
        BaseDocumentEvent bde;
        if (e instanceof BaseDocumentEvent && ((bde = (BaseDocumentEvent)e).isInRedo() || bde.isInUndo() || this.getTransactionCounter() == 0)) {
            Thread.dumpStack();
            if (!this.m_updateInProcess) {
                this.m_updateInProcess = true;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SVGFileModel.this.m_updateInProcess = false;
                        SVGFileModel.this.getDataObject().fireContentChanged();
                    }
                });
            }
        }
        this.setChanged(true);
    }

    public synchronized DocumentModel getModel() {
        this.checkModel();
        return this.m_model;
    }

    public static boolean isTagElement(DocumentElement elem) {
        return elem != null && (elem.getType().equals(XML_TAG) || elem.getType().equals(XML_EMPTY_TAG));
    }

    public static boolean isError(DocumentElement elem) {
        return elem.getType().equals(XML_ERROR_TAG);
    }

    public static String getIdAttribute(DocumentElement de) {
        AttributeSet attrs = de.getAttributes();
        String id = (String)attrs.getAttribute("id");
        return id;
    }

    public static boolean isHiddenElement(DocumentElement de) {
        AttributeSet attrs = de.getAttributes();
        String visible = (String)attrs.getAttribute("visibility");
        return visible != null && visible.equals("hidden");
    }

    public static List<DocumentElement> getParents(DocumentElement elem) {
        ArrayList<DocumentElement> list = new ArrayList<DocumentElement>();
        while (elem != null) {
            list.add(elem);
            elem = elem.getParentElement();
        }
        return list;
    }

    public DocumentElement getElementById(String id) {
        this.checkModel();
        DocumentElement elem = this.m_mapping.id2element(id);
        return elem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceUpdateModel() {
        Object object = this.getTransactionMonitor();
        synchronized (object) {
            this.updateModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getElementAsText(String id) throws BadLocationException {
        Object object = this.getTransactionMonitor();
        synchronized (object) {
            this.updateModel();
            try {
                this.m_model.readLock();
                DocumentElement de = this.getElementById(id);
                if (de != null) {
                    BaseDocument doc = this.getDoc();
                    int startOffset = de.getStartOffset();
                    int endOffset = de.getEndOffset();
                    String string = doc.getText(startOffset, endOffset - startOffset + 1);
                    return string;
                }
                String string = null;
                return string;
            }
            finally {
                this.m_model.readUnlock();
            }
        }
    }

    public String getElementId(DocumentElement de) {
        String id = this.m_mapping.element2id(de);
        if (id == null) {
            id = "";
            System.out.println("Element " + de + " could not be found!");
        }
        return id;
    }

    public String createUniqueId(String prefix, boolean isWrapper) {
        return this.createUniqueId(prefix, isWrapper, null);
    }

    public String createUniqueId(String prefix, boolean isWrapper, Set<String> extIds) {
        return this.m_mapping.generateId(prefix, isWrapper, extIds);
    }

    public static boolean isWrapperId(String id) {
        return ElementMapping.isWrapperId(id);
    }

    public synchronized String describeElement(String id) {
        DocumentElement de = this.getElementById(id);
        if (de != null) {
            this.checkIntegrity(de);
            return SVGFileModel.describeElement(de);
        }
        return "";
    }

    public int firstIndexOf(String str) {
        CharSeq content = this.getDoc().getText();
        int charNum = content.length();
        int strLen = str.length();
        if (strLen > 0) {
            int j = 0;
            for (int i = 0; i < charNum; ++i) {
                if (content.charAt(i) == str.charAt(j)) {
                    if (++j != strLen) continue;
                    return i - j + 1;
                }
                j = 0;
            }
        }
        return -1;
    }

    public int[] getPositionByOffset(int offset) {
        Element root = this.getDoc().getDefaultRootElement();
        int lineCount = root.getElementCount();
        for (int i = 0; i < lineCount; ++i) {
            Element el = root.getElement(i);
            if (el.getEndOffset() <= offset) continue;
            assert (el.getStartOffset() <= offset);
            return new int[]{i + 1, offset - el.getStartOffset() + 1};
        }
        return null;
    }

    public int getOffsetByPosition(int line, int column) {
        Element root = this.getDoc().getDefaultRootElement();
        line = Math.max(line, 1);
        line = Math.min(line, root.getElementCount());
        int pos = root.getElement(line - 1).getStartOffset() + column;
        return pos;
    }

    protected static String describeElement(DocumentElement el) {
        StringBuilder sb = new StringBuilder();
        AttributeSet attrs = el.getAttributes();
        Enumeration<?> names = attrs.getAttributeNames();
        while (names.hasMoreElements()) {
            String attrName = (String)names.nextElement();
            sb.append("&nbsp;");
            sb.append(attrName);
            sb.append("=\"");
            Object o = attrs.getAttribute(attrName);
            if (o != null) {
                String value = o.toString();
                if (value.length() > 100) {
                    sb.append(value.substring(0, 100));
                    sb.append("...");
                } else {
                    sb.append(value);
                }
            }
            sb.append('\"');
            sb.append("&nbsp;<br>");
        }
        return sb.toString();
    }

    public static boolean isAnimation(DocumentElement elem) {
        String tagName = elem.getName();
        for (int i = 0; i < ANIMATION_TAGS.length; ++i) {
            if (!ANIMATION_TAGS[i].equals(tagName)) continue;
            return true;
        }
        return false;
    }

    private List<DocumentElement> collectFragmentsToDelete(CharSequence chars, DocumentElement de, List<DocumentElement> toDelete, List<String> removedIds) {
        assert (!toDelete.contains(de));
        toDelete.add(de);
        List<String> deletedIds = SVGFileModel.collectIds(de, new ArrayList<String>());
        if (removedIds != null) {
            removedIds.addAll(deletedIds);
        }
        DocumentElement root = this.m_model.getRootElement();
        ArrayList<ChangeDescriptor> references = new ArrayList<ChangeDescriptor>();
        for (String id : deletedIds) {
            SVGFileModel.resolveChanges(chars, root, id, id, references);
        }
        for (ChangeDescriptor reference : references) {
            DocumentElement elem = reference.m_elem;
            assert (elem != null);
            if (toDelete.contains(elem)) continue;
            this.collectFragmentsToDelete(chars, elem, toDelete, null);
        }
        return toDelete;
    }

    public void deleteElement(final String id, final TransactionCommand cmd) {
        this.runTransaction(new FileModelTransaction(){

            @Override
            protected void transaction() throws BadLocationException {
                final DocumentElement de = SVGFileModel.this.checkIntegrity(id);
                BaseDocument doc = SVGFileModel.this.getDoc();
                ArrayList deletedIds = new ArrayList();
                CharSequence chars = (CharSequence)doc.getProperty(CharSequence.class);
                List elemsToDelete = SVGFileModel.this.collectFragmentsToDelete(chars, de, new ArrayList(), deletedIds);
                block0: for (int i = elemsToDelete.size() - 1; i >= 0; --i) {
                    DocumentElement di = (DocumentElement)elemsToDelete.get(i);
                    int start = di.getStartOffset();
                    int end = di.getEndOffset();
                    for (int j = elemsToDelete.size() - 1; j >= 0; --j) {
                        DocumentElement dj;
                        if (j == i || (dj = (DocumentElement)elemsToDelete.get(j)).getStartOffset() > start || dj.getEndOffset() < end) continue;
                        elemsToDelete.remove(i);
                        continue block0;
                    }
                }
                if (elemsToDelete.size() > 1) {
                    Object response;
                    StringBuilder sb = new StringBuilder();
                    int count = 0;
                    for (String deletedId : deletedIds) {
                        sb.append('\t');
                        if (++count > 10) {
                            sb.append("...\n");
                            break;
                        }
                        sb.append(deletedId);
                        sb.append('\n');
                    }
                    if ((response = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(SVGFileModel.class, (String)"WARNING_IDReferences", (Object)sb.toString()), 1, 2))) == NotifyDescriptor.NO_OPTION) {
                        Collections.sort(elemsToDelete, new Comparator(){

                            public int compare(Object o1, Object o2) {
                                return ((DocumentElement)o2).getStartOffset() - ((DocumentElement)o1).getStartOffset();
                            }
                        });
                    } else if (response == NotifyDescriptor.YES_OPTION) {
                        elemsToDelete.clear();
                        elemsToDelete.add(de);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SVGSourceMultiViewElement.selectPosition(SVGFileModel.this.getDataObject(), de.getStartOffset(), true);
                            }
                        });
                    } else {
                        if (response == NotifyDescriptor.CANCEL_OPTION || response == NotifyDescriptor.CLOSED_OPTION) {
                            return;
                        }
                        assert (false) : "Unknown option: " + response;
                    }
                }
                int lastStartOff = Integer.MAX_VALUE;
                ArrayList<String> idsToDelete = new ArrayList<String>(elemsToDelete.size());
                for (DocumentElement elemToDelete : elemsToDelete) {
                    int startOff = elemToDelete.getStartOffset();
                    int endOff = elemToDelete.getEndOffset();
                    assert (startOff >= 0);
                    assert (endOff > startOff);
                    assert (endOff <= lastStartOff);
                    lastStartOff = startOff;
                    String id2 = SVGFileModel.getIdAttribute(elemToDelete);
                    if (id2 == null) {
                        id2 = SVGFileModel.this.getElementId(elemToDelete);
                    }
                    if (id2 != null) {
                        idsToDelete.add(id2);
                    }
                    SVGFileModel.removeFragment(doc, chars, startOff, endOff);
                }
                if (!idsToDelete.isEmpty()) {
                    cmd.execute(idsToDelete);
                }
            }
        });
    }

    private static void removeFragment(BaseDocument doc, CharSequence chars, int startOff, int endOff) throws BadLocationException {
        char c;
        int origStart = startOff;
        int origEnd = endOff;
        boolean newLineFound = false;
        while (startOff > 0 && (c = chars.charAt(startOff - 1)) <= ' ') {
            if (c == '\n') {
                newLineFound = true;
            }
            --startOff;
        }
        int length = chars.length() - 1;
        while (endOff < length && (c = chars.charAt(endOff + 1)) <= ' ') {
            if (c == '\n') {
                newLineFound = true;
            }
            ++endOff;
        }
        int i = startOff;
        int j = endOff;
        while (newLineFound) {
            if (i < origStart && chars.charAt(i++) == '\n') {
                startOff = i;
                break;
            }
            if (j <= origEnd || chars.charAt(j--) != '\n') continue;
            endOff = j;
            break;
        }
        doc.remove(startOff, endOff - startOff + 1);
    }

    public void appendElement(final String insertString) {
        this.runTransaction(new FileModelTransaction(true){

            @Override
            protected void transaction() throws BadLocationException {
                DocumentElement svgRoot = SVGFileModel.getSVGRoot(SVGFileModel.this.m_model);
                if (svgRoot != null) {
                    BaseDocument doc = SVGFileModel.this.getDoc();
                    List children = svgRoot.getChildren();
                    DocumentElement lastChild = SVGFileModel.getLastTagChild(children);
                    if (lastChild != null) {
                        CharSequence chars = (CharSequence)doc.getProperty(CharSequence.class);
                        lastChild = SVGFileModel.getLastVisibleTagChild(children);
                        int insertPosition = lastChild.getEndOffset() + 1;
                        String str = insertString;
                        int i = insertPosition;
                        while (i > 0) {
                            char c;
                            if ((c = chars.charAt(--i)) <= ' ') {
                                if (c != '\n') continue;
                                break;
                            }
                            str = '\n' + str;
                            break;
                        }
                        doc.insertString(insertPosition, str, null);
                        Reformat.get((Document)doc).reformat(insertPosition, insertPosition + str.length() + 1);
                    } else {
                        String docText = doc.getText(0, doc.getLength());
                        int startOff = svgRoot.getStartOffset();
                        int c = 0;
                        int insertPosition = svgRoot.getEndOffset() - 1;
                        while (insertPosition > startOff) {
                            char c2 = docText.charAt(insertPosition--);
                            c = c2;
                            if (c2 != '/') continue;
                        }
                        if (c == 47) {
                            if (docText.charAt(insertPosition) == '<') {
                                doc.insertString(insertPosition, insertString, null);
                                Reformat.get((Document)doc).reformat(insertPosition, insertPosition + insertString.length() + 1);
                            } else {
                                StringBuilder sb = new StringBuilder(docText.substring(startOff, insertPosition + 1));
                                sb.append(">\n");
                                sb.append(insertString);
                                sb.append("\n</svg>");
                                doc.replace(startOff, svgRoot.getEndOffset() - startOff + 1, sb.toString(), null);
                                Reformat.get((Document)doc).reformat(insertPosition, doc.getLength());
                            }
                        }
                    }
                }
            }
        });
    }

    private static String getElemTextWithId(BaseDocument doc, DocumentElement de, String id) throws BadLocationException {
        String elemText;
        int startOffset = de.getStartOffset();
        if (de.getAttributes().isDefined("id")) {
            elemText = doc.getText(startOffset, de.getEndOffset() - startOffset + 1);
        } else {
            String tag = de.getName();
            startOffset += 1 + tag.length();
            StringBuilder sb = new StringBuilder("<");
            sb.append(tag);
            sb.append(' ');
            SVGFileModel.injectId(sb, id);
            sb.append(doc.getText(startOffset, de.getEndOffset() - startOffset + 1));
            elemText = sb.toString();
        }
        return elemText;
    }

    private static StringBuilder injectId(StringBuilder sb, String id) {
        sb.append("id");
        sb.append("=\"");
        sb.append(id);
        sb.append("\" ");
        return sb;
    }

    public void setViewBox(SVGRect rect) {
        if (rect == null) {
            return;
        }
        final DocumentElement svgRoot = SVGFileModel.getSVGRoot(this.m_model);
        final String[] attributes = new String[]{"viewBox", rect.getX() + " " + rect.getY() + " " + rect.getWidth() + " " + rect.getHeight(), "width", String.valueOf(rect.getWidth()), "height", String.valueOf(rect.getHeight())};
        this.runTransaction(new FileModelTransaction(){

            @Override
            protected void transaction() throws BadLocationException {
                SVGFileModel.this.doSetAttributes(svgRoot, attributes, null, false);
            }
        });
    }

    public void setAttributes(final String id, final String[] attributes) {
        this.runTransaction(new FileModelTransaction(){

            @Override
            protected void transaction() throws BadLocationException {
                DocumentElement elem = SVGFileModel.this.checkIntegrity(id);
                SVGFileModel.this.doSetAttributes(elem, attributes, id, true);
            }
        });
    }

    public void setAttributes(final Map<String, String[]> attributesById, final Map<DocumentElement, String[]> attributesByElement) {
        this.runTransaction(new FileModelTransaction(){

            @Override
            protected void transaction() throws BadLocationException {
                String[] attributes;
                if (attributesById != null) {
                    for (String id : attributesById.keySet()) {
                        attributes = (String[])attributesById.get(id);
                        DocumentElement elem = SVGFileModel.this.checkIntegrity(id);
                        SVGFileModel.this.doSetAttributes(elem, attributes, id, true);
                    }
                }
                if (attributesByElement != null) {
                    for (DocumentElement elem : attributesByElement.keySet()) {
                        attributes = (String[])attributesByElement.get(elem);
                        SVGFileModel.this.doSetAttributes(elem, attributes, null, false);
                    }
                }
            }
        });
    }

    private void doSetAttributes(DocumentElement elem, String[] attributes, String id, boolean addIdAttribute) throws BadLocationException {
        assert (SVGFileModel.isTagElement(elem)) : "Attribute change allowed only for tag elements";
        int startOff = elem.getStartOffset() + 1 + elem.getName().length();
        boolean injectId = addIdAttribute && id != null && !elem.getAttributes().isDefined("id");
        List children = elem.getChildren();
        int endOff = children.size() > 0 ? ((DocumentElement)children.get(0)).getStartOffset() - 1 : elem.getEndOffset() - 1;
        assert (attributes.length % 2 == 0);
        BaseDocument doc = this.getDoc();
        block0: for (int i = 0; i < attributes.length; i += 2) {
            String fragment = doc.getText(startOff, endOff - startOff + 1);
            String attrName = attributes[i];
            String attrValue = attributes[i + 1];
            int p = SVGFileModel.indexOfAttr(fragment, attrName);
            if (p != -1) {
                int start = p;
                p += attrName.length();
                while (++p < fragment.length()) {
                    if (fragment.charAt(p) != '\"') continue;
                    int q = p;
                    while (++q < fragment.length()) {
                        int l;
                        if (fragment.charAt(q) != '\"') continue;
                        ++p;
                        if (attrValue != null) {
                            String txt;
                            if (injectId) {
                                StringBuilder sb = new StringBuilder(attrValue);
                                sb.append("\" ");
                                SVGFileModel.injectId(sb, id);
                                injectId = false;
                                l = q - p + 1;
                                txt = sb.toString();
                                doc.replace(startOff + p, l, txt, null);
                            } else {
                                l = q - p;
                                txt = attrValue;
                                doc.replace(startOff + p, l, txt, null);
                            }
                            endOff = endOff - l + txt.length();
                            continue block0;
                        }
                        l = q - start + 1;
                        doc.remove(startOff + start, l);
                        endOff -= l;
                        continue block0;
                    }
                }
                SceneManager.log(Level.SEVERE, "Attribute " + attrName + " not changed: \"" + fragment + "\"");
                continue;
            }
            if (attrValue == null) continue;
            StringBuilder sb = new StringBuilder(" ");
            if (injectId) {
                SVGFileModel.injectId(sb, id);
                injectId = false;
            }
            sb.append(attrName);
            sb.append("=\"");
            sb.append(attrValue);
            sb.append("\" ");
            String txt = sb.toString();
            doc.insertString(startOff, txt, null);
            endOff += txt.length();
        }
    }

    private static int skipWhite(String fragment, int index) {
        while (index < fragment.length()) {
            if (fragment.charAt(index) > ' ') {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private static int indexOfAttr(String fragment, String attrName) {
        int index = 0;
        while ((index = fragment.indexOf(attrName, index)) != -1) {
            int p;
            int q = index;
            if (q >= 1 && fragment.charAt(q - 1) != ' ' || (p = SVGFileModel.skipWhite(fragment, index += attrName.length())) == -1 || fragment.charAt(p) != '=' || (p = SVGFileModel.skipWhite(fragment, p + 1)) == -1 || fragment.charAt(p) != '\"') continue;
            return q;
        }
        return index;
    }

    public void setAttribute(final String id, final String attrName, final String attrValue) {
        this.runTransaction(new FileModelTransaction(){

            @Override
            protected void transaction() throws BadLocationException {
                DocumentElement elem = SVGFileModel.this.checkIntegrity(id);
                assert (SVGFileModel.isTagElement(elem)) : "Attribute change allowed only for tag elements";
                int startOff = elem.getStartOffset() + 1 + elem.getName().length();
                List children = elem.getChildren();
                int endOff = children.size() > 0 ? ((DocumentElement)children.get(0)).getStartOffset() - 1 : elem.getEndOffset() - 1;
                boolean injectId = !elem.getAttributes().isDefined("id");
                BaseDocument doc = SVGFileModel.this.getDoc();
                String fragment = doc.getText(startOff, endOff - startOff + 1);
                int p = fragment.indexOf(attrName);
                if (p != -1) {
                    p += attrName.length();
                    while (++p < fragment.length()) {
                        if (fragment.charAt(p) != '\"') continue;
                        int q = p;
                        while (++q < fragment.length()) {
                            if (fragment.charAt(q) != '\"') continue;
                            ++p;
                            if (injectId) {
                                StringBuilder sb = new StringBuilder(attrValue);
                                sb.append("\" ");
                                SVGFileModel.injectId(sb, id);
                                doc.replace(startOff + p, q - p + 1, sb.toString(), null);
                            } else {
                                doc.replace(startOff + p, q - p, attrValue, null);
                            }
                            return;
                        }
                    }
                    SceneManager.log(Level.SEVERE, "Attribute " + attrName + " not changed: \"" + fragment + "\"");
                } else {
                    StringBuilder sb = new StringBuilder(" ");
                    if (injectId) {
                        SVGFileModel.injectId(sb, id);
                    }
                    sb.append(attrName);
                    sb.append("=\"");
                    sb.append(attrValue);
                    sb.append("\" ");
                    doc.insertString(startOff, sb.toString(), null);
                }
            }
        });
    }

    public void moveToBottom(final String id) {
        this.runTransaction(new FileModelTransaction(){

            @Override
            protected void transaction() throws BadLocationException {
                DocumentElement firstChild;
                DocumentElement de = SVGFileModel.this.checkIntegrity(id);
                if (de != (firstChild = SVGFileModel.getFirstTagChild(de.getParentElement().getChildren()))) {
                    BaseDocument doc = SVGFileModel.this.getDoc();
                    int startOffset = de.getStartOffset();
                    int length = de.getEndOffset() - startOffset + 1;
                    String elemText = SVGFileModel.getElemTextWithId(doc, de, id);
                    int insertOffset = firstChild.getStartOffset();
                    assert (insertOffset < startOffset) : "Offset overlap #1" + insertOffset + "," + startOffset;
                    doc.remove(startOffset, length);
                    doc.insertString(insertOffset, elemText, null);
                }
            }
        });
    }

    public void moveToTop(final String id) {
        this.runTransaction(new FileModelTransaction(){

            @Override
            protected void transaction() throws BadLocationException {
                DocumentElement lastChild;
                DocumentElement de = SVGFileModel.this.checkIntegrity(id);
                if (de != (lastChild = SVGFileModel.getLastTagChild(de.getParentElement().getChildren()))) {
                    BaseDocument doc = SVGFileModel.this.getDoc();
                    int startOffset = de.getStartOffset();
                    int length = de.getEndOffset() - startOffset + 1;
                    String elemText = SVGFileModel.getElemTextWithId(doc, de, id);
                    int insertOffset = lastChild.getEndOffset() + 1;
                    assert (startOffset < insertOffset) : "Offset overlap #2" + insertOffset + "," + startOffset;
                    doc.insertString(insertOffset, elemText, null);
                    doc.remove(startOffset, length);
                }
            }
        });
    }

    public void moveForward(final String id) {
        this.runTransaction(new FileModelTransaction(){

            @Override
            protected void transaction() throws BadLocationException {
                DocumentElement de = SVGFileModel.this.checkIntegrity(id);
                DocumentElement nextChild = SVGFileModel.getNextTagSibling(de);
                if (nextChild != null) {
                    BaseDocument doc = SVGFileModel.this.getDoc();
                    int startOffset = de.getStartOffset();
                    int length = de.getEndOffset() - startOffset + 1;
                    String elemText = SVGFileModel.getElemTextWithId(doc, de, id);
                    int insertOffset = nextChild.getEndOffset() + 1;
                    assert (startOffset < insertOffset) : "Offset overlap #3" + insertOffset + "," + startOffset;
                    doc.insertString(insertOffset, elemText, null);
                    doc.remove(startOffset, length);
                }
            }
        });
    }

    public void moveBackward(final String id) {
        this.runTransaction(new FileModelTransaction(){

            @Override
            protected void transaction() throws BadLocationException {
                DocumentElement de = SVGFileModel.this.checkIntegrity(id);
                DocumentElement previousChild = SVGFileModel.getPreviousTagSibling(de);
                if (previousChild != null) {
                    BaseDocument doc = SVGFileModel.this.getDoc();
                    int startOffset = de.getStartOffset();
                    int length = de.getEndOffset() - startOffset + 1;
                    String elemText = SVGFileModel.getElemTextWithId(doc, de, id);
                    int insertOffset = previousChild.getStartOffset();
                    assert (startOffset > insertOffset) : "Offset overlap #4" + insertOffset + "," + startOffset;
                    doc.remove(startOffset, length);
                    doc.insertString(insertOffset, elemText, null);
                }
            }
        });
    }

    public static DocumentElement getSVGRoot(DocumentModel model) {
        DocumentElement root = model.getRootElement();
        for (DocumentElement de : root.getChildren()) {
            if (!SVGFileModel.isTagElement(de) || !"svg".equals(de.getName())) continue;
            return de;
        }
        return null;
    }

    protected synchronized void fireModelChange() {
        if (!this.m_eventInProgress) {
            SwingUtilities.invokeLater(this.m_updateTask);
        }
    }

    public void runTransaction(final FileModelTransaction transaction) {
        new Thread("TransactionWrapper"){

            @Override
            public void run() {
                transaction.run();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateModel() {
        SceneManager.log(Level.FINE, "Updating model...");
        this.checkModel();
        assert (!SwingUtilities.isEventDispatchThread()) : "Model update cannot be called in AWT thread.";
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_sourceChanged) {
                SceneManager.log(Level.FINE, "Forcing model update");
                this.m_model.forceUpdate();
            } else if (!this.m_updateInProgress) {
                SceneManager.log(Level.FINE, "Model already up to date.");
                return;
            }
            while (this.m_sourceChanged || this.m_updateInProgress) {
                SceneManager.log(Level.FINE, "Waiting for model update...");
                try {
                    this.m_lock.wait();
                    SceneManager.log(Level.FINE, "Wait ended.");
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        SceneManager.log(Level.FINE, "Model update completed.");
    }

    public String getSVGBody(File file, StringBuilder wrapperIDHolder) throws FileNotFoundException, IOException, DocumentModelException, DocumentModelException, BadLocationException {
        DocumentModel docModel = SVGFileModel.loadDocumentModel(file);
        String name = file.getName();
        String wrapperId = this.createUniqueId(name.replace('.', '_'), true);
        String textToInsert = this.getWithUniqueIds(docModel, wrapperId, true, null, true);
        textToInsert = SVGFileModel.wrapText(wrapperId, textToInsert);
        if (wrapperIDHolder != null) {
            wrapperIDHolder.insert(0, wrapperId);
        }
        return textToInsert;
    }

    public String mergeImage(File file) throws FileNotFoundException, IOException, DocumentModelException, BadLocationException {
        SceneManager.log(Level.INFO, "Merging file " + file.getPath());
        StringBuilder wrapperId = new StringBuilder();
        this.appendElement(this.getSVGBody(file, wrapperId));
        return wrapperId.toString();
    }

    public String mergeImage(String str, boolean wrap) throws IOException, DocumentModelException, BadLocationException {
        EncodingInputStream in = new EncodingInputStream(str, "UTF-8");
        return this.mergeImage(SVGFileModel.loadDocumentModel(in), wrap);
    }

    protected String mergeImage(DocumentModel docModel, boolean wrap) throws BadLocationException {
        String wrapperId = null;
        String textToInsert = null;
        if (wrap) {
            wrapperId = this.createUniqueId("", true);
            textToInsert = this.getWithUniqueIds(docModel, wrapperId, false, null, true);
            textToInsert = SVGFileModel.wrapText(wrapperId, textToInsert);
        } else {
            String[] rootId = new String[1];
            textToInsert = this.getWithUniqueIds(docModel, wrapperId, false, rootId, false);
            wrapperId = rootId[0];
        }
        this.appendElement(textToInsert);
        return wrapperId;
    }

    protected String getWithUniqueIds(DocumentModel docModel, String wrapperId, boolean isRootSvg, String[] rootId, boolean allowAnonymousRoot) throws BadLocationException {
        return this.getWithUniqueIds(docModel, wrapperId, isRootSvg, rootId, allowAnonymousRoot, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getWithUniqueIds(DocumentModel docModel, String wrapperId, boolean isRootSvg, String[] rootId, boolean allowAnonymousRoot, boolean silently) throws BadLocationException {
        try {
            List children;
            DocumentElement firstChild;
            docModel.readLock();
            DocumentElement rootElem = isRootSvg ? SVGFileModel.getSVGRoot(docModel) : docModel.getRootElement();
            Document doc = docModel.getDocument();
            String docText = null;
            if (rootElem != null && (firstChild = SVGFileModel.getFirstTagChild(children = rootElem.getChildren())) != null) {
                int startOff = firstChild.getStartOffset();
                int endOff = SVGFileModel.getLastTagChild(children).getEndOffset();
                if (rootId != null) {
                    rootId[0] = SVGFileModel.getIdAttribute(firstChild);
                }
                HashSet<String> newIds = new HashSet<String>();
                ArrayList<String> conflicts = new ArrayList<String>();
                StringBuilder conflictMsg = new StringBuilder();
                this.m_mapping.collectConflictingElements(rootElem, conflicts, newIds);
                if (!conflicts.isEmpty()) {
                    int length = doc.getLength();
                    StringBuilder sb = new StringBuilder(doc.getText(0, length));
                    ArrayList<ChangeDescriptor> changes = new ArrayList<ChangeDescriptor>();
                    for (int i = 0; i < conflicts.size(); ++i) {
                        String oldId = (String)conflicts.get(i);
                        String newId = wrapperId != null ? this.m_mapping.generateId(wrapperId + '_' + oldId, false, newIds) : this.m_mapping.generateId(oldId, false, newIds);
                        this.appendToConflictMsg(conflictMsg, oldId, newId, i, silently);
                        newIds.add(newId);
                        if (rootId != null && oldId.equals(rootId[0])) {
                            rootId[0] = newId;
                        }
                        SVGFileModel.resolveChanges(sb, rootElem, oldId, newId, changes);
                    }
                    Collections.sort(changes);
                    for (ChangeDescriptor change : changes) {
                        change.replace(sb);
                    }
                    docText = sb.substring(startOff, endOff + (sb.length() - length) + 1);
                    this.notifyAboutConflictIds(conflictMsg, silently);
                } else {
                    docText = doc.getText(startOff, endOff - startOff + 1);
                }
                if (!allowAnonymousRoot && SVGFileModel.getIdAttribute(firstChild) == null && SVGFileModel.getTagChildCount(children) == 1) {
                    String name = '<' + firstChild.getName() + ' ';
                    int p = docText.indexOf(name);
                    if (p != -1) {
                        String id = this.m_mapping.generateId("", false, newIds);
                        docText = docText.substring(0, p += name.length()) + SVGFileModel.injectId(new StringBuilder(), id).toString() + docText.substring(p);
                        if (rootId != null) {
                            rootId[0] = id;
                        }
                    } else {
                        SceneManager.log(Level.SEVERE, "Could not inject id into:\n" + docText);
                    }
                }
            }
            String string = docText;
            return string;
        }
        finally {
            docModel.readUnlock();
        }
    }

    private void appendToConflictMsg(StringBuilder msg, String oldId, String newId, int conflictIdx, boolean silently) {
        if (silently) {
            return;
        }
        if (conflictIdx < 10) {
            msg.append("\t'");
            msg.append(oldId).append("' -> '").append(newId);
            msg.append("'\n");
        } else if (conflictIdx == 10) {
            msg.append("\t...\n");
        }
    }

    private void notifyAboutConflictIds(StringBuilder conflictMsg, boolean silently) {
        if (silently) {
            return;
        }
        String msg = NbBundle.getMessage(ElementMapping.class, (String)"WARNING_IDConflicts", (Object)conflictMsg.toString());
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 2));
    }

    protected static String wrapText(String wrapperId, String textToWrap) {
        StringBuilder sb = new StringBuilder();
        sb.append("<g id=\"");
        sb.append(wrapperId);
        sb.append("\">\n");
        sb.append(textToWrap);
        sb.append("\n</g>");
        return sb.toString();
    }

    private static boolean isElementIdChar(char c, boolean isTrailing) {
        return (!isTrailing || c != '.') && PerseusController.isElementIdChar(c);
    }

    private static int indexOf(CharSequence chars, String str, int from, int to) {
        assert (to <= chars.length()) : "Index out of bounds: " + to + " > " + chars.length();
        int index = from;
        int strLen = str.length();
        if (strLen > 0) {
            block0: while (index < to) {
                int i = 0;
                while (chars.charAt(index++) == str.charAt(i++)) {
                    if (i == strLen) {
                        return index - i;
                    }
                    if (index <= to) continue;
                    break block0;
                }
            }
        }
        return -1;
    }

    public static void resolveChanges(CharSequence sb, DocumentElement elem, String oldId, String newId, List<ChangeDescriptor> changes) {
        AttributeSet attrs = elem.getAttributes();
        List children = elem.getChildren();
        Enumeration<?> attrNames = attrs.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            int q;
            int p;
            String name = (String)attrNames.nextElement();
            String value = (String)attrs.getAttribute(name);
            if (value == null || value.length() <= 0 || (p = value.indexOf(oldId)) == -1 || p != 0 && SVGFileModel.isElementIdChar(value.charAt(p - 1), false) || (q = p + oldId.length()) < value.length() && SVGFileModel.isElementIdChar(value.charAt(q), true)) continue;
            int startOff = elem.getStartOffset();
            int endOff = children.isEmpty() ? elem.getEndOffset() : ((DocumentElement)children.get(0)).getStartOffset();
            q = SVGFileModel.indexOf(sb, name, startOff, endOff);
            if (q != -1 && (q = SVGFileModel.indexOf(sb, oldId, q + name.length(), endOff)) != -1) {
                changes.add(new ChangeDescriptor(q, oldId.length(), newId, elem));
                continue;
            }
            SceneManager.log(Level.INFO, "Attribute value " + value + " not found at the DE " + elem);
        }
        for (DocumentElement de : children) {
            if (!SVGFileModel.isTagElement(de)) continue;
            SVGFileModel.resolveChanges(sb, de, oldId, newId, changes);
        }
    }

    private static List<String> collectIds(DocumentElement elem, List<String> ids) {
        String id = SVGFileModel.getIdAttribute(elem);
        if (id != null) {
            ids.add(id);
        }
        List children = elem.getChildren();
        for (DocumentElement de : children) {
            if (!SVGFileModel.isTagElement(de)) continue;
            SVGFileModel.collectIds(de, ids);
        }
        return ids;
    }

    public static DocumentModel loadDocumentModel(File file) throws FileNotFoundException, IOException, DocumentModelException {
        BufferedInputStream in = null;
        FileInputStream fin = new FileInputStream(file);
        in = new BufferedInputStream(fin);
        String fileName = file.getName();
        int p = fileName.indexOf(46);
        if (p != -1 && SVGDataObject.isSVGZ(fileName.substring(p + 1))) {
            in = new BufferedInputStream(new GZIPInputStream(in));
        }
        return SVGFileModel.loadDocumentModel(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DocumentModel loadDocumentModel(InputStream in) throws IOException, DocumentModelException {
        EditorKit kit = JEditorPane.createEditorKitForContentType("image/svg+xml");
        BaseDocument doc = (BaseDocument)kit.createDefaultDocument();
        try {
            kit.read(in, (Document)doc, 0);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        finally {
            in.close();
        }
        DocumentModel model = DocumentModel.getDocumentModel((Document)doc);
        return model;
    }

    private static DocumentElement getFirstTagChild(List<DocumentElement> children) {
        for (DocumentElement child : children) {
            if (!SVGFileModel.isTagElement(child)) continue;
            return child;
        }
        return null;
    }

    private static DocumentElement getLastTagChild(List<DocumentElement> children) {
        for (int i = children.size() - 1; i >= 0; --i) {
            DocumentElement child = children.get(i);
            if (!SVGFileModel.isTagElement(child)) continue;
            return child;
        }
        return null;
    }

    private static DocumentElement getLastVisibleTagChild(List<DocumentElement> children) {
        for (int i = children.size() - 1; i >= 0; --i) {
            DocumentElement child = children.get(i);
            if (!SVGFileModel.isTagElement(child) || SVGFileModel.isHiddenElement(child)) continue;
            return child;
        }
        return null;
    }

    private static int getTagChildCount(List<DocumentElement> children) {
        int count = 0;
        for (DocumentElement child : children) {
            if (!SVGFileModel.isTagElement(child)) continue;
            ++count;
        }
        return count;
    }

    private static DocumentElement getPreviousTagSibling(DocumentElement elem) {
        DocumentElement parent = elem.getParentElement();
        DocumentElement previous = null;
        assert (parent != null);
        for (DocumentElement child : parent.getChildren()) {
            if (child == elem) {
                return previous;
            }
            if (!SVGFileModel.isTagElement(child)) continue;
            previous = child;
        }
        assert (false) : "The document element " + elem + " is no longer part of the document";
        return null;
    }

    private static DocumentElement getNextTagSibling(DocumentElement elem) {
        DocumentElement parent = elem.getParentElement();
        DocumentElement next = null;
        assert (parent != null);
        List children = parent.getChildren();
        for (int i = children.size() - 1; i >= 0; --i) {
            DocumentElement child = (DocumentElement)children.get(i);
            if (child == elem) {
                return next;
            }
            if (!SVGFileModel.isTagElement(child)) continue;
            next = child;
        }
        assert (false) : "The document element " + elem + " is no longer part of the document";
        return null;
    }

    private void checkIntegrity(DocumentElement de) {
        this.checkModel();
        assert (de != null);
        assert (de.getDocument() == this.getDoc()) : "Element is not part of the current document";
        assert (de.getDocumentModel() == this.m_model) : "Element is not part of the current document model";
        if (SVGFileModel.isTagElement(de) && de.getEndOffset() <= de.getStartOffset()) {
            System.out.println("ERROR: Empy tag element: " + de);
        }
    }

    private DocumentElement checkIntegrity(String id) {
        DocumentElement de = this.getElementById(id);
        assert (de != null) : "No element with id: " + id;
        this.checkIntegrity(de);
        return de;
    }

    public static final class ChangeDescriptor
    implements Comparable {
        private final int m_startOffset;
        private final int m_length;
        private final String m_newValue;
        private final DocumentElement m_elem;

        public ChangeDescriptor(int startOffset, int length, String newValue, DocumentElement elem) {
            this.m_startOffset = startOffset;
            this.m_length = length;
            this.m_newValue = newValue;
            this.m_elem = elem;
        }

        public ChangeDescriptor(int startOffset, int length, String newValue) {
            this(startOffset, length, newValue, null);
        }

        public void replace(StringBuilder sb) {
            sb.replace(this.m_startOffset, this.m_startOffset + this.m_length, this.m_newValue);
        }

        public int compareTo(Object o) {
            return ((ChangeDescriptor)o).m_startOffset - this.m_startOffset;
        }

        public boolean equals(Object o) {
            return ((ChangeDescriptor)o).m_startOffset == this.m_startOffset;
        }
    }

    private static class FileModelTransactionException
    extends RuntimeException {
        public FileModelTransactionException(Throwable cause) {
            super(cause);
        }
    }

    public abstract class FileModelTransaction
    implements Runnable {
        private final boolean m_fireUpdate;

        public FileModelTransaction(boolean fireUpdate) {
            this.m_fireUpdate = fireUpdate;
        }

        public FileModelTransaction() {
            this(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SceneManager.log(Level.FINE, "Starting transaction...");
            if (SVGFileModel.this.incrementTransactionCounter() == 1) {
                SVGFileModel.this.getSceneManager().setBusyState(SVGFileModel.TRANSACTION_TOKEN, true);
            }
            Object object = SVGFileModel.this.getTransactionMonitor();
            synchronized (object) {
                SceneManager.log(Level.FINE, "Transaction started.");
                Reformat formatting = Reformat.get((Document)SVGFileModel.this.getDoc());
                try {
                    SVGFileModel.this.updateModel();
                    formatting.lock();
                    SVGFileModel.this.m_model.readLock();
                    this.runTransaction();
                }
                finally {
                    SVGFileModel.this.m_model.readUnlock();
                    formatting.unlock();
                    SceneManager.log(Level.FINE, "Transaction completed.");
                    if (SVGFileModel.this.decrementTransactionCounter() == 0) {
                        SVGFileModel.this.getSceneManager().setBusyState(SVGFileModel.TRANSACTION_TOKEN, false);
                    }
                }
            }
            if (this.m_fireUpdate) {
                SVGFileModel.this.getDataObject().fireContentChanged();
            } else {
                SVGFileModel.this.m_model.forceUpdate();
            }
        }

        private void runTransaction() {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        FileModelTransaction.this.transaction();
                    }
                    catch (Exception ex) {
                        throw new FileModelTransactionException(ex);
                    }
                }
            };
            try {
                SVGFileModel.this.getDoc().runAtomic(run);
            }
            catch (FileModelTransactionException ex) {
                SceneManager.error("Transaction failed.", ex.getCause());
            }
        }

        protected abstract void transaction() throws Exception;
    }

    public static interface TransactionCommand {
        public Object execute(Object var1);
    }

    public static interface ModelListener {
        public void modelChanged();
    }
}

