/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer;

import com.sun.perseus.awt.SVGAnimatorImpl;
import com.sun.perseus.builder.ModelBuilder;
import com.sun.perseus.j2d.Point;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.AbstractAnimate;
import com.sun.perseus.model.CompositeGraphicsNode;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.SVG;
import com.sun.perseus.model.SVGImageImpl;
import com.sun.perseus.model.Time;
import com.sun.perseus.model.UpdateAdapter;
import com.sun.perseus.model.UpdateListener;
import java.awt.AWTEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import javax.microedition.m2g.ExternalResourceHandler;
import javax.microedition.m2g.SVGAnimator;
import javax.microedition.m2g.SVGImage;
import javax.swing.JComponent;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.composer.prototypes.PatchedAnimationElement;
import org.netbeans.modules.mobility.svgcore.composer.prototypes.PatchedElement;
import org.netbeans.modules.mobility.svgcore.composer.prototypes.PatchedGroup;
import org.netbeans.modules.mobility.svgcore.composer.prototypes.PatchedTransformableElement;
import org.netbeans.modules.mobility.svgcore.composer.prototypes.SVGComposerPrototypeFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGAnimationElement;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;

public final class PerseusController {
    public static final int ANIMATION_NOT_AVAILABLE = 0;
    public static final int ANIMATION_NOT_RUNNING = 1;
    public static final int ANIMATION_RUNNING = 2;
    public static final int ANIMATION_PAUSED = 3;
    public static final float ANIMATION_DEFAULT_DURATION = 30.0f;
    public static final float ANIMATION_DEFAULT_STEP = 0.1f;
    public static final String ID_VIEWBOX_MARKER = "$VIEWBOX$";
    public static final String ID_BBOX_MARKER = "$BBOX$";
    private static final String[] ANIM_PATTERNS = new String[]{".DOMFocusIn", ".DOMFocusOut.DOMActivate"};
    private static final SVGMatrix IDENTITY_TRANSFORM = new Transform(null);
    private static int s_instanceCounter = 0;
    protected final SceneManager m_sceneMgr;
    protected final String m_id;
    protected SVGAnimatorImpl m_animator;
    protected SVGImage m_svgImage;
    protected DocumentNode m_svgDoc;
    protected SVGLocatableElement m_viewBoxMarker;
    protected int m_animationState = 0;
    protected float m_currentTime = 0.0f;

    PerseusController(SceneManager sceneMgr) {
        this.m_sceneMgr = sceneMgr;
        this.m_id = "PC-" + s_instanceCounter++ + "-" + sceneMgr;
    }

    void initialize() {
        this.m_svgImage = this.m_sceneMgr.getSVGImage();
        this.m_svgDoc = (DocumentNode)this.m_svgImage.getDocument();
        this.m_animator = (SVGAnimatorImpl)SVGAnimator.createAnimator((SVGImage)this.m_svgImage, (String)"javax.swing.JComponent");
        this.m_animationState = this.containsAnimation((ModelNode)this.m_svgDoc) ? 1 : 0;
        SVGSVGElement svg = this.getSVGRootElement();
        SVGRect rect = svg.getRectTrait("viewBox");
        if (rect != null) {
            this.m_viewBoxMarker = (SVGLocatableElement)this.m_svgDoc.createElementNS("http://www.w3.org/2000/svg", "rect");
            this.m_viewBoxMarker.setId(ID_VIEWBOX_MARKER);
            this.m_viewBoxMarker.setTrait("fill", "none");
            this.m_viewBoxMarker.setTrait("stroke", "none");
            this.m_viewBoxMarker.setFloatTrait("x", rect.getX());
            this.m_viewBoxMarker.setFloatTrait("y", rect.getY());
            this.m_viewBoxMarker.setFloatTrait("width", rect.getWidth());
            this.m_viewBoxMarker.setFloatTrait("height", rect.getHeight());
            svg.appendChild((Node)this.m_viewBoxMarker);
        } else {
            this.m_viewBoxMarker = null;
        }
        this.m_animator.play();
        this.m_animator.pause();
        SceneManager.log(Level.INFO, this.toString() + " initialized.");
    }

    public SVGPoint convertCoords(float x, float y) {
        SVGMatrix m = this.getSVGRootElement().getScreenCTM().inverse();
        return new Point(m.getComponent(0) * x + m.getComponent(2) * y + m.getComponent(4), m.getComponent(1) * x + m.getComponent(3) * y + m.getComponent(5));
    }

    public SVGLocatableElement getViewBoxMarker() {
        return this.m_viewBoxMarker;
    }

    public boolean isImgHorizontallyOriented() {
        SVGSVGElement svg = this.getSVGRootElement();
        SVGRect rect = svg.getRectTrait("viewBox");
        if (rect != null) {
            return rect.getWidth() > rect.getHeight();
        }
        return false;
    }

    public JComponent getAnimatorGUI() {
        return (JComponent)this.m_animator.getTargetComponent();
    }

    public void execute(Runnable command) {
        try {
            this.m_animator.invokeAndWait(command);
        }
        catch (Exception ex) {
            SceneManager.error("Command execution failed.", ex);
        }
    }

    public DocumentNode getSVGDocument() {
        return this.m_svgDoc;
    }

    public SVGSVGElement getSVGRootElement() {
        return (SVGSVGElement)this.m_svgDoc.getDocumentElement();
    }

    public SVGObject getObjectById(String id) {
        SVGElement elem = this.getElementById(id);
        SVGObject res = this.getObjectForSVGElement(elem);
        if (res != null) {
            return res;
        }
        SceneManager.log(Level.INFO, "No object found for id " + id + "(" + this.toString() + ")");
        return null;
    }

    public SVGObject getObjectForSVGElement(SVGElement elem) {
        SVGLocatableElement locElem;
        if (elem != null && elem instanceof SVGLocatableElement && PerseusController.getSafeScreenBBox(locElem = (SVGLocatableElement)elem) != null) {
            return this.getSVGObject(locElem);
        }
        return null;
    }

    public SVGElement getElementById(String id) {
        SVGElement elem = PerseusController.getElementById((ModelNode)this.getSVGRootElement(), id);
        return elem;
    }

    public SVGObject[] getObjectsAt(int x, int y) {
        SVGLocatableElement elem = this.findElementAt(x, y);
        if (elem != null) {
            SVGObject obj;
            for (Object node = elem; node != null; node = node.getParentNode()) {
                if (!PatchedGroup.isWrapper((Node)node)) continue;
                elem = node;
                break;
            }
            if ((obj = this.getSVGObject(elem)) != null) {
                return new SVGObject[]{obj};
            }
        }
        return null;
    }

    public void delete(final SVGElement elem) {
        this.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Node parent = elem.getParentNode();
                PerseusController.setNullIds(elem, true);
                try {
                    parent.removeChild((Node)elem);
                }
                finally {
                    PerseusController.setNullIds(elem, false);
                }
            }
        });
    }

    public void moveToBottom(final SVGLocatableElement elem) {
        final Node parent = elem.getParentNode();
        final ModelNode firstChild = ((ModelNode)parent).getFirstChildNode();
        if (firstChild != elem) {
            this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    PerseusController.setNullIds((SVGElement)elem, true);
                    try {
                        parent.removeChild((Node)elem);
                        parent.insertBefore((Node)elem, (Node)firstChild);
                    }
                    finally {
                        PerseusController.setNullIds((SVGElement)elem, false);
                    }
                }
            });
        }
    }

    public void moveToTop(final SVGLocatableElement elem) {
        final Node parent = elem.getParentNode();
        ModelNode lastChild = ((ModelNode)parent).getLastChildNode();
        if (lastChild != elem) {
            this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    PerseusController.setNullIds((SVGElement)elem, true);
                    try {
                        parent.removeChild((Node)elem);
                        parent.appendChild((Node)elem);
                    }
                    finally {
                        PerseusController.setNullIds((SVGElement)elem, false);
                    }
                }
            });
        }
    }

    public void moveBackward(final SVGLocatableElement elem) {
        final Node parent = elem.getParentNode();
        ModelNode firstChild = ((ModelNode)parent).getFirstChildNode();
        if (firstChild != elem) {
            this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    PerseusController.setNullIds((SVGElement)elem, true);
                    try {
                        ModelNode previousChild = ((ModelNode)elem).getPreviousSiblingNode();
                        assert (previousChild != null);
                        parent.removeChild((Node)elem);
                        parent.insertBefore((Node)elem, (Node)previousChild);
                    }
                    finally {
                        PerseusController.setNullIds((SVGElement)elem, false);
                    }
                }
            });
        }
    }

    public void moveForward(final SVGLocatableElement elem) {
        final Node parent = elem.getParentNode();
        final ModelNode lastChild = ((ModelNode)parent).getLastChildNode();
        if (lastChild != elem) {
            this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    PerseusController.setNullIds((SVGElement)elem, true);
                    try {
                        ModelNode nextChild = ((ModelNode)elem).getNextSiblingNode();
                        assert (nextChild != null);
                        parent.removeChild((Node)elem);
                        if (nextChild == lastChild) {
                            parent.appendChild((Node)elem);
                        } else {
                            parent.insertBefore((Node)elem, (Node)nextChild.getNextSiblingNode());
                        }
                    }
                    finally {
                        PerseusController.setNullIds((SVGElement)elem, false);
                    }
                }
            });
        }
    }

    public SVGLocatableElement findElementAt(int x, int y) {
        float[] pt = new float[]{x, y};
        ModelNode target = this.m_svgDoc.nodeHitAt(pt);
        SVGLocatableElement elt = null;
        if (target != null) {
            while (elt == null && target != null) {
                if (target instanceof SVGLocatableElement) {
                    elt = (SVGLocatableElement)target;
                    continue;
                }
                target = target.getParent();
            }
        }
        return elt;
    }

    public static SVGElement hideAllButSubtree(ModelNode node, String id) {
        SVGElement elem;
        if (node instanceof SVGElement && id.equals((elem = (SVGElement)node).getId())) {
            return elem;
        }
        SVGElement visibleChild = null;
        for (ModelNode child = node.getFirstChildNode(); child != null; child = child.getNextSiblingNode()) {
            SVGElement e = PerseusController.hideAllButSubtree(child, id);
            if (e == null) continue;
            visibleChild = e;
        }
        if (node instanceof CompositeGraphicsNode) {
            CompositeGraphicsNode elem2 = (CompositeGraphicsNode)node;
            if (visibleChild == null) {
                elem2.setVisibility(false);
                elem2.setTrait("visibility", "hidden");
            }
        }
        return visibleChild;
    }

    public static SVGElement findElementById(SVGSVGElement root, String id) {
        SVGElement elem = PerseusController.getElementById((ModelNode)root, id);
        return elem;
    }

    protected static SVGElement getElementById(ModelNode node, String id) {
        SVGElement svgElem;
        if (node instanceof SVGElement && id.equals((svgElem = (SVGElement)node).getId())) {
            return svgElem;
        }
        for (ModelNode child = node.getFirstChildNode(); child != null; child = child.getNextSiblingNode()) {
            SVGElement res = PerseusController.getElementById(child, id);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public int getAnimatorState() {
        return this.m_animationState;
    }

    public boolean isAnimatorStarted() {
        return this.m_animationState == 2 || this.m_animationState == 3;
    }

    public void startAnimator() {
        if (this.m_animationState == 1 || this.m_animationState == 3) {
            if (this.m_animator.getState() != 2) {
                this.m_animator.play();
                this.m_sceneMgr.processEvent(new AWTEvent(this, 2533){});
            }
            this.m_animationState = 2;
            this.m_sceneMgr.getScreenManager().repaint();
        }
    }

    public void getFocusableTargets(List<String> focusableTargets) {
        SVGSVGElement root = this.getSVGRootElement();
        HashSet<String> ids = new HashSet<String>();
        this.collectFocusableElements((SVGElement)root, ids);
        this.orderFocusableElements((SVGElement)root, ids, focusableTargets);
        focusableTargets.add(0, null);
    }

    public void pauseAnimator() {
        if (this.m_animationState == 2) {
            if (this.m_animator.getState() == 2) {
                this.m_animator.pause();
            }
            this.m_animationState = 3;
        }
    }

    public void stopAnimator() {
        if (this.m_animationState == 2 || this.m_animationState == 3) {
            this.m_animator.stop();
            this.m_animator.play();
            this.m_animator.pause();
            this.setAnimatorTime(0.0f);
            this.m_animationState = 1;
            this.m_sceneMgr.processEvent(new AWTEvent(this, 2534){});
            this.m_sceneMgr.getScreenManager().repaint();
        }
    }

    public float getAnimatorTime() {
        try {
            if (this.m_animator.getState() != 1) {
                this.m_animator.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        PerseusController.this.m_currentTime = PerseusController.this.getSVGRootElement().getCurrentTime();
                        PerseusController.this.m_sceneMgr.updateAnimationDuration(PerseusController.this.m_currentTime);
                    }
                });
            } else {
                this.m_currentTime = 0.0f;
            }
        }
        catch (InterruptedException ex) {
            SceneManager.error(this.toString() + " - Wait interrupted.", ex);
        }
        return this.m_currentTime;
    }

    public void setAnimatorTime(float time) {
        if (this.m_animator != null) {
            this.m_currentTime = time;
            this.m_sceneMgr.updateAnimationDuration(this.m_currentTime);
            if (this.m_animator.getState() != 1) {
                this.m_animator.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PerseusController.this.getSVGRootElement().setCurrentTime(PerseusController.this.m_currentTime);
                    }
                });
            } else {
                SceneManager.log(Level.SEVERE, this.toString() + " - Animator is stopped.");
            }
        }
    }

    public void startAnimation(String id) {
        SVGElement elem = this.getElementById(id);
        if (elem != null && elem instanceof SVGAnimationElement) {
            ((SVGAnimationElement)elem).beginElementAt(0.0f);
        } else {
            SceneManager.log(Level.SEVERE, this.toString() + " - Animation element not found: " + id);
        }
    }

    public void stopAnimation(String id) {
        SVGElement elem = this.getElementById(id);
        if (elem != null && elem instanceof SVGAnimationElement) {
            ((SVGAnimationElement)elem).endElementAt(0.0f);
        } else {
            SceneManager.log(Level.SEVERE, this.toString() + " - Animation element not found: " + id);
        }
    }

    public String toString() {
        return this.m_id;
    }

    private synchronized SVGObject getSVGObject(SVGLocatableElement elem) {
        assert (elem != null) : "Element must not be null";
        if (elem instanceof PatchedElement) {
            PatchedElement pelem = (PatchedElement)elem;
            SVGObject obj = pelem.getSVGObject();
            if (obj == null) {
                obj = new SVGObject(this.m_sceneMgr, elem);
                pelem.attachSVGObject(obj);
            }
            return obj;
        }
        SceneManager.log(Level.SEVERE, this.toString() + " - PatchedElement must be used instead of " + elem.getClass().getName());
        return null;
    }

    public static ModelNode getRootElement(ModelNode node) {
        ModelNode parent;
        while ((parent = node.getParent()) != null) {
            node = parent;
        }
        return node;
    }

    public static SVGImage createImage(InputStream stream) throws IOException, InterruptedException {
        if (stream == null) {
            throw new NullPointerException();
        }
        SVGImage img = PerseusController.loadDocument(stream, null);
        DocumentNode docNode = (DocumentNode)img.getDocument();
        Element root = docNode.getDocumentElement();
        if (!(root instanceof SVG)) {
            SceneManager.log(Level.SEVERE, "Missing SVG root element");
            throw new IOException("Missing SVG root element");
        }
        SVG svg = (SVG)root;
        int width = (int)svg.getWidth();
        int height = (int)svg.getHeight();
        docNode.setSize(width, height);
        return img;
    }

    protected static SVGImage loadDocument(InputStream is, ExternalResourceHandler handler) throws IOException, InterruptedException {
        DocumentNode documentNode = new DocumentNode();
        UpdateAdapter updateAdapter = new UpdateAdapter();
        documentNode.setUpdateListener((UpdateListener)updateAdapter);
        ModelBuilder.loadDocument((InputStream)is, (DocumentNode)documentNode, (Vector)SVGComposerPrototypeFactory.getPrototypes(documentNode));
        if (updateAdapter.hasLoadingFailed()) {
            if (updateAdapter.getLoadingFailedException() != null) {
                String message = updateAdapter.getLoadingFailedException().getMessage();
                if (message != null && message.startsWith("Load Interrupted : ")) {
                    throw new InterruptedException(message);
                }
                throw new IOException(message);
            }
            throw new IOException("Loading of SVG document failed.");
        }
        SVGImageImpl img = new SVGImageImpl(documentNode, null);
        documentNode.initializeTimingEngine();
        documentNode.sample(new Time(0L));
        return img;
    }

    protected static int getChildrenCount(ModelNode node) {
        int count = 0;
        for (ModelNode child = node.getFirstChildNode(); child != null; child = child.getNextSiblingNode()) {
            ++count;
        }
        return count;
    }

    protected static void transferChildren(SVGElement target, SVGElement source) {
        ModelNode child = ((ModelNode)source).getFirstChildNode();
        while (child != null) {
            if (child instanceof PatchedElement) {
                PatchedElement pe = (PatchedElement)child;
                child = child.getNextSiblingNode();
                PerseusController.setNullIds((SVGElement)pe, true);
                source.removeChild((Node)((Object)pe));
                target.appendChild((Node)((Object)pe));
                PerseusController.setNullIds((SVGElement)pe, false);
                continue;
            }
            SceneManager.log(Level.SEVERE, "PatchedElement must be used instead of " + child.getClass().getName());
        }
    }

    public static void printTree(ModelNode node, int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("    ");
        }
        System.out.println(node.getClass());
        for (ModelNode child = node.getFirstChildNode(); child != null; child = child.getNextSiblingNode()) {
            PerseusController.printTree(child, level + 1);
        }
    }

    private void collectFocusableElements(SVGElement elem, Set<String> elemIds) {
        if (elem instanceof PatchedAnimationElement) {
            String beginTrait = elem.getTrait("begin");
            for (String pattern : ANIM_PATTERNS) {
                int p = 0;
                while ((p = beginTrait.indexOf(pattern, p)) != -1) {
                    int i;
                    for (i = p - 1; i >= 0 && PerseusController.isElementIdChar(beginTrait.charAt(i)); --i) {
                    }
                    String id = beginTrait.substring(i + 1, p);
                    if (this.getElementById(id) != null) {
                        elemIds.add(id);
                    }
                    p += pattern.length();
                }
            }
        }
        for (SVGElement child = (SVGElement)elem.getFirstElementChild(); child != null; child = (SVGElement)child.getNextElementSibling()) {
            this.collectFocusableElements(child, elemIds);
        }
    }

    private boolean orderFocusableElements(SVGElement elem, Set<String> ids, List<String> orderedIds) {
        String id = elem.getId();
        if (id != null && ids.remove(id)) {
            orderedIds.add(id);
            if (ids.isEmpty()) {
                return true;
            }
        }
        for (SVGElement child = (SVGElement)elem.getFirstElementChild(); child != null; child = (SVGElement)child.getNextElementSibling()) {
            if (!this.orderFocusableElements(child, ids, orderedIds)) continue;
            return true;
        }
        return false;
    }

    private boolean containsAnimation(ModelNode node) {
        if (node instanceof AbstractAnimate) {
            return true;
        }
        for (ModelNode child = node.getFirstChildNode(); child != null; child = child.getNextSiblingNode()) {
            if (!this.containsAnimation(child)) continue;
            return true;
        }
        return false;
    }

    public static boolean isElementIdChar(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '.' || c == '_' || c == '-' || c == ':';
    }

    public static void setNullIds(SVGElement elem, boolean isNull) {
        if (elem instanceof PatchedElement) {
            ((PatchedElement)elem).setNullId(isNull);
        } else if (elem.getId() != null) {
            SceneManager.log(Level.SEVERE, "PatchedElement must be used instead of " + elem.getClass().getName());
        }
        for (SVGElement child = (SVGElement)elem.getFirstElementChild(); child != null; child = (SVGElement)child.getNextElementSibling()) {
            PerseusController.setNullIds(child, isNull);
        }
    }

    public static boolean isViewBoxMarker(ModelNode node) {
        return node instanceof SVGElement && ID_VIEWBOX_MARKER.equals(((SVGElement)node).getId());
    }

    public static SVGRect getSafeScreenBBox(SVGLocatableElement elem) {
        SVGRect bBox = elem.getScreenBBox();
        if (bBox == null) {
            SceneManager.log(Level.SEVERE, "Null screen BBox for element:" + elem);
            ModelNode child = ((ModelNode)elem).getFirstChildNode();
            if (child != null && child instanceof SVGLocatableElement) {
                bBox = ((SVGLocatableElement)child).getScreenBBox();
            }
        }
        return bBox;
    }

    public static SVGRect getSafeBBox(SVGLocatableElement elem) {
        SVGRect bBox = elem.getBBox();
        if (bBox == null) {
            SceneManager.log(Level.SEVERE, "Null BBox for element:" + elem);
            ModelNode child = ((ModelNode)elem).getFirstChildNode();
            while (child != null && bBox == null) {
                if (!(child instanceof SVGLocatableElement)) continue;
                bBox = PerseusController.calculateMaxBBox(bBox, PerseusController.getSafeBBox((SVGLocatableElement)child));
                child = child.getNextSiblingNode();
            }
        }
        return bBox;
    }

    public static SVGRect getFullBBox(SVGLocatableElement elem) {
        SVGRect bBox = elem.getBBox();
        if (bBox == null) {
            SceneManager.log(Level.SEVERE, "Null BBox for element:" + elem);
            ModelNode child = ((ModelNode)elem).getFirstChildNode();
            while (child != null) {
                if (!(child instanceof SVGLocatableElement)) continue;
                bBox = PerseusController.calculateMaxBBox(bBox, PerseusController.getFullBBox((SVGLocatableElement)child));
                child = child.getNextSiblingNode();
            }
        }
        return bBox;
    }

    private static SVGRect calculateMaxBBox(SVGRect bBox, SVGRect tmpBBox) {
        if (bBox == null) {
            bBox = tmpBBox;
        } else if (tmpBBox != null) {
            float x1 = Math.min(bBox.getX(), tmpBBox.getX());
            float y1 = Math.min(bBox.getY(), tmpBBox.getY());
            float x2 = Math.max(bBox.getWidth() + bBox.getX(), tmpBBox.getWidth() + tmpBBox.getX());
            float y2 = Math.max(bBox.getHeight() + bBox.getY(), tmpBBox.getHeight() + tmpBBox.getY());
            bBox.setX(x1);
            bBox.setY(y1);
            bBox.setWidth(x2 - x1);
            bBox.setHeight(y2 - y1);
        }
        return bBox;
    }

    protected static Document getOwnerDocument(Node elem) {
        Node parent;
        while ((parent = elem.getParentNode()) != null) {
            elem = parent;
        }
        return (Document)elem;
    }

    public static SVGMatrix getParentTransformation(Node node) {
        ArrayList<Transform> transforms = null;
        while (node != null) {
            Transform temp;
            if (node instanceof PatchedTransformableElement && (temp = ((PatchedTransformableElement)((Object)node)).getTransform()) != null) {
                if (transforms == null) {
                    transforms = new ArrayList<Transform>();
                }
                transforms.add(new Transform((SVGMatrix)temp));
            }
            node = node.getParentNode();
        }
        SVGMatrix total = null;
        if (transforms != null) {
            total = (SVGMatrix)transforms.get(0);
            for (int i = 1; i < transforms.size(); ++i) {
                total = total.mMultiply((SVGMatrix)transforms.get(i));
            }
        }
        return total;
    }

    public static final boolean isIdentityTransform(SVGMatrix matrix, boolean ignoreTranslate) {
        int length = ignoreTranslate ? 4 : 6;
        for (int i = 0; i < length; ++i) {
            if (!((double)Math.abs(IDENTITY_TRANSFORM.getComponent(i) - matrix.getComponent(i)) > 0.001)) continue;
            return false;
        }
        return true;
    }
}

