/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.archive.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.archive.project.ArchiveProject;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class ArchiveProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation {
    private ArchiveProject project;
    private static final String TMPPROJ_LIT = "tmpproj";
    private static final String SUBARCHIVES_LIT = "subarchives";

    public ArchiveProjectOperations(ArchiveProject archiveProject) {
        this.project = archiveProject;
    }

    private static void addFile(FileObject fileObject, String string, List<FileObject> list) {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 != null) {
            list.add(fileObject2);
        }
    }

    public List<FileObject> getMetadataFiles() {
        FileObject fileObject = this.project.getProjectDirectory();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        ArchiveProjectOperations.addFile(fileObject, "nbproject", arrayList);
        ArchiveProjectOperations.addFile(fileObject, "build.xml", arrayList);
        ArchiveProjectOperations.addFile(fileObject, "dist", arrayList);
        return arrayList;
    }

    public List<FileObject> getDataFiles() {
        FileObject fileObject = this.project.getProjectDirectory();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        ArchiveProjectOperations.addFile(fileObject, TMPPROJ_LIT, arrayList);
        ArchiveProjectOperations.addFile(fileObject, SUBARCHIVES_LIT, arrayList);
        ArchiveProjectOperations.addFile(fileObject, "setup", arrayList);
        return arrayList;
    }

    public void notifyDeleting() throws IOException {
    }

    public void notifyDeleted() throws IOException {
        if (this.project.getProjectDirectory().getFileObject(TMPPROJ_LIT) == null) {
            this.project.getProjectDirectory().delete();
        }
        this.project.getAntProjectHelper().notifyDeleted();
    }

    public void notifyCopying() {
    }

    public void notifyCopied(final Project project, File file, final String string) {
        if (project == null) {
            return;
        }
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                try {
                    ArchiveProjectOperations.this.copyFilesToNewLocation(string, project);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().log(1, "" + iOException);
                }
            }
        });
    }

    private void copyFilesToNewLocation(String string, Project project) throws IOException {
        this.project.setName(string);
        AntProjectHelper antProjectHelper = this.project.getAntProjectHelper();
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        if (!project.getProjectDirectory().equals(this.project.getProjectDirectory())) {
            ArchiveProjectOperations.doCopy(project.getProjectDirectory().getFileObject(TMPPROJ_LIT), this.project.getProjectDirectory());
            FileObject fileObject = project.getProjectDirectory().getFileObject(SUBARCHIVES_LIT);
            if (null != fileObject) {
                FileObject fileObject2 = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)SUBARCHIVES_LIT);
                Enumeration enumeration = fileObject.getFolders(false);
                while (enumeration.hasMoreElements()) {
                    FileObject fileObject3 = (FileObject)enumeration.nextElement();
                    ArchiveProjectOperations.doCopy(fileObject3, fileObject2);
                }
            }
        }
    }

    public void notifyMoving() throws IOException {
    }

    public void notifyMoved(final Project project, File file, final String string) {
        if (project == null) {
            this.project.getAntProjectHelper().notifyDeleted();
            return;
        }
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                block11: {
                    try {
                        ArchiveProjectOperations.this.copyFilesToNewLocation(string, project);
                        FileObject fileObject = project.getProjectDirectory().getFileObject(ArchiveProjectOperations.SUBARCHIVES_LIT);
                        if (project.getProjectDirectory().equals(ArchiveProjectOperations.this.project.getProjectDirectory())) break block11;
                        try {
                            if (null != fileObject) {
                                fileObject.delete();
                            }
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        }
                        FileObject fileObject2 = project.getProjectDirectory().getFileObject(ArchiveProjectOperations.TMPPROJ_LIT);
                        if (null != fileObject2) {
                            try {
                                fileObject2.delete();
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                            }
                        }
                        if (null != (fileObject2 = project.getProjectDirectory())) {
                            try {
                                fileObject2.delete();
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                }
            }
        });
    }

    private static void doCopy(FileObject fileObject, FileObject fileObject2) throws IOException {
        if (null != fileObject) {
            if (fileObject.isFolder()) {
                FileObject fileObject3 = FileUtil.createFolder((FileObject)fileObject2, (String)fileObject.getNameExt());
                FileObject[] fileObjectArray = fileObject.getChildren();
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    ArchiveProjectOperations.doCopy(fileObjectArray[i], fileObject3);
                }
            } else {
                assert (fileObject.isData());
                FileObject fileObject4 = fileObject2.getFileObject(fileObject.getName(), fileObject.getExt());
                if (null == fileObject4) {
                    FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject2, (String)fileObject.getName(), (String)fileObject.getExt());
                }
            }
        }
    }
}

