/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.jdbc.mysql;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.netbeans.modules.db.metadata.model.api.Nullable;
import org.netbeans.modules.db.metadata.model.api.Parameter;
import org.netbeans.modules.db.metadata.model.api.SQLType;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCParameter;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCProcedure;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCSchema;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCUtils;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCValue;

public class MySQLProcedure
extends JDBCProcedure {
    public MySQLProcedure(JDBCSchema jdbcSchema, String name) {
        super(jdbcSchema, name);
    }

    @Override
    protected JDBCParameter createJDBCParameter(int position, ResultSet rs) throws SQLException {
        Parameter.Direction direction = JDBCUtils.getDirection(rs.getShort("COLUMN_TYPE"));
        return new JDBCParameter(this, MySQLProcedure.createValue(rs), direction, position);
    }

    @Override
    protected JDBCValue createJDBCValue(ResultSet rs) throws SQLException {
        return MySQLProcedure.createValue(rs);
    }

    @Override
    public String toString() {
        return "MySQLProcedure[name=" + this.getName() + "]";
    }

    private static JDBCValue createValue(ResultSet rs) throws SQLException {
        String name = rs.getString("COLUMN_NAME");
        int length = 0;
        int precision = 0;
        SQLType type = JDBCUtils.getSQLType(rs.getInt("DATA_TYPE"));
        if (JDBCUtils.isNumericType(type)) {
            precision = rs.getInt("PRECISION");
        } else {
            length = rs.getInt("PRECISION");
        }
        short scale = rs.getShort("SCALE");
        short radix = rs.getShort("RADIX");
        Nullable nullable = JDBCUtils.getProcedureNullable(rs.getShort("NULLABLE"));
        return new JDBCValue(name, type, length, precision, radix, scale, nullable);
    }
}

