/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.lang.reflect.Method;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.server.ProfilerRuntime;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Timers;

public class ProfilerRuntimeCPU
extends ProfilerRuntime {
    private static final boolean DEBUG = false;
    private static int nProfiledThreadsLimit;
    protected static int nProfiledThreadsAllowed;
    protected static boolean enableFirstTimeMethodInvoke;
    protected static volatile boolean recursiveInstrumentationDisabled;
    protected static boolean absoluteTimerOn;
    protected static boolean threadCPUTimerOn;
    protected static boolean[] instrMethodInvoked;
    private static boolean javaLangReflectMethodInvokeInterceptEnabled;
    private static Method getRequestedSessionIdMethod;
    private static Method getMethodMethod;
    private static Method getServletPathMethod;

    public static long getAbsTimeStampInCollectedFormat() {
        return Timers.getCurrentTimeInCounts() & 0xFFFFFFFFFFFFFFL;
    }

    public static void setInstrMethodsInvoked(boolean[] methodInvoked) {
        instrMethodInvoked = methodInvoked;
    }

    public static void setJavaLangReflectMethodInvokeInterceptEnabled(boolean v) {
        javaLangReflectMethodInvokeInterceptEnabled = v;
    }

    public static void setNProfiledThreadsLimit(int num) {
        nProfiledThreadsLimit = nProfiledThreadsAllowed = num;
    }

    public static void setTimerTypes(boolean absolute, boolean threadCPU) {
        if (threadCPU != threadCPUTimerOn && Platform.isSolaris()) {
            Timers.enableMicrostateAccounting((boolean)threadCPU);
        }
        absoluteTimerOn = absolute;
        threadCPUTimerOn = threadCPU;
    }

    public static void enableFirstTimeMethodInvoke(boolean enabled) {
        enableFirstTimeMethodInvoke = enabled;
    }

    public static void createThreadInfoForCurrentThread() {
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        ti.initialize();
        ti.useEventBuffer();
        ti.inCallGraph = false;
    }

    public static void handleJavaLangReflectMethodInvoke(Method method) {
        if (!javaLangReflectMethodInvokeInterceptEnabled) {
            return;
        }
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (!ti.isInitialized() || !ti.inCallGraph) {
            return;
        }
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        externalActionsHandler.handleReflectiveInvoke(method);
        --ti.inProfilingRuntimeMethod;
    }

    public static void handleServletDoMethod(Object request) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (!ti.isInitialized()) {
            System.out.println("No thread for servlet request");
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ProfilerRuntimeCPU.servletDoMethodHook(ti, request);
        --ti.inProfilingRuntimeMethod;
    }

    public static void resetProfilerCollectors() {
        nProfiledThreadsAllowed = nProfiledThreadsLimit;
    }

    public static void resumeCurrentThreadTimer() {
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (!ti.isInitialized() || !ti.inCallGraph) {
            return;
        }
        ProfilerRuntimeCPU.writeAdjustTimeEvent(ti, ti.absEntryTime, ti.threadEntryTime);
        --ti.inProfilingRuntimeMethod;
    }

    public static ThreadInfo suspendCurrentThreadTimer() {
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (!ti.isInitialized() || !ti.inCallGraph) {
            return ti;
        }
        ++ti.inProfilingRuntimeMethod;
        ti.absEntryTime = Timers.getCurrentTimeInCounts();
        if (threadCPUTimerOn) {
            ti.threadEntryTime = Timers.getThreadCPUTimeInNanos();
        }
        return ti;
    }

    protected static void clearDataStructures() {
        ProfilerRuntime.clearDataStructures();
        nProfiledThreadsAllowed = nProfiledThreadsLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected static void copyLocalBuffer(ThreadInfo ti) {
        byte[] byArray;
        long absTimeStamp = 0L;
        long threadTimeStamp = 0L;
        if (eventBuffer == null) {
            return;
        }
        boolean needToAdjustTime = false;
        if (sendingBuffer) {
            absTimeStamp = Timers.getCurrentTimeInCounts();
            if (threadCPUTimerOn) {
                threadTimeStamp = Timers.getThreadCPUTimeInNanos();
            }
            byArray = eventBuffer;
            // MONITORENTER : eventBuffer
            if (sendingBuffer) {
                System.err.println("*** Sanity check failed - sendingBuffer where should have been already sent");
            }
            needToAdjustTime = true;
            // MONITOREXIT : byArray
        }
        byArray = eventBuffer;
        // MONITORENTER : eventBuffer
        if (!ti.isInitialized()) {
            // MONITOREXIT : byArray
            return;
        }
        int curPos = ti.evBufPos;
        int evBufDumpLastPos = ti.evBufDumpLastPos;
        if (globalEvBufPos + curPos - evBufDumpLastPos > globalEvBufPosThreshold) {
            sendingBuffer = true;
            if (!needToAdjustTime) {
                absTimeStamp = Timers.getCurrentTimeInCounts();
                if (threadCPUTimerOn) {
                    threadTimeStamp = Timers.getThreadCPUTimeInNanos();
                }
                needToAdjustTime = true;
            }
            externalActionsHandler.handleEventBufferDump(eventBuffer, 0, globalEvBufPos);
            globalEvBufPos = 0;
            sendingBuffer = false;
        }
        ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = 13;
        ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = (byte)(ti.threadId >> 8 & 0xFF);
        ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = (byte)(ti.threadId & 0xFF);
        System.arraycopy(ti.evBuf, evBufDumpLastPos, eventBuffer, globalEvBufPos, curPos - evBufDumpLastPos);
        globalEvBufPos += curPos - evBufDumpLastPos;
        ti.evBufPos = 0;
        ti.evBufDumpLastPos = 0;
        if (needToAdjustTime) {
            ProfilerRuntimeCPU.writeAdjustTimeEvent(ti, absTimeStamp, threadTimeStamp);
        }
        // MONITOREXIT : byArray
    }

    protected static long currentTimeInCounts() {
        return Timers.getCurrentTimeInCounts();
    }

    protected static void enableProfiling(boolean v) {
        recursiveInstrumentationDisabled = !v;
    }

    protected static void monitorEntryCPU(Thread t, Object monitor) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo(t);
        if (ti.isInitialized() && ti.inCallGraph) {
            if (ti.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++ti.inProfilingRuntimeMethod;
            ProfilerRuntimeCPU.writeWaitTimeEvent((byte)22, ti);
            --ti.inProfilingRuntimeMethod;
        }
    }

    protected static void monitorExitCPU(Thread t, Object monitor) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo(t);
        if (ti.isInitialized() && ti.inCallGraph) {
            if (ti.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++ti.inProfilingRuntimeMethod;
            ProfilerRuntimeCPU.writeWaitTimeEvent((byte)23, ti);
            --ti.inProfilingRuntimeMethod;
        }
    }

    protected static void sleepEntryCPU() {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.isInitialized() && ti.inCallGraph) {
            if (ti.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++ti.inProfilingRuntimeMethod;
            ProfilerRuntimeCPU.writeWaitTimeEvent((byte)24, ti);
            --ti.inProfilingRuntimeMethod;
        }
    }

    protected static void sleepExitCPU() {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.isInitialized() && ti.inCallGraph) {
            if (ti.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++ti.inProfilingRuntimeMethod;
            ProfilerRuntimeCPU.writeWaitTimeEvent((byte)25, ti);
            --ti.inProfilingRuntimeMethod;
        }
    }

    protected static void waitEntryCPU() {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.isInitialized() && ti.inCallGraph) {
            if (ti.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++ti.inProfilingRuntimeMethod;
            ProfilerRuntimeCPU.writeWaitTimeEvent((byte)20, ti);
            --ti.inProfilingRuntimeMethod;
        }
    }

    protected static void waitExitCPU() {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.isInitialized() && ti.inCallGraph) {
            if (ti.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++ti.inProfilingRuntimeMethod;
            ProfilerRuntimeCPU.writeWaitTimeEvent((byte)21, ti);
            --ti.inProfilingRuntimeMethod;
        }
    }

    protected static void firstTimeMethodInvoke(ThreadInfo ti, char methodId) {
        if (enableFirstTimeMethodInvoke) {
            long absTimeStamp = Timers.getCurrentTimeInCounts();
            long threadTimeStamp = threadCPUTimerOn ? Timers.getThreadCPUTimeInNanos() : 0L;
            externalActionsHandler.handleFirstTimeMethodInvoke(methodId);
            ProfilerRuntimeCPU.writeAdjustTimeEvent(ti, absTimeStamp, threadTimeStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void writeAdjustTimeEvent(ThreadInfo ti, long absTimeStamp, long threadTimeStamp) {
        byte[] evBuf = ti.evBuf;
        int curPos = ti.evBufPos;
        if (curPos > ThreadInfo.evBufPosThreshold) {
            if (eventBuffer == null) {
                return;
            }
            byte[] byArray = eventBuffer;
            // MONITORENTER : eventBuffer
            curPos = ti.evBufPos;
            boolean globalBufNeedsDump = false;
            int evBufDumpLastPos = ti.evBufDumpLastPos;
            if (globalEvBufPos + curPos - evBufDumpLastPos > globalEvBufPosThreshold) {
                globalBufNeedsDump = true;
                sendingBuffer = true;
                externalActionsHandler.handleEventBufferDump(eventBuffer, 0, globalEvBufPos);
                globalEvBufPos = 0;
                sendingBuffer = false;
            }
            ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = 13;
            ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = (byte)(ti.threadId >> 8 & 0xFF);
            ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = (byte)(ti.threadId & 0xFF);
            System.arraycopy(evBuf, evBufDumpLastPos, eventBuffer, globalEvBufPos, curPos - evBufDumpLastPos);
            globalEvBufPos += curPos - evBufDumpLastPos;
            ti.evBufPos = 0;
            ti.evBufDumpLastPos = 0;
            // MONITOREXIT : byArray
        }
        curPos = ti.evBufPos;
        evBuf[curPos++] = 5;
        long absInterval = Timers.getCurrentTimeInCounts() - absTimeStamp;
        evBuf[curPos++] = (byte)(absInterval >> 48 & 0xFFL);
        evBuf[curPos++] = (byte)(absInterval >> 40 & 0xFFL);
        evBuf[curPos++] = (byte)(absInterval >> 32 & 0xFFL);
        evBuf[curPos++] = (byte)(absInterval >> 24 & 0xFFL);
        evBuf[curPos++] = (byte)(absInterval >> 16 & 0xFFL);
        evBuf[curPos++] = (byte)(absInterval >> 8 & 0xFFL);
        evBuf[curPos++] = (byte)(absInterval & 0xFFL);
        if (threadCPUTimerOn) {
            long threadInterval = Timers.getThreadCPUTimeInNanos() - threadTimeStamp;
            evBuf[curPos++] = (byte)(threadInterval >> 48 & 0xFFL);
            evBuf[curPos++] = (byte)(threadInterval >> 40 & 0xFFL);
            evBuf[curPos++] = (byte)(threadInterval >> 32 & 0xFFL);
            evBuf[curPos++] = (byte)(threadInterval >> 24 & 0xFFL);
            evBuf[curPos++] = (byte)(threadInterval >> 16 & 0xFFL);
            evBuf[curPos++] = (byte)(threadInterval >> 8 & 0xFFL);
            evBuf[curPos++] = (byte)(threadInterval & 0xFFL);
        }
        ti.evBufPos = curPos;
    }

    static void writeServletDoMethod(ThreadInfo ti, String method, String servletPath, String sessionId) {
        int curPos = ti.evBufPos;
        int fullInfoLen = 2 + servletPath.length() * 2 + 4;
        if (curPos + fullInfoLen > ThreadInfo.evBufPosThreshold) {
            ProfilerRuntimeCPU.copyLocalBuffer(ti);
            curPos = ti.evBufPos;
        }
        byte[] evBuf = ti.evBuf;
        int methodId = -1;
        int sessionHash = -1;
        if ("GET".equals(method)) {
            methodId = 1;
        } else if ("POST".equals(method)) {
            methodId = 2;
        } else if ("PUT".equals(method)) {
            methodId = 3;
        } else if ("DELETE".equals(method)) {
            methodId = 4;
        }
        if (sessionId != null) {
            sessionHash = sessionId.hashCode();
        }
        evBuf[curPos++] = 27;
        evBuf[curPos++] = methodId;
        byte[] name = servletPath.getBytes();
        int len = name.length;
        evBuf[curPos++] = (byte)(len >> 8 & 0xFF);
        evBuf[curPos++] = (byte)(len & 0xFF);
        System.arraycopy(name, 0, evBuf, curPos, len);
        curPos += len;
        evBuf[curPos++] = (byte)(sessionHash >> 24 & 0xFF);
        evBuf[curPos++] = (byte)(sessionHash >> 16 & 0xFF);
        evBuf[curPos++] = (byte)(sessionHash >> 8 & 0xFF);
        evBuf[curPos++] = (byte)(sessionHash & 0xFF);
        ti.evBufPos = curPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeThreadCreationEvent(ThreadInfo ti) {
        Thread thread = ti.thread;
        String threadName = thread.getName();
        String threadClassName = thread.getClass().getName();
        int fullInfoLen = (threadName.length() + threadClassName.length()) * 2 + 7;
        byte[] byArray = eventBuffer;
        synchronized (eventBuffer) {
            if (globalEvBufPos + fullInfoLen > globalEvBufPosThreshold) {
                sendingBuffer = true;
                externalActionsHandler.handleEventBufferDump(eventBuffer, 0, globalEvBufPos);
                globalEvBufPos = 0;
                sendingBuffer = false;
            }
            ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = 11;
            int threadId = ti.getThreadId();
            ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = (byte)(threadId >> 8 & 0xFF);
            ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = (byte)(threadId & 0xFF);
            byte[] name = threadName.getBytes();
            int len = name.length;
            ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = (byte)(len >> 8 & 0xFF);
            ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = (byte)(len & 0xFF);
            System.arraycopy(name, 0, eventBuffer, globalEvBufPos, len);
            globalEvBufPos += len;
            name = threadClassName.getBytes();
            len = name.length;
            ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = (byte)(len >> 8 & 0xFF);
            ProfilerRuntimeCPU.eventBuffer[ProfilerRuntimeCPU.globalEvBufPos++] = (byte)(len & 0xFF);
            System.arraycopy(name, 0, eventBuffer, globalEvBufPos, len);
            globalEvBufPos += len;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    static void writeTimeStampedEvent(byte eventType, ThreadInfo ti, char methodId) {
        int curPos = ti.evBufPos;
        if (curPos > ThreadInfo.evBufPosThreshold) {
            ProfilerRuntimeCPU.copyLocalBuffer(ti);
            curPos = ti.evBufPos;
        }
        byte[] evBuf = ti.evBuf;
        if (!ti.isInitialized()) {
            return;
        }
        evBuf[curPos++] = eventType;
        evBuf[curPos++] = (byte)(methodId >> 8 & 0xFF);
        evBuf[curPos++] = (byte)(methodId & 0xFF);
        if (absoluteTimerOn) {
            long absTimeStamp = Timers.getCurrentTimeInCounts();
            evBuf[curPos++] = (byte)(absTimeStamp >> 48 & 0xFFL);
            evBuf[curPos++] = (byte)(absTimeStamp >> 40 & 0xFFL);
            evBuf[curPos++] = (byte)(absTimeStamp >> 32 & 0xFFL);
            evBuf[curPos++] = (byte)(absTimeStamp >> 24 & 0xFFL);
            evBuf[curPos++] = (byte)(absTimeStamp >> 16 & 0xFFL);
            evBuf[curPos++] = (byte)(absTimeStamp >> 8 & 0xFFL);
            evBuf[curPos++] = (byte)(absTimeStamp & 0xFFL);
        }
        if (threadCPUTimerOn) {
            long threadTimeStamp = Timers.getThreadCPUTimeInNanos();
            evBuf[curPos++] = (byte)(threadTimeStamp >> 48 & 0xFFL);
            evBuf[curPos++] = (byte)(threadTimeStamp >> 40 & 0xFFL);
            evBuf[curPos++] = (byte)(threadTimeStamp >> 32 & 0xFFL);
            evBuf[curPos++] = (byte)(threadTimeStamp >> 24 & 0xFFL);
            evBuf[curPos++] = (byte)(threadTimeStamp >> 16 & 0xFFL);
            evBuf[curPos++] = (byte)(threadTimeStamp >> 8 & 0xFFL);
            evBuf[curPos++] = (byte)(threadTimeStamp & 0xFFL);
        }
        ti.evBufPos = curPos;
    }

    static void writeWaitTimeEvent(byte eventType, ThreadInfo ti) {
        int curPos = ti.evBufPos;
        if (curPos > ThreadInfo.evBufPosThreshold) {
            ProfilerRuntimeCPU.copyLocalBuffer(ti);
            curPos = ti.evBufPos;
        }
        byte[] evBuf = ti.evBuf;
        evBuf[curPos++] = eventType;
        long absTimeStamp = Timers.getCurrentTimeInCounts();
        evBuf[curPos++] = (byte)(absTimeStamp >> 48 & 0xFFL);
        evBuf[curPos++] = (byte)(absTimeStamp >> 40 & 0xFFL);
        evBuf[curPos++] = (byte)(absTimeStamp >> 32 & 0xFFL);
        evBuf[curPos++] = (byte)(absTimeStamp >> 24 & 0xFFL);
        evBuf[curPos++] = (byte)(absTimeStamp >> 16 & 0xFFL);
        evBuf[curPos++] = (byte)(absTimeStamp >> 8 & 0xFFL);
        evBuf[curPos++] = (byte)(absTimeStamp & 0xFFL);
        ti.evBufPos = curPos;
    }

    private static void servletDoMethodHook(ThreadInfo ti, Object request) {
        String servletPath = null;
        String method = null;
        String requestedSessionId = null;
        if (getRequestedSessionIdMethod == null) {
            try {
                Class<?> requestClass = request.getClass();
                getRequestedSessionIdMethod = requestClass.getMethod("getRequestedSessionId", null);
                getMethodMethod = requestClass.getMethod("getMethod", null);
                getServletPathMethod = requestClass.getMethod("getServletPath", null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        try {
            requestedSessionId = (String)getRequestedSessionIdMethod.invoke(request, null);
            method = (String)getMethodMethod.invoke(request, null);
            servletPath = (String)getServletPathMethod.invoke(request, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        ProfilerRuntimeCPU.writeServletDoMethod(ti, method, servletPath, requestedSessionId);
    }

    static {
        recursiveInstrumentationDisabled = false;
        javaLangReflectMethodInvokeInterceptEnabled = false;
    }
}

