/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support.hostinfo.impl;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;

public final class HostInfoFactory {
    private static final String UNKNOWN = "UNKNOWN";

    private HostInfoFactory() {
    }

    static HostInfo newHostInfo(Properties initData, Map<String, String> environment) {
        HostInfoImpl info = new HostInfoImpl();
        OSImpl _os = new OSImpl();
        _os.setBitness(HostInfoFactory.getInt(initData, "BITNESS", 32));
        _os.setFamily(initData.getProperty("OSFAMILY", UNKNOWN));
        _os.setName(initData.getProperty("OSNAME", UNKNOWN));
        _os.setVersion(initData.getProperty("OSBUILD", UNKNOWN));
        info.os = _os;
        info.hostname = initData.getProperty("HOSTNAME", UNKNOWN);
        try {
            info.cpuFamily = HostInfo.CpuFamily.valueOf(initData.getProperty("CPUFAMILY", UNKNOWN).toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            info.cpuFamily = HostInfo.CpuFamily.UNKNOWN;
        }
        info.loginShell = initData.getProperty("SH", UNKNOWN);
        info.tempDir = initData.getProperty("TMPDIRBASE", UNKNOWN);
        info.userDir = initData.getProperty("USERDIRBASE", UNKNOWN);
        info.cpuNum = HostInfoFactory.getInt(initData, "CPUNUM", 1);
        if (environment == null) {
            info.environment = Collections.unmodifiableMap(Collections.emptyMap());
        } else {
            info.environment = Collections.unmodifiableMap(environment);
        }
        if (initData.containsKey("LOCALTIME")) {
            long localTime = (Long)initData.get("LOCALTIME");
            long remoteTime = HostInfoFactory.getTime(initData, "DATETIME", localTime);
            info.clockSkew = remoteTime - localTime;
        }
        return info;
    }

    private static int getInt(Properties props, String key, int defaultValue) {
        int result = defaultValue;
        String value = props.getProperty(key, null);
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return result;
    }

    private static long getTime(Properties props, String key, long defaultValue) {
        long result = defaultValue;
        String value = props.getProperty(key, null);
        if (value != null) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("y-M-d H:m:s");
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                Date date = df.parse(value);
                result = date.getTime();
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        return result;
    }

    static String getNBKey() {
        int hashCode = System.getProperty("netbeans.user", "").hashCode();
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            hashCode = 3 * hashCode + 5 * localhost.getHostName().hashCode();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return Integer.toHexString(hashCode);
    }

    static final class OSImpl
    implements HostInfo.OS {
        private HostInfo.OSFamily family = HostInfo.OSFamily.UNKNOWN;
        private String name = "UNKNOWN";
        private String version = "UNKNOWN";
        private HostInfo.Bitness bitness = HostInfo.Bitness._32;

        OSImpl() {
        }

        @Override
        public HostInfo.Bitness getBitness() {
            return this.bitness;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public HostInfo.OSFamily getFamily() {
            return this.family;
        }

        @Override
        public String getName() {
            return this.name;
        }

        private void setVersion(String version) {
            this.version = version;
        }

        private void setBitness(int bitness) {
            this.bitness = bitness == 64 ? HostInfo.Bitness._64 : HostInfo.Bitness._32;
        }

        private void setFamily(String family) {
            try {
                this.family = HostInfo.OSFamily.valueOf(family.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        private void setName(String name) {
            this.name = name;
        }
    }

    private static class HostInfoImpl
    implements HostInfo {
        private HostInfo.OS os;
        private HostInfo.CpuFamily cpuFamily;
        private String hostname;
        private String loginShell;
        private String tempDir;
        private String userDir;
        private int cpuNum;
        private long clockSkew;
        private Map<String, String> environment;

        private HostInfoImpl() {
        }

        @Override
        public HostInfo.OS getOS() {
            return this.os;
        }

        @Override
        public HostInfo.CpuFamily getCpuFamily() {
            return this.cpuFamily;
        }

        @Override
        public int getCpuNum() {
            return this.cpuNum;
        }

        @Override
        public HostInfo.OSFamily getOSFamily() {
            return this.os.getFamily();
        }

        @Override
        public String getHostname() {
            return this.hostname;
        }

        @Override
        public String getLoginShell() {
            return this.loginShell;
        }

        @Override
        public String getShell() {
            return "/bin/sh";
        }

        @Override
        public String getTempDir() {
            return this.tempDir;
        }

        @Override
        public String getUserDir() {
            return this.userDir;
        }

        @Override
        public File getUserDirFile() {
            if (this.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
                return new File(WindowsSupport.getInstance().convertToWindowsPath(this.userDir));
            }
            return new File(this.userDir);
        }

        @Override
        public File getTempDirFile() {
            if (this.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
                return new File(WindowsSupport.getInstance().convertToWindowsPath(this.tempDir));
            }
            return new File(this.tempDir);
        }

        @Override
        public long getClockSkew() {
            return this.clockSkew;
        }

        @Override
        public Map<String, String> getEnvironment() {
            return this.environment;
        }
    }
}

