/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.ProcessInfo;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.NativeTaskExecutorService;

public final class NativeProcessExecutionService {
    private final ExecutionTask task;
    private final String descr;

    private NativeProcessExecutionService(ExecutionTask task, String descr) {
        this.task = task;
        this.descr = descr;
    }

    public static NativeProcessExecutionService newService(NativeProcessBuilder npb, LineProcessor outProcessor, LineProcessor errProcessor, String descr) {
        ExecutionTask task = new ExecutionTask(npb, outProcessor, errProcessor, descr);
        return new NativeProcessExecutionService(task, descr);
    }

    public Future<Integer> start() {
        return NativeTaskExecutorService.submit(this.task, this.descr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessInfo getProcessInfo() {
        ExecutionTask executionTask = this.task;
        synchronized (executionTask) {
            if (this.task.process == null) {
                throw new IllegalThreadStateException("Not started yet");
            }
            return this.task.process.getProcessInfo();
        }
    }

    private static class ExecutionTask
    implements Callable<Integer> {
        private static final java.util.logging.Logger log = Logger.getInstance();
        private final NativeProcessBuilder npb;
        private final LineProcessor outProcessor;
        private final LineProcessor errProcessor;
        private final String descr;
        private NativeProcess process = null;

        public ExecutionTask(NativeProcessBuilder npb, LineProcessor outProcessor, LineProcessor errProcessor, String descr) {
            this.npb = npb;
            this.outProcessor = outProcessor;
            this.errProcessor = errProcessor;
            this.descr = descr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Integer call() throws Exception {
            int result;
            block30: {
                if (this.process != null) {
                    throw new IllegalThreadStateException("Already started!");
                }
                result = -1;
                InputStream is = null;
                BufferedReader br = null;
                try {
                    if (this.outProcessor != null) {
                        this.outProcessor.reset();
                    }
                    if (this.errProcessor != null) {
                        this.errProcessor.reset();
                    }
                    this.process = this.npb.call();
                    is = this.process.getInputStream();
                    if (is == null) break block30;
                    br = new BufferedReader(new InputStreamReader(is));
                    try {
                        String line;
                        while ((line = br.readLine()) != null) {
                            if (this.outProcessor == null) continue;
                            this.outProcessor.processLine(line);
                        }
                    }
                    catch (InterruptedIOException ex) {
                        Thread.interrupted();
                    }
                }
                catch (Throwable th) {
                    log.log(Level.FINE, this.descr, th.getMessage());
                }
                finally {
                    try {
                        if (this.outProcessor != null) {
                            this.outProcessor.close();
                        }
                    }
                    catch (Throwable th) {
                        log.log(Level.FINE, this.descr, th.getMessage());
                    }
                    if (br != null) {
                        br.close();
                    }
                    if (this.process != null) {
                        try {
                            result = this.process.exitValue();
                        }
                        catch (Throwable th) {}
                        this.process.destroy();
                    }
                }
            }
            if (result != 0) {
                if (this.errProcessor != null) {
                    for (String line : ProcessUtils.readProcessError(this.process)) {
                        this.errProcessor.processLine(line);
                    }
                    this.errProcessor.close();
                } else {
                    ProcessUtils.logError(Level.FINE, log, this.process);
                }
            }
            return result;
        }
    }
}

