/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.deps.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.deps.ArtifactKind;
import org.netbeans.modules.javacard.project.deps.Dependency;
import org.netbeans.modules.javacard.project.deps.DependencyKind;
import org.netbeans.modules.javacard.project.deps.DeploymentStrategy;
import org.netbeans.modules.javacard.project.deps.ResolvedDependencies;
import org.netbeans.modules.javacard.project.deps.ResolvedDependency;
import org.netbeans.modules.javacard.project.deps.ui.ChooseDependencyKindWizardPanel;
import org.netbeans.modules.javacard.project.deps.ui.ChooseDeploymentStrategyWizardPanel;
import org.netbeans.modules.javacard.project.deps.ui.ChooseOriginWizardPanel;
import org.netbeans.modules.javacard.project.deps.ui.ChooseSigOrExpFilePanel;
import org.netbeans.modules.javacard.project.deps.ui.IntermediatePanelKind;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class AddDependencyWizardIterator
implements WizardDescriptor.Iterator<Map<String, Object>> {
    static final String PROP_RESOLVED_DEPS = "_resolvedDependencies";
    static final String PROP_TARGET_PROJECT = "_targetProject";
    private int index;
    private WizardDescriptor.Panel<Map<String, Object>>[] panels;
    private WizardDescriptor wiz;
    private IntermediatePanelKind intermediatePanelKind;
    private final ChangeSupport supp = new ChangeSupport((Object)this);

    public static ResolvedDependency show(ResolvedDependencies deps, JCProject project) {
        boolean cancelled;
        AddDependencyWizardIterator iter = new AddDependencyWizardIterator();
        Map<String, Object> settings = Collections.synchronizedMap(new HashMap());
        settings.put(PROP_RESOLVED_DEPS, deps);
        settings.put(PROP_TARGET_PROJECT, project);
        WizardDescriptor desc = new WizardDescriptor((WizardDescriptor.Iterator)iter, settings);
        iter.setWizardDescriptor(desc);
        desc.setTitleFormat(new MessageFormat("{0} ({1})"));
        desc.setTitle(NbBundle.getMessage(AddDependencyWizardIterator.class, (String)"TTL_ADD_LIBRARY"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)desc);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl = cancelled = desc.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!cancelled) {
            String nm;
            DependencyKind kind = (DependencyKind)((Object)settings.get("_actualDepKind"));
            DeploymentStrategy depStrat = (DeploymentStrategy)((Object)settings.get("_deploymentStrategy"));
            File origin = (File)settings.get("_originFile");
            File expFile = (File)settings.get("_expFile");
            File sigFile = (File)settings.get("_sigFile");
            File sourceRoot = (File)settings.get("_sourceRoot");
            assert (origin != null);
            assert (depStrat != null);
            assert (kind != null);
            String id = nm = origin.getName();
            int ix = 0;
            while (deps.get(id) != null) {
                id = nm + "_" + ix++;
            }
            HashMap<ArtifactKind, String> paths = new HashMap<ArtifactKind, String>();
            paths.put(ArtifactKind.ORIGIN, origin.getAbsolutePath());
            if (expFile != null && kind.supportedArtifacts().contains((Object)ArtifactKind.EXP_FILE)) {
                paths.put(ArtifactKind.EXP_FILE, expFile.getAbsolutePath());
            }
            if (sigFile != null && kind.supportedArtifacts().contains((Object)ArtifactKind.SIG_FILE)) {
                paths.put(ArtifactKind.SIG_FILE, sigFile.getAbsolutePath());
            }
            if (sourceRoot != null && kind.supportedArtifacts().contains((Object)ArtifactKind.SOURCES_PATH)) {
                paths.put(ArtifactKind.SOURCES_PATH, sourceRoot.getAbsolutePath());
            }
            return deps.add(new Dependency(id, kind, depStrat), paths);
        }
        return null;
    }

    private void setWizardDescriptor(WizardDescriptor w) {
        this.wiz = w;
    }

    synchronized IntermediatePanelKind getIntermediatePanelKind() {
        return this.intermediatePanelKind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIntermediatePanelKind(IntermediatePanelKind kind) {
        assert (!EventQueue.isDispatchThread());
        AddDependencyWizardIterator addDependencyWizardIterator = this;
        synchronized (addDependencyWizardIterator) {
            this.intermediatePanelKind = kind;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    AddDependencyWizardIterator.this.supp.fireChange();
                }
            });
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private WizardDescriptor.Panel<Map<String, Object>>[] createPanels() {
        return new WizardDescriptor.Panel[]{new ChooseDependencyKindWizardPanel(this.wiz), new ChooseOriginWizardPanel(this.wiz, this), new ChooseSigOrExpFilePanel(this.wiz), new ChooseDeploymentStrategyWizardPanel(this.wiz)};
    }

    private WizardDescriptor.Panel<Map<String, Object>>[] panels() {
        WizardDescriptor.Panel<Map<String, Object>>[] pnls = this.panels == null ? (this.panels = this.createPanels()) : this.panels;
        IntermediatePanelKind pk = this.getIntermediatePanelKind();
        WizardDescriptor.Panel[] result = new WizardDescriptor.Panel[pk == null ? pnls.length - 1 : pnls.length];
        for (int i = 0; i < result.length; ++i) {
            if (i <= 1) {
                result[i] = pnls[i];
                continue;
            }
            if (pk != null) {
                result[i] = pnls[i];
                continue;
            }
            if (i <= 1) continue;
            result[i] = pnls[i + 1];
        }
        return result;
    }

    private WizardDescriptor.Panel<Map<String, Object>>[] getPanels() {
        WizardDescriptor.Panel<Map<String, Object>>[] pnls = this.panels();
        String[] steps = new String[pnls.length];
        for (int i = 0; i < pnls.length; ++i) {
            Component c = pnls[i].getComponent();
            steps[i] = c.getName();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        }
        return pnls;
    }

    public WizardDescriptor.Panel<Map<String, Object>> current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return NbBundle.getMessage(AddDependencyWizardIterator.class, (String)"LOCATION_IN_WIZARD", (Object)(this.index + 1), (Object)this.getPanels().length);
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
        this.supp.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.supp.removeChangeListener(l);
    }
}

