/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.spi.project.support.GenericSources;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.SourcesHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class JCProjectSources
implements Sources,
ChangeListener,
PropertyChangeListener {
    private static final String BUILD_DIR_PROP = "${build.dir}";
    private static final String DIST_DIR_PROP = "${dist.dir}";
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private SourcesHelper sourcesHelper;
    private Sources delegate;
    private boolean externalRootsRegistered;
    private final JCProject project;
    private final Set<ChangeListener> listeners = Collections.synchronizedSet(new HashSet());

    JCProjectSources(JCProject project, AntProjectHelper helper, PropertyEvaluator evaluator, SourceRoots sourceRoots) {
        this.project = project;
        this.helper = helper;
        this.evaluator = evaluator;
        this.sourceRoots = sourceRoots;
        this.sourceRoots.addPropertyChangeListener((PropertyChangeListener)this);
        this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
        this.initSources();
    }

    public SourceGroup[] getSourceGroups(final String type) {
        return (SourceGroup[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<SourceGroup[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SourceGroup[] run() {
                FileObject libLoc;
                Sources _delegate;
                JCProjectSources jCProjectSources = JCProjectSources.this;
                synchronized (jCProjectSources) {
                    if (JCProjectSources.this.delegate == null) {
                        JCProjectSources.this.delegate = JCProjectSources.this.initSources();
                        JCProjectSources.this.delegate.addChangeListener((ChangeListener)JCProjectSources.this);
                    }
                    _delegate = JCProjectSources.this.delegate;
                }
                SourceGroup[] groups = _delegate.getSourceGroups(type);
                if (type.equals("generic") && (libLoc = JCProjectSources.this.getSharedLibraryFolderLocation()) != null) {
                    SourceGroup[] grps = new SourceGroup[groups.length + 1];
                    System.arraycopy(groups, 0, grps, 0, groups.length);
                    grps[grps.length - 1] = GenericSources.group(null, (FileObject)libLoc, (String)"sharedlibraries", (String)NbBundle.getMessage(JCProjectSources.class, (String)"LibrarySourceGroup_DisplayName"), null, null);
                    groups = grps;
                }
                return groups;
            }
        });
    }

    private FileObject getSharedLibraryFolderLocation() {
        String libLoc = this.helper.getLibrariesLocation();
        if (libLoc != null) {
            FileObject libLocFO;
            String libLocEval = this.evaluator.evaluate(libLoc);
            File file = null;
            if (libLocEval != null) {
                file = this.helper.resolveFile(libLocEval);
            }
            if ((libLocFO = FileUtil.toFileObject(file)) != null) {
                FileObject libLocParent = libLocFO.getParent();
                return libLocParent;
            }
        }
        return null;
    }

    private Sources initSources() {
        this.sourcesHelper = new SourcesHelper((Project)this.project, this.helper, this.evaluator);
        this.register(this.sourceRoots);
        this.sourcesHelper.addNonSourceRoot(BUILD_DIR_PROP);
        this.sourcesHelper.addNonSourceRoot(DIST_DIR_PROP);
        this.externalRootsRegistered = false;
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            @Override
            public void run() {
                if (!JCProjectSources.this.externalRootsRegistered) {
                    JCProjectSources.this.sourcesHelper.registerExternalRoots(0, false);
                    JCProjectSources.this.externalRootsRegistered = true;
                }
            }
        });
        return this.sourcesHelper.createSources();
    }

    private void register(SourceRoots roots) {
        String[] propNames = roots.getRootProperties();
        String[] rootNames = roots.getRootNames();
        for (int i = 0; i < propNames.length; ++i) {
            String prop = propNames[i];
            String displayName = roots.getRootDisplayName(rootNames[i], prop);
            String loc = "${" + prop + "}";
            this.sourcesHelper.sourceRoot(loc).displayName(displayName).type("java").add();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ChangeListener[] l;
        JCProjectSources jCProjectSources = this;
        synchronized (jCProjectSources) {
            if (this.delegate != null) {
                this.delegate.removeChangeListener((ChangeListener)this);
                this.delegate = null;
            }
        }
        for (ChangeListener cl : l = this.listeners.toArray(new ChangeListener[this.listeners.size()])) {
            try {
                cl.stateChanged(new ChangeEvent(this));
            }
            catch (IllegalStateException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (SourceRoots.PROP_ROOT_PROPERTIES.equals(propName) || "build.dir".equals(propName) || "dist.dir".equals(propName)) {
            this.fireChange();
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.fireChange();
    }
}

