/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMacroParameter;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmParameterList;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableIdentifiableBase;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;

public class ParameterListImpl<T, K extends CsmNamedElement>
extends OffsetableIdentifiableBase<T>
implements CsmParameterList<K> {
    private final Collection<?> parameters;

    protected ParameterListImpl(CsmFile csmFile, int n, int n2, Collection<?> collection) {
        super(csmFile, n, n2);
        this.parameters = collection == null || collection.isEmpty() ? null : collection;
    }

    public final Collection<K> getParameters() {
        return this._getParameters();
    }

    public final boolean isEmpty() {
        return this.parameters == null || this.parameters.isEmpty();
    }

    public final int getNrParameters() {
        return this.parameters == null ? 0 : this.parameters.size();
    }

    @Override
    public void dispose() {
        super.dispose();
        RepositoryUtils.remove(this._getUIDs());
    }

    private Collection<K> _getParameters() {
        if (this.parameters == null) {
            return Collections.emptyList();
        }
        Object obj = this.parameters.iterator().next();
        Collection<Object> collection = obj instanceof CsmUID ? UIDCsmConverter.UIDsToCsmObjects(this.parameters) : new ArrayList(this.parameters);
        return collection;
    }

    private Collection<CsmUID<K>> _getUIDs() {
        if (this.parameters == null) {
            return null;
        }
        Object obj = this.parameters.iterator().next();
        Collection<?> collection = null;
        if (obj instanceof CsmUID) {
            collection = this.parameters;
        }
        return collection;
    }

    @Override
    public String toString() {
        return "ParamList " + super.toString();
    }

    @Override
    protected CsmUID<CsmParameterList<K>> createUID() {
        return UIDUtilities.createParamListUID(this);
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUIDCollection(this._getUIDs(), dataOutput, false);
    }

    public ParameterListImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        int n = dataInput.readInt();
        this.parameters = n <= 0 ? null : UIDObjectFactory.getDefaultFactory().readUIDCollection(new ArrayList(n), dataInput, n);
    }

    public static ParameterListImpl<CsmParameterList<CsmMacroParameter>, CsmMacroParameter> create(CsmFile csmFile, APTMacro aPTMacro) {
        return ParameterListImpl.create(csmFile, aPTMacro.getName(), aPTMacro.getParams());
    }

    public static ParameterListImpl<CsmParameterList<CsmMacroParameter>, CsmMacroParameter> create(CsmFile csmFile, APTDefine aPTDefine) {
        return ParameterListImpl.create(csmFile, aPTDefine.getName(), aPTDefine.getParams());
    }

    private static ParameterListImpl<CsmParameterList<CsmMacroParameter>, CsmMacroParameter> create(CsmFile csmFile, APTToken aPTToken, Collection<APTToken> collection) {
        return null;
    }
}

