/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.gsp;

import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.IndentTask;
import org.netbeans.modules.groovy.gsp.lexer.GspTokenId;

public class GspIndentTask
implements IndentTask {
    private Context context;

    GspIndentTask(Context context) {
        this.context = context;
    }

    public void reindent() throws BadLocationException {
        BaseDocument doc = (BaseDocument)this.context.document();
        int start = this.context.startOffset();
        int end = Math.min(this.context.endOffset(), doc.getLength());
        this.reindent(doc, start, end);
    }

    private void reindent(BaseDocument doc, int start, int end) throws BadLocationException {
        doc.putProperty((Object)"HTML_FORMATTER_ACTS_ON_TOP_LEVEL", (Object)Boolean.TRUE);
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = th.tokenSequence(GspTokenId.language());
        if (ts == null) {
            return;
        }
        int offset = Utilities.getRowStart((BaseDocument)doc, (int)end);
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        boolean prevWasNonHtml = false;
        while (offset >= start) {
            int lineStart = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
            if (lineStart != -1) {
                TokenId id;
                prevWasNonHtml = false;
                ts.move(lineStart);
                if (ts.moveNext() && (id = ts.token().id()) != GspTokenId.HTML) {
                    prevWasNonHtml = true;
                    offsets.add(offset);
                }
            } else if (prevWasNonHtml) {
                offsets.add(offset);
            }
            if (offset <= 0) break;
            --offset;
            offset = Utilities.getRowStart((BaseDocument)doc, (int)offset);
        }
        if (offsets.size() > 0) {
            for (Integer lineOffset : offsets) {
                this.context.modifyIndent(Utilities.getRowStart((BaseDocument)doc, (int)lineOffset), 0);
            }
        }
    }

    public ExtraLock indentLock() {
        return null;
    }
}

