/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.hints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.AstNodeVisitor;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.jsf.editor.JsfUtils;
import org.netbeans.modules.web.jsf.editor.facelets.CompositeComponentLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrary;
import org.netbeans.modules.web.jsf.editor.hints.HintsProvider;
import org.netbeans.modules.web.jsf.editor.tld.LibraryDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ComponentUsagesChecker
extends HintsProvider {
    @Override
    public List<Hint> compute(RuleContext context) {
        ArrayList<Hint> hints = new ArrayList<Hint>();
        this.checkCCCalls(hints, context);
        return hints;
    }

    private void checkCCCalls(final List<Hint> hints, final RuleContext context) {
        HtmlParserResult result = (HtmlParserResult)context.parserResult;
        final Snapshot snapshot = result.getSnapshot();
        Map<String, FaceletsLibrary> declaredLibraries = JsfUtils.getDeclaredLibraries(result);
        for (String declaredLibraryNamespace : declaredLibraries.keySet()) {
            final FaceletsLibrary lib = declaredLibraries.get(declaredLibraryNamespace);
            AstNode root = result.root(declaredLibraryNamespace);
            if (root == null) continue;
            final Document doc = snapshot.getSource().getDocument(true);
            final AtomicReference docTextRef = new AtomicReference();
            doc.render(new Runnable(){

                @Override
                public void run() {
                    try {
                        docTextRef.set(doc.getText(0, doc.getLength()));
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
            final String docText = (String)docTextRef.get();
            AstNodeUtils.visitChildren((AstNode)root, (AstNodeVisitor)new AstNodeVisitor(){

                public void visit(AstNode node) {
                    if (node.type() == AstNode.NodeType.OPEN_TAG) {
                        String tagName = node.getNameWithoutPrefix();
                        FaceletsLibrary.NamedComponent component = lib.getComponent(tagName);
                        if (component == null) {
                            Hint hint = new Hint((Rule)HintsProvider.DEFAULT_ERROR_RULE, NbBundle.getMessage(HintsProvider.class, (String)"MSG_UNKNOWN_CC_COMPONENT", (Object)lib.getDisplayName()), context.parserResult.getSnapshot().getSource().getFileObject(), JsfUtils.createOffsetRange(snapshot, docText, node.startOffset(), node.endOffset()), Collections.EMPTY_LIST, 50);
                            hints.add(hint);
                        } else {
                            LibraryDescriptor.Tag tag = component.getTag();
                            if (tag != null) {
                                Hint hint;
                                if (component instanceof CompositeComponentLibrary.CompositeComponent && !tag.hasNonGenenericAttributes()) {
                                    return;
                                }
                                Collection<LibraryDescriptor.Attribute> attrs = tag.getAttributes();
                                for (LibraryDescriptor.Attribute attr : attrs) {
                                    if (!attr.isRequired() || node.getAttribute(attr.getName()) != null) continue;
                                    hint = new Hint((Rule)HintsProvider.DEFAULT_ERROR_RULE, NbBundle.getMessage(HintsProvider.class, (String)"MSG_MISSING_REQUIRED_ATTRIBUTE", (Object)attr.getName()), context.parserResult.getSnapshot().getSource().getFileObject(), JsfUtils.createOffsetRange(snapshot, docText, node.startOffset(), node.endOffset()), Collections.EMPTY_LIST, 50);
                                    hints.add(hint);
                                }
                                for (AstNode.Attribute nodeAttr : node.getAttributes()) {
                                    if (nodeAttr.namespacePrefix() != null || tag.getAttribute(nodeAttr.name()) != null || "xmlns".equals(nodeAttr.name().toLowerCase(Locale.ENGLISH))) continue;
                                    hint = new Hint((Rule)HintsProvider.DEFAULT_ERROR_RULE, NbBundle.getMessage(HintsProvider.class, (String)"MSG_UNKNOWN_ATTRIBUTE", (Object)nodeAttr.name()), context.parserResult.getSnapshot().getSource().getFileObject(), JsfUtils.createOffsetRange(snapshot, docText, nodeAttr.nameOffset(), nodeAttr.valueOffset() + nodeAttr.value().length()), Collections.EMPTY_LIST, 50);
                                    hints.add(hint);
                                }
                            }
                        }
                    }
                }
            });
        }
    }
}

