/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.options;

import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.hints.jackpot.impl.RulesManager;
import org.netbeans.modules.java.hints.jackpot.spi.HintMetadata;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.openide.util.ChangeSupport;

public class HintsSettings {
    static final AbstractHint.HintSeverity SEVERITY_DEFAUT = AbstractHint.HintSeverity.WARNING;
    static final boolean IN_TASK_LIST_DEFAULT = true;
    public static HintsAccessor HINTS_ACCESSOR;
    static final String ENABLED_KEY = "enabled";
    static final String SEVERITY_KEY = "severity";
    static final String IN_TASK_LIST_KEY = "inTaskList";
    private static final String DEFAULT_PROFILE = "default";
    private static Map<String, Preferences> preferencesOverride;
    private static final ChangeSupport cs;

    private HintsSettings() {
    }

    public static String getCurrentProfileId() {
        return DEFAULT_PROFILE;
    }

    public static boolean isEnabled(HintMetadata hintMetadata) {
        Preferences preferences = RulesManager.getPreferences(hintMetadata.id, HintsSettings.getCurrentProfileId());
        return HintsSettings.isEnabled(hintMetadata, preferences);
    }

    public static boolean isShowInTaskList(HintMetadata hintMetadata) {
        Preferences preferences = RulesManager.getPreferences(hintMetadata.id, HintsSettings.getCurrentProfileId());
        return HintsSettings.isShowInTaskList(hintMetadata, preferences);
    }

    public static boolean isEnabled(HintMetadata hintMetadata, Preferences preferences) {
        return preferences.getBoolean(ENABLED_KEY, hintMetadata.enabled);
    }

    public static boolean isEnabled(AbstractHint abstractHint, Preferences preferences) {
        return preferences.getBoolean(ENABLED_KEY, HINTS_ACCESSOR.isEnabledDefault(abstractHint));
    }

    public static void setEnabled(HintMetadata hintMetadata, boolean bl) {
        HintsSettings.setEnabled(RulesManager.getPreferences(hintMetadata.id, HintsSettings.getCurrentProfileId()), bl);
        HintsSettings.fireChangeEvent();
    }

    public static void setEnabled(Preferences preferences, boolean bl) {
        preferences.putBoolean(ENABLED_KEY, bl);
    }

    public static boolean isShowInTaskList(HintMetadata hintMetadata, Preferences preferences) {
        Preferences preferences2 = RulesManager.getPreferences(hintMetadata.id, HintsSettings.getCurrentProfileId());
        return preferences.getBoolean(IN_TASK_LIST_KEY, hintMetadata.showInTaskList);
    }

    public static void setShowInTaskList(Preferences preferences, boolean bl) {
        preferences.putBoolean(IN_TASK_LIST_KEY, bl);
    }

    public static AbstractHint.HintSeverity getSeverity(HintMetadata hintMetadata, Preferences preferences) {
        String string = preferences.get(SEVERITY_KEY, null);
        return string == null ? hintMetadata.severity : AbstractHint.HintSeverity.valueOf(string);
    }

    public static AbstractHint.HintSeverity getSeverity(AbstractHint abstractHint, Preferences preferences) {
        String string = preferences.get(SEVERITY_KEY, null);
        return string == null ? HINTS_ACCESSOR.severiryDefault(abstractHint) : AbstractHint.HintSeverity.valueOf(string);
    }

    public static void setSeverity(Preferences preferences, AbstractHint.HintSeverity hintSeverity) {
        preferences.put(SEVERITY_KEY, hintSeverity.name());
    }

    public static String[] getSuppressedBy(AbstractHint abstractHint) {
        return HINTS_ACCESSOR.getSuppressBy(abstractHint);
    }

    public static void setPreferencesOverride(Map<String, Preferences> map) {
        preferencesOverride = map;
    }

    public static Map<String, Preferences> getPreferencesOverride() {
        return preferencesOverride;
    }

    public static void addChangeListener(ChangeListener changeListener) {
        cs.addChangeListener(changeListener);
    }

    public static void removeChangeListener(ChangeListener changeListener) {
        cs.removeChangeListener(changeListener);
    }

    public static void fireChangeEvent() {
        cs.fireChange();
    }

    static {
        cs = new ChangeSupport(HintsSettings.class);
    }

    public static interface HintsAccessor {
        public boolean isEnabledDefault(AbstractHint var1);

        public boolean isShowInTaskListDefault(AbstractHint var1);

        public AbstractHint.HintSeverity severiryDefault(AbstractHint var1);

        public String[] getSuppressBy(AbstractHint var1);
    }
}

