/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.analyzer.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.java.hints.analyzer.Analyzer;
import org.netbeans.modules.java.hints.analyzer.ui.CheckTreeView;
import org.netbeans.modules.java.hints.analyzer.ui.FixDescription;
import org.netbeans.modules.java.hints.analyzer.ui.NextError;
import org.netbeans.modules.java.hints.analyzer.ui.Nodes;
import org.netbeans.modules.java.hints.analyzer.ui.PreviousError;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class AnalyzerTopComponent
extends TopComponent
implements ExplorerManager.Provider,
ChangeListener {
    private static AnalyzerTopComponent instance;
    private static final String PREFERRED_ID = "AnalyzerTopComponent";
    private Lookup context;
    private Map<String, Preferences> preferencesOverlay;
    private final ExplorerManager manager = new ExplorerManager();
    private final CheckTreeView btv;
    private final List<FixDescription> fixes = new LinkedList<FixDescription>();
    private boolean applyingFixes;
    private JPanel btvHolder;
    private JButton fixButton;
    private JCheckBox fixOnNext;
    private JCheckBox goOverFixed;
    private JButton nextError;
    private JButton previousError;
    private JButton refreshButton;
    List<Node> nodesForNext;
    List<Node> seenNodes;
    boolean lastGoOverFixed;
    final PreviousError prevAction;
    final NextError nextAction;

    private AnalyzerTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(AnalyzerTopComponent.class, (String)"CTL_AnalyzerTopComponent"));
        this.setToolTipText(NbBundle.getMessage(AnalyzerTopComponent.class, (String)"HINT_AnalyzerTopComponent"));
        this.btv = new CheckTreeView();
        this.btvHolder.setLayout(new BorderLayout());
        this.btvHolder.add((Component)((Object)this.btv), "Center");
        this.btv.setRootVisible(false);
        this.prevAction = new PreviousError(this);
        this.nextAction = new NextError(this);
        PCLImpl pCLImpl = new PCLImpl();
        this.prevAction.addPropertyChangeListener(pCLImpl);
        this.nextAction.addPropertyChangeListener(pCLImpl);
        this.setData(Lookup.EMPTY, Collections.<String, Preferences>emptyMap(), Collections.<ErrorDescription>emptyList());
        this.stateChanged(null);
        this.getActionMap().put("jumpNext", this.nextAction);
        this.getActionMap().put("jumpPrev", this.prevAction);
    }

    private void initComponents() {
        this.btvHolder = new JPanel();
        this.refreshButton = new JButton();
        this.fixButton = new JButton();
        this.goOverFixed = new JCheckBox();
        this.fixOnNext = new JCheckBox();
        this.nextError = new JButton();
        this.previousError = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.btvHolder.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 1));
        GroupLayout groupLayout = new GroupLayout(this.btvHolder);
        this.btvHolder.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 650, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 254, Short.MAX_VALUE));
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/java/hints/analyzer/ui/refresh.png")));
        this.refreshButton.setToolTipText(NbBundle.getBundle(AnalyzerTopComponent.class).getString("AnalyzerTopComponent.refreshButton.toolTipText"));
        this.refreshButton.setBorder(BorderFactory.createEtchedBorder());
        this.refreshButton.setContentAreaFilled(false);
        this.refreshButton.setMaximumSize(new Dimension(24, 24));
        this.refreshButton.setMinimumSize(new Dimension(24, 24));
        this.refreshButton.setPreferredSize(new Dimension(24, 24));
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzerTopComponent.this.refreshButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.fixButton, (String)NbBundle.getMessage(AnalyzerTopComponent.class, (String)"AnalyzerTopComponent.fixButton.text"));
        this.fixButton.setToolTipText(NbBundle.getBundle(AnalyzerTopComponent.class).getString("AnalyzerTopComponent.fixButton.toolTipText"));
        this.fixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzerTopComponent.this.fixButtonActionPerformed(actionEvent);
            }
        });
        this.goOverFixed.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.goOverFixed, (String)NbBundle.getMessage(AnalyzerTopComponent.class, (String)"AnalyzerTopComponent.goOverFixed.text"));
        this.goOverFixed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzerTopComponent.this.goOverFixedActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.fixOnNext, (String)NbBundle.getMessage(AnalyzerTopComponent.class, (String)"AnalyzerTopComponent.fixOnNext.text"));
        this.fixOnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzerTopComponent.this.fixOnNextActionPerformed(actionEvent);
            }
        });
        this.nextError.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/java/hints/analyzer/ui/nextmatch.png")));
        this.nextError.setToolTipText(NbBundle.getBundle(AnalyzerTopComponent.class).getString("AnalyzerTopComponent.nextError.toolTipText"));
        this.nextError.setBorder(BorderFactory.createEtchedBorder());
        this.nextError.setContentAreaFilled(false);
        this.nextError.setMaximumSize(new Dimension(24, 24));
        this.nextError.setMinimumSize(new Dimension(24, 24));
        this.nextError.setPreferredSize(new Dimension(24, 24));
        this.nextError.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzerTopComponent.this.nextErrorActionPerformed(actionEvent);
            }
        });
        this.previousError.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/java/hints/analyzer/ui/prevmatch.png")));
        this.previousError.setToolTipText(NbBundle.getBundle(AnalyzerTopComponent.class).getString("AnalyzerTopComponent.previousError.toolTipText"));
        this.previousError.setBorder(BorderFactory.createEtchedBorder());
        this.previousError.setContentAreaFilled(false);
        this.previousError.setMaximumSize(new Dimension(24, 24));
        this.previousError.setMinimumSize(new Dimension(24, 24));
        this.previousError.setPreferredSize(new Dimension(24, 24));
        this.previousError.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzerTopComponent.this.previousErrorActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.previousError, -2, -1, -2).addComponent(this.refreshButton, -2, -1, -2).addComponent(this.nextError, -2, -1, -2)).addGap(2, 2, 2).addComponent(this.btvHolder, -1, -1, Short.MAX_VALUE)).addGroup(groupLayout2.createSequentialGroup().addGap(4, 4, 4).addComponent(this.fixButton).addGap(18, 18, 18).addComponent(this.goOverFixed).addGap(18, 18, 18).addComponent(this.fixOnNext))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.refreshButton, -2, -1, -2).addGap(1, 1, 1).addComponent(this.previousError, -2, 24, -2).addGap(1, 1, 1).addComponent(this.nextError, -2, -1, -2)).addComponent(this.btvHolder, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.goOverFixed).addComponent(this.fixOnNext).addComponent(this.fixButton)).addContainerGap()));
        this.refreshButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AnalyzerTopComponent.class, (String)"ACSD_Refresh"));
        this.fixButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AnalyzerTopComponent.class, (String)"ACSD_FixSelected"));
        this.goOverFixed.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AnalyzerTopComponent.class, (String)"ACSD_GoOverFixedProblems"));
        this.fixOnNext.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AnalyzerTopComponent.class, (String)"ACSD_FixOnNext"));
        this.nextError.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AnalyzerTopComponent.class, (String)"ACSD_Next"));
        this.previousError.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AnalyzerTopComponent.class, (String)"ACSD_Previous"));
    }

    private void refreshButtonActionPerformed(ActionEvent actionEvent) {
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixButtonActionPerformed(ActionEvent actionEvent) {
        LinkedList<FixDescription> linkedList = new LinkedList<FixDescription>();
        for (FixDescription fixDescription : this.fixes) {
            if (!fixDescription.isSelected()) continue;
            linkedList.add(fixDescription);
        }
        this.applyingFixes = true;
        try {
            ProgressUtils.showProgressDialogAndRun((ProgressRunnable)new FixWorker(linkedList), (String)NbBundle.getMessage(AnalyzerTopComponent.class, (String)"CAP_ApplyingFixes"), (boolean)false);
        }
        finally {
            this.applyingFixes = false;
            this.stateChanged(null);
        }
    }

    private void previousErrorActionPerformed(ActionEvent actionEvent) {
        this.prevAction.actionPerformed(null);
    }

    private void nextErrorActionPerformed(ActionEvent actionEvent) {
        this.nextAction.actionPerformed(null);
    }

    private void goOverFixedActionPerformed(ActionEvent actionEvent) {
        this.prevAction.fireEnabledChanged();
        this.nextAction.fireEnabledChanged();
    }

    private void fixOnNextActionPerformed(ActionEvent actionEvent) {
        this.prevAction.fireEnabledChanged();
        this.nextAction.fireEnabledChanged();
    }

    public static synchronized AnalyzerTopComponent getDefault() {
        if (instance == null) {
            instance = new AnalyzerTopComponent();
        }
        return instance;
    }

    public void setData(Lookup lookup, Map<String, Preferences> map, List<ErrorDescription> list) {
        this.context = lookup;
        this.preferencesOverlay = map;
        for (FixDescription fixDescription : this.fixes) {
            fixDescription.removeChangeListener(this);
        }
        this.fixes.clear();
        this.manager.setRootContext(Nodes.constructSemiLogicalView(this.sortErrors(list), this.fixes));
        for (FixDescription fixDescription : this.fixes) {
            fixDescription.addChangeListener(this);
        }
        if (this.btv != null) {
            this.btv.expandAll();
        }
        this.refreshButton.setEnabled(Analyzer.normalizeLookup(lookup) != null);
        this.nodesForNext = null;
        this.seenNodes = null;
        this.fireActionEnabledChange();
    }

    public void refresh() {
        Analyzer.process(this.context, this.preferencesOverlay);
    }

    public static synchronized AnalyzerTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            Logger.getLogger(AnalyzerTopComponent.class.getName()).warning("Cannot find AnalyzerTopComponent component. It will not be located properly in the window system.");
            return AnalyzerTopComponent.getDefault();
        }
        if (topComponent instanceof AnalyzerTopComponent) {
            return (AnalyzerTopComponent)topComponent;
        }
        Logger.getLogger(AnalyzerTopComponent.class.getName()).warning("There seem to be multiple components with the 'AnalyzerTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return AnalyzerTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private Map<FileObject, List<ErrorDescription>> sortErrors(List<ErrorDescription> list) {
        HashMap<FileObject, List<ErrorDescription>> hashMap = new HashMap<FileObject, List<ErrorDescription>>();
        for (ErrorDescription errorDescription : list) {
            LinkedList<ErrorDescription> linkedList = (LinkedList<ErrorDescription>)hashMap.get(errorDescription.getFile());
            if (linkedList == null) {
                linkedList = new LinkedList<ErrorDescription>();
                hashMap.put(errorDescription.getFile(), linkedList);
            }
            linkedList.add(errorDescription);
        }
        return hashMap;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.applyingFixes) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (FixDescription fixDescription : this.fixes) {
            if (fixDescription.isSelected()) {
                bl = true;
            }
            if (!fixDescription.isFixed()) continue;
            bl2 = true;
        }
        this.fixButton.setEnabled(bl);
        this.goOverFixed.setEnabled(bl2);
        this.fireActionEnabledChange();
    }

    void fireActionEnabledChange() {
        this.prevAction.fireEnabledChanged();
        this.nextAction.fireEnabledChanged();
    }

    boolean fixOnNext() {
        return this.fixOnNext.isEnabled() && this.fixOnNext.isSelected();
    }

    boolean goOverFixed() {
        return this.goOverFixed.isEnabled() && this.goOverFixed.isSelected();
    }

    private static final class FixWorker
    implements ProgressRunnable<Void>,
    Cancellable {
        private final AtomicBoolean cancel = new AtomicBoolean();
        private final List<FixDescription> fixes;

        public FixWorker(List<FixDescription> list) {
            this.fixes = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void run(ProgressHandle progressHandle) {
            progressHandle.switchToDeterminate(this.fixes.size());
            int n = 0;
            for (FixDescription fixDescription : this.fixes) {
                if (this.cancel.get()) break;
                try {
                    fixDescription.implement();
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
                finally {
                    progressHandle.progress(++n);
                }
            }
            progressHandle.finish();
            return null;
        }

        public boolean cancel() {
            this.cancel.set(true);
            return true;
        }
    }

    private class PCLImpl
    implements PropertyChangeListener {
        private PCLImpl() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null || "enabled".equals(string)) {
                AnalyzerTopComponent.this.previousError.setEnabled(AnalyzerTopComponent.this.prevAction.isEnabled());
                AnalyzerTopComponent.this.nextError.setEnabled(AnalyzerTopComponent.this.nextAction.isEnabled());
            }
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return AnalyzerTopComponent.getDefault();
        }
    }
}

