/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;
import org.netbeans.modules.php.editor.elements.BaseFunctionElementSupport;
import org.netbeans.modules.php.editor.elements.IndexQueryImpl;
import org.netbeans.modules.php.editor.elements.ParameterElementImpl;
import org.netbeans.modules.php.editor.elements.PhpElementImpl;
import org.netbeans.modules.php.editor.elements.TypeResolverImpl;
import org.netbeans.modules.php.editor.index.Signature;
import org.openide.util.Parameters;

public final class MethodElementImpl
extends PhpElementImpl
implements MethodElement {
    public static final String IDX_FIELD = "method";
    public static final String IDX_CONSTRUCTOR_FIELD = "constructor";
    private final PhpModifiers modifiers;
    private final TypeElement enclosingType;
    private final BaseFunctionElementSupport functionSupport;
    private final boolean isMagic;

    private MethodElementImpl(TypeElement enclosingType, String methodName, boolean isMagic, int offset, int flags, String fileUrl, ElementQuery elementQuery, List<ParameterElement> parameters, Set<TypeResolver> returnTypes) {
        super(methodName, enclosingType.getName(), fileUrl, offset, elementQuery);
        boolean isFromInterface = enclosingType != null && enclosingType.isInterface();
        this.modifiers = PhpModifiers.fromBitMask(isFromInterface ? flags | 0x400 | 1 : flags);
        this.isMagic = isMagic;
        this.enclosingType = enclosingType;
        this.functionSupport = new BaseFunctionElementSupport(parameters, returnTypes);
    }

    public static Set<MethodElement> getMagicMethods(TypeElement type) {
        HashSet<MethodElement> retval = new HashSet<MethodElement>();
        retval.add(MethodElementImpl.createMagicMethod(type, "__callStatic", 9, "$name", "$arguments"));
        retval.add(MethodElementImpl.createMagicMethod(type, "__set_state", 9, "$array"));
        retval.add(MethodElementImpl.createMagicMethod(type, "__call", 1, "$name", "$arguments"));
        retval.add(MethodElementImpl.createMagicMethod(type, "__clone", 1, new String[0]));
        retval.add(MethodElementImpl.createMagicMethod(type, "__construct", 1, new String[0]));
        retval.add(MethodElementImpl.createMagicMethod(type, "__destruct", 1, new String[0]));
        retval.add(MethodElementImpl.createMagicMethod(type, "__get", 1, "$name"));
        retval.add(MethodElementImpl.createMagicMethod(type, "__set", 1, "$name", "$value"));
        retval.add(MethodElementImpl.createMagicMethod(type, "__isset", 1, "$name"));
        retval.add(MethodElementImpl.createMagicMethod(type, "__unset", 1, "$name"));
        retval.add(MethodElementImpl.createMagicMethod(type, "__sleep", 1, new String[0]));
        retval.add(MethodElementImpl.createMagicMethod(type, "__wakeup", 1, new String[0]));
        retval.add(MethodElementImpl.createMagicMethod(type, "__toString", 1, new String[0]));
        return retval;
    }

    public static MethodElement createMagicMethod(TypeElement type, String methodName, int flags, String ... arguments) {
        MethodElementImpl retval = new MethodElementImpl(type, methodName, true, 0, flags, type.getFilenameUrl(), null, MethodElementImpl.fromParameterNames(arguments), Collections.<TypeResolver>emptySet());
        return retval;
    }

    private static List<ParameterElement> fromParameterNames(String ... names) {
        ArrayList<ParameterElement> retval = new ArrayList<ParameterElement>();
        for (String parameterName : names) {
            retval.add(new ParameterElementImpl(parameterName, null, 0, Collections.<TypeResolver>emptySet(), true, true, false));
        }
        return retval;
    }

    public static Set<MethodElement> fromSignature(TypeElement type, IndexQueryImpl indexQuery, IndexResult indexResult) {
        return MethodElementImpl.fromSignature(type, NameKind.empty(), indexQuery, indexResult);
    }

    public static Set<MethodElement> fromSignature(TypeElement type, NameKind query, IndexQueryImpl indexQuery, IndexResult indexResult) {
        String[] values = indexResult.getValues(IDX_FIELD);
        HashSet<MethodElement> retval = values.length > 0 ? new HashSet<MethodElement>() : Collections.emptySet();
        for (String val : values) {
            MethodElement method = MethodElementImpl.fromSignature(type, query, indexQuery, indexResult, Signature.get(val));
            if (method == null) continue;
            retval.add(method);
        }
        return retval;
    }

    private static MethodElement fromSignature(TypeElement type, NameKind query, IndexQueryImpl indexScopeQuery, IndexResult indexResult, Signature sig) {
        Parameters.notNull((CharSequence)"NameKind query: can't be null", (Object)query);
        MethodSignatureParser signParser = new MethodSignatureParser(sig);
        MethodElementImpl retval = null;
        if (MethodElementImpl.matchesQuery(query, signParser)) {
            retval = new MethodElementImpl(type, signParser.getMethodName(), false, signParser.getOffset(), signParser.getFlags(), indexResult.getUrl().toString(), indexScopeQuery, signParser.getParameters(), signParser.getReturnTypes());
        }
        return retval;
    }

    private static boolean matchesQuery(NameKind query, MethodSignatureParser signParser) {
        Parameters.notNull((CharSequence)"NameKind query: can't be null", (Object)query);
        return query instanceof NameKind.Empty || query.matchesName(MethodElement.KIND, signParser.getMethodName());
    }

    public static Set<MethodElement> fromConstructorSignature(TypeElement type, IndexQueryImpl indexQuery, IndexResult indexResult) {
        String[] values = indexResult.getValues(IDX_CONSTRUCTOR_FIELD);
        HashSet<MethodElement> retval = new HashSet<MethodElement>();
        for (String val : values) {
            retval.add(MethodElementImpl.fromConstructorSignature(type, indexQuery, indexResult, Signature.get(val)));
        }
        return retval;
    }

    public static MethodElement fromConstructorSignature(TypeElement type, IndexQueryImpl indexScopeQuery, IndexResult indexResult, Signature sig) {
        MethodSignatureParser signParser = new MethodSignatureParser(sig);
        MethodElementImpl retval = new MethodElementImpl(type, "__construct", false, signParser.getOffset(), signParser.getFlags(), indexResult.getUrl().toString(), indexScopeQuery, signParser.getParameters(), signParser.getReturnTypes());
        return retval;
    }

    @Override
    public List<ParameterElement> getParameters() {
        return this.functionSupport.getParameters();
    }

    @Override
    public Collection<TypeResolver> getReturnTypes() {
        return this.functionSupport.getReturnTypes();
    }

    @Override
    public String asString(BaseFunctionElement.PrintAs as) {
        return this.functionSupport.asString(as, this);
    }

    @Override
    public final PhpElementKind getPhpElementKind() {
        return MethodElement.KIND;
    }

    @Override
    public final PhpModifiers getPhpModifiers() {
        return this.modifiers;
    }

    @Override
    public final TypeElement getType() {
        return this.enclosingType;
    }

    @Override
    public boolean isConstructor() {
        NameKind.Exact exactName = NameKind.exact(this.getName());
        return exactName.matchesName(this.getPhpElementKind(), "__construct") || exactName.matchesName(this.getPhpElementKind(), this.getType().getName());
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        sb.append(this.getName()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        sb.append(this.getSignatureLastPart());
        this.checkSignature(sb);
        return sb.toString();
    }

    public String getConstructorSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getType().getName().toLowerCase()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        sb.append(this.getType().getName()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        sb.append(this.getSignatureLastPart());
        this.checkConstructorSignature(sb);
        return sb.toString();
    }

    private String getSignatureLastPart() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getOffset()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        List<ParameterElement> parameterList = this.getParameters();
        for (int idx = 0; idx < parameterList.size(); ++idx) {
            ParameterElementImpl parameter = (ParameterElementImpl)parameterList.get(idx);
            if (idx > 0) {
                sb.append((Object)PhpElementImpl.SEPARATOR.COMMA);
            }
            sb.append(parameter.getSignature());
        }
        sb.append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        for (TypeResolver typeResolver : this.getReturnTypes()) {
            TypeResolverImpl resolverImpl = (TypeResolverImpl)typeResolver;
            sb.append(resolverImpl.getSignature());
        }
        sb.append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        sb.append(this.getPhpModifiers().toFlags()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        return sb.toString();
    }

    @Override
    public boolean isStatic() {
        return this.getPhpModifiers().isStatic();
    }

    @Override
    public boolean isPublic() {
        return this.getPhpModifiers().isPublic();
    }

    @Override
    public boolean isProtected() {
        return this.getPhpModifiers().isProtected();
    }

    @Override
    public boolean isPrivate() {
        return this.getPhpModifiers().isPrivate();
    }

    @Override
    public boolean isFinal() {
        return this.getPhpModifiers().isFinal();
    }

    @Override
    public boolean isAbstract() {
        return this.getPhpModifiers().isAbstract();
    }

    @Override
    public final boolean isMagic() {
        return this.isMagic;
    }

    private void checkSignature(StringBuilder sb) {
        boolean checkEnabled = false;
        if (!$assertionsDisabled) {
            checkEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (checkEnabled) {
            String retval = sb.toString();
            MethodSignatureParser parser = new MethodSignatureParser(Signature.get(retval));
            assert (this.getName().equals(parser.getMethodName()));
            assert (this.getOffset() == parser.getOffset());
            assert (this.getPhpModifiers().toFlags() == parser.getFlags());
            assert (this.getParameters().size() == parser.getParameters().size());
            assert (this.getReturnTypes().size() == parser.getReturnTypes().size());
        }
    }

    private void checkConstructorSignature(StringBuilder sb) {
        boolean checkEnabled = false;
        if (!$assertionsDisabled) {
            checkEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (checkEnabled) {
            String retval = sb.toString();
            MethodSignatureParser parser = new MethodSignatureParser(Signature.get(retval));
            assert (this.getName().equals("__construct"));
            assert (this.getOffset() == parser.getOffset());
            assert (this.getPhpModifiers().toFlags() == parser.getFlags());
            assert (this.getParameters().size() == parser.getParameters().size());
        }
    }

    private static class MethodSignatureParser {
        private final Signature signature;

        MethodSignatureParser(Signature signature) {
            this.signature = signature;
        }

        String getMethodName() {
            return this.signature.string(1);
        }

        int getOffset() {
            return this.signature.integer(2);
        }

        List<ParameterElement> getParameters() {
            return ParameterElementImpl.parseParameters(this.signature.string(3));
        }

        int getFlags() {
            return this.signature.integer(5);
        }

        Set<TypeResolver> getReturnTypes() {
            return TypeResolverImpl.parseTypes(this.signature.string(4));
        }
    }
}

