/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Map;
import org.netbeans.editor.Settings;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.MIMEOptionFile;
import org.netbeans.modules.editor.options.OptionUtilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertiesMIMEOptionFile
extends MIMEOptionFile {
    public static final String TAG_ROOT = "properties";
    public static final String TAG_PROPERTY = "property";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_VALUE = "value";
    static final String FILENAME = "properties";

    public PropertiesMIMEOptionFile(BaseOptions base, Object proc) {
        super(base, proc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadSettings(boolean propagate) {
        assert (false) : "PropertiesMIMEOptionFile should not be used anymore. Please file a bug (http://www.netbeans.org/community/issues.html) for editor/settings and attach this stacktrace to it.";
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            Document doc = this.dom;
            Element rootElement = doc.getDocumentElement();
            if (!"properties".equals(rootElement.getTagName())) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.properties.clear();
            NodeList prop = rootElement.getElementsByTagName(TAG_PROPERTY);
            for (int i = 0; i < prop.getLength(); ++i) {
                Class<?> clazz2;
                Node node = prop.item(i);
                Element propElem = (Element)node;
                if (propElem == null) continue;
                String name = propElem.getAttribute(ATTR_NAME);
                String className = propElem.getAttribute(ATTR_CLASS);
                String value = propElem.getAttribute(ATTR_VALUE);
                try {
                    clazz2 = Class.forName(className);
                }
                catch (ClassNotFoundException cnfe) {
                    continue;
                }
                if (Boolean.class.isAssignableFrom(clazz2)) {
                    Boolean boolValue = Boolean.valueOf(value);
                    if (propagate) {
                        this.base.doSetSettingValue(name, boolValue, null);
                    }
                    this.properties.put(name, boolValue);
                    continue;
                }
                if (Integer.class.isAssignableFrom(clazz2)) {
                    Integer intValue = Integer.valueOf(value);
                    if (intValue == null) continue;
                    if (propagate) {
                        this.base.doSetSettingValue(name, intValue, null);
                    }
                    this.properties.put(name, intValue);
                    continue;
                }
                if (Float.class.isAssignableFrom(clazz2)) {
                    Float floatValue = Float.valueOf(value);
                    if (floatValue == null) continue;
                    if (propagate) {
                        this.base.doSetSettingValue(name, floatValue, null);
                    }
                    this.properties.put(name, floatValue);
                    continue;
                }
                if (Insets.class.isAssignableFrom(clazz2)) {
                    Insets insetsValue = OptionUtilities.parseInsets(value);
                    if (insetsValue == null) continue;
                    if (propagate) {
                        this.base.doSetSettingValue(name, insetsValue, null);
                    }
                    this.properties.put(name, insetsValue);
                    continue;
                }
                if (Dimension.class.isAssignableFrom(clazz2)) {
                    Dimension dimensionValue = OptionUtilities.parseDimension(value);
                    if (dimensionValue == null) continue;
                    if (propagate) {
                        this.base.doSetSettingValue(name, dimensionValue, null);
                    }
                    this.properties.put(name, dimensionValue);
                    continue;
                }
                if (Color.class.isAssignableFrom(clazz2)) {
                    Color colorValue = OptionUtilities.string2Color(value);
                    if (colorValue == null) continue;
                    if (propagate) {
                        this.base.doSetSettingValue(name, colorValue, null);
                    }
                    this.properties.put(name, colorValue);
                    continue;
                }
                if (!String.class.isAssignableFrom(clazz2) || value == null) continue;
                if (propagate && !"indentEngine".equals(name)) {
                    this.base.doSetSettingValue(name, value, null);
                }
                this.properties.put(name, value);
            }
            if (propagate) {
                this.setLoaded(true);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateSettings(Map changedProp) {
        assert (false) : "PropertiesMIMEOptionFile should not be used anymore. Please file a bug (http://www.netbeans.org/community/issues.html) for editor/settings and attach this stacktrace to it.";
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            boolean save = false;
            for (String key : changedProp.keySet()) {
                if (changedProp.get(key) instanceof Boolean) {
                    if (changedProp.get(key).equals(this.properties.put(key, changedProp.get(key)))) continue;
                    save = true;
                    continue;
                }
                if (changedProp.get(key) instanceof Integer) {
                    if (changedProp.get(key).equals(this.properties.put(key, changedProp.get(key)))) continue;
                    save = true;
                    continue;
                }
                if (changedProp.get(key) instanceof Float) {
                    if (changedProp.get(key).equals(this.properties.put(key, changedProp.get(key)))) continue;
                    save = true;
                    continue;
                }
                if (changedProp.get(key) instanceof Insets) {
                    if (changedProp.get(key).equals(this.properties.put(key, changedProp.get(key)))) continue;
                    save = true;
                    continue;
                }
                if (changedProp.get(key) instanceof Dimension) {
                    if (changedProp.get(key).equals(this.properties.put(key, changedProp.get(key)))) continue;
                    save = true;
                    continue;
                }
                if (changedProp.get(key) instanceof Color) {
                    if (changedProp.get(key).equals(this.properties.put(key, changedProp.get(key)))) continue;
                    save = true;
                    continue;
                }
                if (!(changedProp.get(key) instanceof String) || changedProp.get(key).equals(this.properties.put(key, changedProp.get(key)))) continue;
                save = true;
            }
            if (!save) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            Document doc = XMLUtil.createDocument((String)"properties", null, (String)this.processor.getPublicID(), (String)this.processor.getSystemID());
            Element rootElem = doc.getDocumentElement();
            for (String key : this.properties.keySet()) {
                String value;
                String className;
                if (this.properties.get(key) instanceof Boolean) {
                    className = "java.lang.Boolean";
                    Boolean booleanValue = (Boolean)this.properties.get(key);
                    value = booleanValue.toString();
                } else if (this.properties.get(key) instanceof Integer) {
                    className = "java.lang.Integer";
                    Integer intValue = (Integer)this.properties.get(key);
                    value = Integer.toString(intValue);
                } else if (this.properties.get(key) instanceof Float) {
                    className = "java.lang.Float";
                    Float floatValue = (Float)this.properties.get(key);
                    value = Float.toString(floatValue.floatValue());
                } else if (this.properties.get(key) instanceof Insets) {
                    className = "java.awt.Insets";
                    Insets insetsValue = (Insets)this.properties.get(key);
                    value = OptionUtilities.insetsToString(insetsValue);
                } else if (this.properties.get(key) instanceof Dimension) {
                    className = "java.awt.Dimension";
                    Dimension dimensionValue = (Dimension)this.properties.get(key);
                    value = OptionUtilities.dimensionToString(dimensionValue);
                } else if (this.properties.get(key) instanceof Color) {
                    className = "java.awt.Color";
                    Color colorValue = (Color)this.properties.get(key);
                    value = OptionUtilities.color2String(colorValue);
                } else {
                    if (!(this.properties.get(key) instanceof String)) continue;
                    className = "java.lang.String";
                    value = (String)this.properties.get(key);
                }
                String name = key;
                Element propElem = doc.createElement(TAG_PROPERTY);
                propElem.setAttribute(ATTR_NAME, name);
                propElem.setAttribute(ATTR_CLASS, className);
                propElem.setAttribute(ATTR_VALUE, value);
                rootElem.appendChild(propElem);
            }
            doc.getDocumentElement().normalize();
            this.saveSettings(doc);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

