/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.editor.Acceptor;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.Settings;
import org.netbeans.editor.TokenCategory;
import org.netbeans.editor.TokenContext;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.modules.editor.lib.ColoringMap;
import org.netbeans.modules.editor.lib.KitsTracker;

public class SettingsUtil {
    public static final String TOKEN_COLORING_INITIALIZER_NAME_SUFFIX = "token-coloring-initializer";
    public static final PrintColoringEvaluator defaultPrintColoringEvaluator = new PrintColoringEvaluator();
    private static final float defaultPrintFontSize = 10.0f;

    public static List getClonedList(List l) {
        return l != null ? new ArrayList(l) : new ArrayList();
    }

    public static List getClonedList(Class kitClass, String settingName) {
        return SettingsUtil.getClonedList((List)Settings.getValue(kitClass, settingName));
    }

    public static List getClonedList(Map settingsMap, String settingName) {
        if (settingsMap != null) {
            return SettingsUtil.getClonedList((List)settingsMap.get(settingName));
        }
        return null;
    }

    public static Map getClonedMap(Map m) {
        return m != null ? new HashMap(m) : new HashMap();
    }

    public static Map getClonedMap(Class kitClass, String settingName) {
        return SettingsUtil.getClonedMap((Map)Settings.getValue(kitClass, settingName));
    }

    public static Map getClonedMap(Map settingsMap, String settingName) {
        if (settingsMap != null) {
            return SettingsUtil.getClonedMap((Map)settingsMap.get(settingName));
        }
        return null;
    }

    public static Object getValue(Class kitClass, String settingName, Object defaultValue) {
        Object value = Settings.getValue(kitClass, settingName);
        return value != null ? value : defaultValue;
    }

    public static int getInteger(Class kitClass, String settingName, int defaultValue) {
        Object value = Settings.getValue(kitClass, settingName);
        return value instanceof Integer ? (Integer)value : defaultValue;
    }

    public static int getInteger(Class kitClass, String settingName, Integer defaultValue) {
        return SettingsUtil.getInteger(kitClass, settingName, (int)defaultValue);
    }

    public static int getPositiveInteger(Class kitClass, String settingName, int defaultValue) {
        int ret = SettingsUtil.getInteger(kitClass, settingName, defaultValue);
        if (ret <= 0) {
            ret = defaultValue;
        }
        return ret;
    }

    public static int getPositiveInteger(Class kitClass, String settingName, Integer defaultValue) {
        return SettingsUtil.getPositiveInteger(kitClass, settingName, (int)defaultValue);
    }

    public static int getNonNegativeInteger(Class kitClass, String settingName, int defaultValue) {
        int ret = SettingsUtil.getInteger(kitClass, settingName, defaultValue);
        if (ret < 0) {
            ret = defaultValue;
        }
        return ret;
    }

    public static int getNonNegativeInteger(Class kitClass, String settingName, Integer defaultValue) {
        return SettingsUtil.getNonNegativeInteger(kitClass, settingName, (int)defaultValue);
    }

    public static boolean getBoolean(Class kitClass, String settingName, boolean defaultValue) {
        Object value = Settings.getValue(kitClass, settingName);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    public static boolean getBoolean(Class kitClass, String settingName, Boolean defaultValue) {
        return SettingsUtil.getBoolean(kitClass, settingName, (boolean)defaultValue);
    }

    public static String getString(Class kitClass, String settingName, String defaultValue) {
        Object value = Settings.getValue(kitClass, settingName);
        return value instanceof String ? (String)value : defaultValue;
    }

    public static Acceptor getAcceptor(Class kitClass, String settingName, Acceptor defaultValue) {
        Object value = Settings.getValue(kitClass, settingName);
        return value instanceof Acceptor ? (Acceptor)value : defaultValue;
    }

    public static List getList(Class kitClass, String settingName, List defaultValue) {
        Object value = Settings.getValue(kitClass, settingName);
        return value instanceof List ? (List)value : defaultValue;
    }

    public static List getCumulativeList(Class kitClass, String settingName, List defaultValue) {
        Settings.KitAndValue[] kva = Settings.getValueHierarchy(kitClass, settingName);
        if (kva != null && kva.length > 0) {
            ArrayList l = new ArrayList();
            for (int i = 0; i < kva.length; ++i) {
                if (!(kva[i].value instanceof List)) continue;
                l.addAll((List)kva[i].value);
            }
            return l;
        }
        return defaultValue;
    }

    public static Map getMap(Class kitClass, String settingName, Map defaultValue) {
        Object value = Settings.getValue(kitClass, settingName);
        return value instanceof Map ? (Map)value : defaultValue;
    }

    public static void updateListSetting(Class kitClass, String settingName, Object[] addToList) {
        if (addToList != null && addToList.length > 0) {
            List l = SettingsUtil.getClonedList(kitClass, settingName);
            l.addAll(Arrays.asList(addToList));
            Settings.setValue(kitClass, settingName, l);
        }
    }

    public static void updateListSetting(Map settingsMap, String settingName, Object[] addToList) {
        if (settingsMap != null && addToList != null && addToList.length > 0) {
            List l = SettingsUtil.getClonedList(settingsMap, settingName);
            l.addAll(Arrays.asList(addToList));
            settingsMap.put(settingName, l);
        }
    }

    private static String getColoringSettingName(String coloringName, boolean printingSet) {
        return (coloringName + (printingSet ? "-print-coloring" : "-coloring")).intern();
    }

    public static Coloring getColoring(Class kitClass, String coloringName, boolean printingSet) {
        return (Coloring)SettingsUtil.getColoring(kitClass, coloringName, printingSet, true);
    }

    public static Object getColoring(Class kitClass, String coloringName, boolean printingSet, boolean evaluateEvaluators) {
        return Settings.getValue(kitClass, SettingsUtil.getColoringSettingName(coloringName, printingSet), evaluateEvaluators);
    }

    public static Coloring getTokenColoring(TokenContextPath tcp, TokenCategory tokenIDOrCategory, boolean printingSet) {
        return (Coloring)SettingsUtil.getTokenColoring(tcp, tokenIDOrCategory, printingSet, true);
    }

    public static Object getTokenColoring(TokenContextPath tcp, TokenCategory tokenIDOrCategory, boolean printingSet, boolean evaluateEvaluators) {
        return SettingsUtil.getColoring(BaseKit.class, tcp.getFullTokenName(tokenIDOrCategory), printingSet, evaluateEvaluators);
    }

    public static Object getColoring(Map settingsMap, String coloringName, boolean printingSet) {
        return settingsMap.get(SettingsUtil.getColoringSettingName(coloringName, printingSet));
    }

    public static void setColoring(Class kitClass, String coloringName, Object newValue, boolean printingSet) {
    }

    public static void setColoring(Class kitClass, String coloringName, Object componentColoringNewValue) {
        SettingsUtil.setColoring(kitClass, coloringName, componentColoringNewValue, false);
    }

    public static void setColoring(Class kitClass, String coloringName, Object componentColoringNewValue, Object printColoringNewValue) {
        SettingsUtil.setColoring(kitClass, coloringName, componentColoringNewValue, false);
    }

    public static void setColoring(Map settingsMap, String coloringName, Object newValue, boolean printingSet) {
        settingsMap.put(SettingsUtil.getColoringSettingName(coloringName, printingSet), newValue);
    }

    public static void setColoring(Map settingsMap, String coloringName, Object componentColoringNewValue) {
        SettingsUtil.setColoring(settingsMap, coloringName, componentColoringNewValue, false);
    }

    public static void setColoring(Map settingsMap, String coloringName, Object componentColoringNewValue, Object printColoringNewValue) {
        SettingsUtil.setColoring(settingsMap, coloringName, componentColoringNewValue, false);
    }

    public static Map<String, Coloring> getColoringMap(Class kitClass, boolean printingSet, boolean evaluateEvaluators) {
        String mimeType = KitsTracker.getInstance().findMimeType(kitClass);
        Map cm = ColoringMap.get((String)mimeType).getMap();
        return new HashMap<String, Coloring>(cm);
    }

    public static void setColoringMap(Class kitClass, Map coloringMap, boolean printingSet) {
        throw new UnsupportedOperationException("Use Editor Settings Storage API instead");
    }

    public static Settings.Initializer getColoringMapInitializer(Class kitClass, Map coloringMap, boolean printingSet, String initializerName) {
        return new ColoringMapInitializer(kitClass, coloringMap, printingSet, initializerName);
    }

    static class ColoringMapInitializer
    extends Settings.AbstractInitializer {
        private Class kitClass;
        private HashMap baseKitMap;
        private HashMap kitClassMap;

        ColoringMapInitializer(Class kitClass, Map coloringMap, boolean printingSet, String initializerName) {
            super(initializerName);
            this.kitClass = kitClass;
            this.baseKitMap = new HashMap(31);
            this.kitClassMap = new HashMap(37);
            List colNameList = SettingsUtil.getCumulativeList(kitClass, "coloring-name-list", null);
            if (colNameList != null && coloringMap != null && coloringMap.size() > 0) {
                HashSet nameSet = new HashSet(colNameList);
                for (String name : coloringMap.keySet()) {
                    Object coloring = coloringMap.get(name);
                    if (nameSet.contains(name)) {
                        SettingsUtil.setColoring((Map)this.kitClassMap, name, coloring, printingSet);
                        continue;
                    }
                    SettingsUtil.setColoring((Map)this.baseKitMap, name, coloring, printingSet);
                }
            }
        }

        @Override
        public void updateSettingsMap(Class kitClass, Map settingsMap) {
            if (kitClass == BaseKit.class) {
                settingsMap.putAll(this.baseKitMap);
            } else if (kitClass == this.kitClass) {
                settingsMap.putAll(this.kitClassMap);
            }
        }
    }

    public static abstract class TokenColoringInitializer
    extends Settings.AbstractInitializer {
        private TokenContext tokenContext;

        public TokenColoringInitializer(TokenContext tokenContext) {
            this(tokenContext, tokenContext.getNamePrefix() + SettingsUtil.TOKEN_COLORING_INITIALIZER_NAME_SUFFIX);
        }

        public TokenColoringInitializer(TokenContext tokenContext, String initializerName) {
            super(initializerName);
            this.tokenContext = tokenContext;
        }

        @Override
        public void updateSettingsMap(Class kitClass, Map settingsMap) {
            if (kitClass == BaseKit.class) {
                TokenContextPath[] allPaths = this.tokenContext.getAllContextPaths();
                for (int i = 0; i < allPaths.length; ++i) {
                    TokenContextPath tcp = allPaths[i];
                    boolean printingSet = false;
                    do {
                        TokenContext firstContext = tcp.getContexts()[0];
                        TokenCategory[] tokenCategories = firstContext.getTokenCategories();
                        for (int j = 0; j < tokenCategories.length; ++j) {
                            Object catColoring = this.getTokenColoring(tcp, tokenCategories[j], printingSet);
                            if (catColoring == null) continue;
                            String fullName = tcp.getFullTokenName(tokenCategories[j]);
                            SettingsUtil.setColoring(settingsMap, fullName, catColoring, printingSet);
                        }
                        TokenID[] tokenIDs = firstContext.getTokenIDs();
                        for (int j = 0; j < tokenIDs.length; ++j) {
                            Object tokenColoring = this.getTokenColoring(tcp, (TokenCategory)tokenIDs[j], printingSet);
                            if (tokenColoring == null) continue;
                            String fullName = tcp.getFullTokenName((TokenCategory)tokenIDs[j]);
                            SettingsUtil.setColoring(settingsMap, fullName, tokenColoring, printingSet);
                        }
                    } while (printingSet = !printingSet);
                }
            }
        }

        public abstract Object getTokenColoring(TokenContextPath var1, TokenCategory var2, boolean var3);
    }

    public static class TokenColoringEvaluator
    implements Settings.Evaluator,
    Serializable {
        private String parentFullTokenIDName;
        private Coloring coloring;
        private boolean printingSet;

        public TokenColoringEvaluator(TokenContextPath tokenContextPath, TokenCategory tokenIDOrCategory, Coloring coloring, boolean printingSet) {
            this(tokenContextPath.getParent().getFullTokenName(tokenIDOrCategory), coloring, printingSet);
        }

        public TokenColoringEvaluator(String parentFullTokenIDName, Coloring coloring, boolean printingSet) {
            this.parentFullTokenIDName = parentFullTokenIDName;
            this.coloring = coloring;
            this.printingSet = printingSet;
        }

        @Override
        public Object getValue(Class kitClass, String settingName) {
            Coloring ret = SettingsUtil.getColoring(BaseKit.class, this.parentFullTokenIDName, this.printingSet);
            if (this.coloring != null && ret != null) {
                ret = this.coloring.apply(ret);
            }
            return ret;
        }
    }

    public static class ForeColorPrintColoringEvaluator
    extends PrintColoringEvaluator {
        private Color foreColor;

        public ForeColorPrintColoringEvaluator(Color foreColor) {
            this.foreColor = foreColor;
        }

        @Override
        protected Coloring getPrintColoring(Class kitClass, String coloringName, Coloring componentColoring) {
            return Coloring.changeForeColor((Coloring)super.getPrintColoring(kitClass, coloringName, componentColoring), (Color)this.foreColor);
        }
    }

    public static class FontStylePrintColoringEvaluator
    extends PrintColoringEvaluator {
        private int fontStyle;

        public FontStylePrintColoringEvaluator(int fontStyle) {
            this.fontStyle = fontStyle;
        }

        @Override
        protected Coloring getPrintColoring(Class kitClass, String coloringName, Coloring componentColoring) {
            Coloring printColoring = super.getPrintColoring(kitClass, coloringName, componentColoring);
            Font f = printColoring.getFont();
            if (f != null) {
                printColoring = Coloring.changeFont((Coloring)printColoring, (Font)f.deriveFont(this.fontStyle));
            }
            return printColoring;
        }
    }

    public static class PrintColoringEvaluator
    implements Settings.Evaluator {
        protected Coloring getPrintColoring(Class kitClass, String coloringName, Coloring componentColoring) {
            Coloring printColoring = componentColoring;
            if (printColoring != null) {
                Font f;
                float pfh;
                if (printColoring.getBackColor() != null) {
                    printColoring = Coloring.changeBackColor((Coloring)printColoring, (Color)Color.white);
                }
                if (printColoring.getForeColor() != null) {
                    printColoring = Coloring.changeForeColor((Coloring)printColoring, (Color)Color.black);
                }
                if ((pfh = this.getPrintFontSize()) >= 0.0f && (f = printColoring.getFont()) != null) {
                    printColoring = Coloring.changeFont((Coloring)printColoring, (Font)f.deriveFont(pfh));
                }
            }
            return printColoring;
        }

        protected float getPrintFontSize() {
            return 10.0f;
        }

        @Override
        public Object getValue(Class kitClass, String settingName) {
            if (settingName.endsWith("-print-coloring")) {
                String coloringName = settingName.substring(0, settingName.length() - "-print-coloring".length());
                Coloring c = SettingsUtil.getColoring(kitClass, coloringName, false);
                return this.getPrintColoring(kitClass, coloringName, c);
            }
            return null;
        }
    }
}

