/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.commandLine.command;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ResourceBundle;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.commit.CommitCommand;
import org.netbeans.lib.cvsclient.commandLine.GetOpt;
import org.netbeans.lib.cvsclient.commandLine.command.AbstractCommandProvider;

public class commit
extends AbstractCommandProvider {
    public String[] getSynonyms() {
        return new String[]{"ci", "com", "put"};
    }

    private static String getEditorProcess(String editor) {
        if (editor == null) {
            editor = System.getProperty("os.name").startsWith("Windows") ? "notepad.exe" : null;
            editor = System.getProperty("cvs.editor", editor);
        }
        return editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createTempFile(File[] args, File tmpDir) throws IOException {
        File template = null;
        BufferedReader templateReader = null;
        BufferedWriter writer = null;
        try {
            File tempFile = File.createTempFile("cvsTemplate", "txt", tmpDir);
            writer = new BufferedWriter(new FileWriter(tempFile));
            if (args != null && args.length > 0 && (template = new File(args[0].getParentFile(), "CVS" + File.separator + "Template")).exists()) {
                templateReader = new BufferedReader(new FileReader(template));
                String line = null;
                while ((line = templateReader.readLine()) != null) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            writer.write("CVS: ----------------------------------------------------------------------");
            writer.newLine();
            writer.write("CVS: Enter Log.  Lines beginning with `CVS:' are removed automatically");
            writer.newLine();
            writer.write("CVS: ");
            writer.newLine();
            writer.write("CVS: Committing in .");
            writer.newLine();
            writer.write("CVS: ");
            writer.newLine();
            writer.write("CVS: Modified Files:");
            writer.newLine();
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    writer.write("CVS:  " + args[i].getPath());
                }
            }
            writer.write("CVS: ----------------------------------------------------------------------");
            writer.newLine();
            File file = tempFile;
            return file;
        }
        finally {
            if (templateReader != null) {
                templateReader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createMessage(File[] args, GlobalOptions gopt) {
        File temp = null;
        BufferedReader reader = null;
        try {
            String line;
            temp = commit.createTempFile(args, gopt.getTempDir());
            String editorProcess = commit.getEditorProcess(gopt.getEditor());
            if (editorProcess == null) {
                String string = null;
                return string;
            }
            Process proc = Runtime.getRuntime().exec(new String[]{editorProcess, temp.getPath()});
            int returnCode = -1;
            try {
                returnCode = proc.waitFor();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (returnCode != 0) {
                String e = null;
                return e;
            }
            reader = new BufferedReader(new FileReader(temp));
            StringBuffer message = new StringBuffer((int)temp.length());
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("CVS:")) continue;
                message.append(line);
                message.append('\n');
            }
            String string = message.toString();
            return string;
        }
        catch (IOException e) {
            System.err.println("Error: " + e);
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (temp != null) {
                    temp.delete();
                }
            }
            catch (Exception e) {
                System.err.println("Fatal error: " + e);
                e.printStackTrace();
            }
        }
    }

    public Command createCommand(String[] args, int index, GlobalOptions gopt, String workDir) {
        CommitCommand command = new CommitCommand();
        command.setBuilder(null);
        String getOptString = command.getOptString();
        GetOpt go = new GetOpt(args, getOptString);
        int ch = -1;
        go.optIndexSet(index);
        boolean usagePrint = false;
        while (true) {
            ch = go.getopt();
            if (ch == -1) break;
            boolean ok = command.setCVSCommand((char)ch, go.optArgGet());
            if (ok) continue;
            usagePrint = true;
        }
        if (usagePrint) {
            throw new IllegalArgumentException(this.getUsage());
        }
        int fileArgsIndex = go.optIndexGet();
        File[] fileArgs = null;
        if (fileArgsIndex < args.length) {
            fileArgs = new File[args.length - fileArgsIndex];
            if (workDir == null) {
                workDir = System.getProperty("user.dir");
            }
            File workingDir = new File(workDir);
            for (int i = fileArgsIndex; i < args.length; ++i) {
                fileArgs[i - fileArgsIndex] = new File(workingDir, args[i]);
            }
            command.setFiles(fileArgs);
        }
        if (command.getMessage() == null && command.getLogMessageFromFile() == null) {
            String message = commit.createMessage(fileArgs, gopt);
            if (message == null) {
                throw new IllegalArgumentException(ResourceBundle.getBundle(commit.class.getPackage().getName() + ".Bundle").getString("commit.messageNotSpecified"));
            }
            command.setMessage(message);
        }
        return command;
    }
}

