/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class CustomizerSupport {
    private static final String CLASSPATH = "classpath";
    private static final String SOURCES = "src";
    private static final String JAVADOC = "javadoc";

    private CustomizerSupport() {
    }

    public static Component createClassesCustomizer(PathModel pathModel) {
        if (pathModel == null) {
            throw new NullPointerException();
        }
        return new PathView(pathModel, CLASSPATH, null);
    }

    public static Component createSourcesCustomizer(PathModel pathModel, File file) {
        if (pathModel == null) {
            throw new NullPointerException();
        }
        return new PathView(pathModel, SOURCES, file);
    }

    public static Component createJavadocCustomizer(PathModel pathModel, File file) {
        if (pathModel == null) {
            throw new NullPointerException();
        }
        return new PathView(pathModel, JAVADOC, file);
    }

    public static String buildPath(List<URL> list) {
        String string = System.getProperty("path.separator");
        StringBuffer stringBuffer = new StringBuffer(list.size() * 16);
        Iterator<URL> iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(CustomizerSupport.urlToString(iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static List<URL> tokenizePath(String string) {
        try {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":;", true);
            char c = '\u0000';
            int n = 0;
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                char c2;
                String string2 = stringTokenizer.nextToken();
                if (string2.length() == 0) continue;
                if (string2.length() == 1 && ((c2 = string2.charAt(0)) == ':' || c2 == ';')) {
                    n = c2;
                    ++n2;
                    continue;
                }
                if (c != '\u0000') {
                    if (n == 58 && n2 == 1 && (string2.charAt(0) == '\\' || string2.charAt(0) == '/')) {
                        string2 = "" + c + ':' + string2;
                    } else {
                        arrayList.add(CustomizerSupport.fileToUrl(new File(Character.toString(c))));
                    }
                    c = '\u0000';
                }
                n2 = 0;
                if (string2.length() == 1 && ((c2 = string2.charAt(0)) >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
                    c = c2;
                    continue;
                }
                arrayList.add(CustomizerSupport.fileToUrl(new File(string2)));
            }
            if (c != '\u0000') {
                arrayList.add(CustomizerSupport.fileToUrl(new File(Character.toString(c))));
            }
            return arrayList;
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return new ArrayList<URL>();
        }
    }

    private static URL fileToUrl(File file) throws MalformedURLException {
        URL uRL = file.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)uRL)) {
            uRL = FileUtil.getArchiveRoot((URL)uRL);
        }
        return uRL;
    }

    private static String urlToString(URL uRL) {
        Serializable serializable;
        if ("jar".equals(uRL.getProtocol())) {
            serializable = FileUtil.getArchiveFile((URL)uRL);
            if (FileUtil.getArchiveRoot((URL)serializable).equals(uRL)) {
                uRL = serializable;
            } else {
                return uRL.toExternalForm();
            }
        }
        if ("file".equals(uRL.getProtocol())) {
            serializable = new File(URI.create(uRL.toExternalForm()));
            return ((File)serializable).getAbsolutePath();
        }
        return uRL.toExternalForm();
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String string, String[] stringArray) {
            this.description = string;
            this.extensions = Arrays.asList(stringArray);
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            int n = string.lastIndexOf(46);
            if (n <= 0 || n == string.length() - 1) {
                return false;
            }
            String string2 = string.substring(n + 1).toUpperCase();
            return this.extensions.contains(string2);
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    private static class PathView
    extends JPanel {
        private JList resources;
        private JButton addButton;
        private JButton addURLButton;
        private JButton removeButton;
        private JButton moveUpButton;
        private JButton moveDownButton;
        private File currentDir;
        private String type;

        public PathView(PathModel pathModel, String string, File file) {
            this.type = string;
            this.currentDir = file;
            this.initComponents(pathModel);
        }

        private void initComponents(PathModel pathModel) {
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel();
            String string = null;
            String string2 = null;
            String string3 = null;
            if (this.type.equals(CustomizerSupport.CLASSPATH)) {
                string = "TXT_Classes";
                string2 = "MNE_Classes";
                string3 = "AD_Classes";
            } else if (this.type.equals(CustomizerSupport.SOURCES)) {
                string = "TXT_Sources";
                string2 = "MNE_Sources";
                string3 = "AD_Sources";
            } else if (this.type.equals(CustomizerSupport.JAVADOC)) {
                string = "TXT_Javadoc";
                string2 = "MNE_Javadoc";
                string3 = "AD_Javadoc";
            } else {
                assert (false) : "Illegal type of panel";
                return;
            }
            jLabel.setText(NbBundle.getMessage(CustomizerSupport.class, (String)string));
            jLabel.setDisplayedMnemonic(NbBundle.getMessage(CustomizerSupport.class, (String)string2).charAt(0));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(6, 12, 2, 0);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            this.resources = new JList(pathModel);
            jLabel.setLabelFor(this.resources);
            this.resources.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSupport.class, (String)string3));
            this.resources.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    PathView.this.selectionChanged();
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.resources);
            jScrollPane.setPreferredSize(new Dimension(200, 100));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 5;
            gridBagConstraints.insets = new Insets(0, 12, 12, 6);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(jScrollPane, gridBagConstraints);
            this.add(jScrollPane);
            if (this.type == CustomizerSupport.SOURCES || this.type == CustomizerSupport.JAVADOC) {
                char c;
                String string4;
                this.addButton = new JButton();
                if (this.type == CustomizerSupport.SOURCES) {
                    string4 = NbBundle.getMessage(CustomizerSupport.class, (String)"CTL_Add");
                    c = NbBundle.getMessage(CustomizerSupport.class, (String)"MNE_Add").charAt(0);
                    string3 = NbBundle.getMessage(CustomizerSupport.class, (String)"AD_Add");
                } else {
                    string4 = NbBundle.getMessage(CustomizerSupport.class, (String)"CTL_AddZip");
                    c = NbBundle.getMessage(CustomizerSupport.class, (String)"MNE_AddZip").charAt(0);
                    string3 = NbBundle.getMessage(CustomizerSupport.class, (String)"AD_AddZip");
                }
                this.addButton.setText(string4);
                this.addButton.setMnemonic(c);
                this.addButton.getAccessibleContext().setAccessibleDescription(string3);
                this.addButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PathView.this.addPathElement();
                    }
                });
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = new Insets(0, 6, 0, 6);
                ((GridBagLayout)this.getLayout()).setConstraints(this.addButton, gridBagConstraints);
                this.add(this.addButton);
                this.removeButton = new JButton(NbBundle.getMessage(CustomizerSupport.class, (String)"CTL_Remove"));
                this.removeButton.setMnemonic(NbBundle.getMessage(CustomizerSupport.class, (String)"MNE_Remove").charAt(0));
                this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSupport.class, (String)"AD_Remove"));
                this.removeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PathView.this.removePathElement();
                    }
                });
                this.removeButton.setEnabled(false);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = new Insets(12, 6, 0, 6);
                ((GridBagLayout)this.getLayout()).setConstraints(this.removeButton, gridBagConstraints);
                this.add(this.removeButton);
                this.moveUpButton = new JButton(NbBundle.getMessage(CustomizerSupport.class, (String)"CTL_Up"));
                this.moveUpButton.setMnemonic(NbBundle.getMessage(CustomizerSupport.class, (String)"MNE_Up").charAt(0));
                this.moveUpButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSupport.class, (String)"AD_Up"));
                this.moveUpButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PathView.this.moveUpPathElement();
                    }
                });
                this.moveUpButton.setEnabled(false);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 4;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = new Insets(12, 6, 0, 6);
                ((GridBagLayout)this.getLayout()).setConstraints(this.moveUpButton, gridBagConstraints);
                this.add(this.moveUpButton);
                this.moveDownButton = new JButton(NbBundle.getMessage(CustomizerSupport.class, (String)"CTL_Down"));
                this.moveDownButton.setMnemonic(NbBundle.getMessage(CustomizerSupport.class, (String)"MNE_Down").charAt(0));
                this.moveDownButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSupport.class, (String)"AD_Down"));
                this.moveDownButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PathView.this.moveDownPathElement();
                    }
                });
                this.moveDownButton.setEnabled(false);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 5;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = new Insets(5, 6, 6, 6);
                ((GridBagLayout)this.getLayout()).setConstraints(this.moveDownButton, gridBagConstraints);
                this.add(this.moveDownButton);
            }
        }

        private void addPathElement() {
            JFileChooser jFileChooser = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
            jFileChooser.setMultiSelectionEnabled(true);
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (CustomizerSupport.SOURCES.equals(this.type)) {
                string = NbBundle.getMessage(CustomizerSupport.class, (String)"TXT_OpenSources");
                string2 = NbBundle.getMessage(CustomizerSupport.class, (String)"TXT_Sources");
                string3 = NbBundle.getMessage(CustomizerSupport.class, (String)"TXT_OpenSources");
                string4 = NbBundle.getMessage(CustomizerSupport.class, (String)"MNE_OpenSources");
            } else if (CustomizerSupport.JAVADOC.equals(this.type)) {
                string = NbBundle.getMessage(CustomizerSupport.class, (String)"TXT_OpenJavadoc");
                string2 = NbBundle.getMessage(CustomizerSupport.class, (String)"TXT_Javadoc");
                string3 = NbBundle.getMessage(CustomizerSupport.class, (String)"TXT_OpenJavadoc");
                string4 = NbBundle.getMessage(CustomizerSupport.class, (String)"MNE_OpenJavadoc");
            } else {
                throw new IllegalStateException("Can't add element for classpath");
            }
            jFileChooser.setDialogTitle(string);
            jFileChooser.setApproveButtonText(string3);
            jFileChooser.setApproveButtonMnemonic(string4.charAt(0));
            jFileChooser.setFileSelectionMode(2);
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setFileFilter(new SimpleFileFilter(string2, new String[]{"ZIP", "JAR"}));
            if (this.currentDir != null && this.currentDir.exists()) {
                jFileChooser.setCurrentDirectory(this.currentDir);
            }
            if (jFileChooser.showOpenDialog(this) == 0) {
                Object object;
                int n;
                File[] fileArray = jFileChooser.getSelectedFiles();
                PathModel pathModel = (PathModel)this.resources.getModel();
                boolean bl = false;
                int n2 = this.resources.getModel().getSize();
                for (n = 0; n < fileArray.length; ++n) {
                    File file;
                    object = fileArray[n];
                    if (!((File)object).exists() && (file = ((File)object).getParentFile()) != null && ((File)object).getName().equals(file.getName()) && file.exists()) {
                        object = file;
                    }
                    bl |= !pathModel.addPath((File)object);
                }
                if (bl) {
                    new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerSupport.class, (String)"TXT_CanNotAddResolve"), 0);
                }
                if (n2 <= (n = this.resources.getModel().getSize() - 1)) {
                    object = new int[n - n2 + 1];
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        object[i] = n2 + i;
                    }
                    this.resources.setSelectedIndices((int[])object);
                }
                this.currentDir = FileUtil.normalizeFile((File)jFileChooser.getCurrentDirectory());
            }
        }

        private void removePathElement() {
            int[] nArray = this.resources.getSelectedIndices();
            if (nArray.length == 0) {
                return;
            }
            PathModel pathModel = (PathModel)this.resources.getModel();
            pathModel.removePath(nArray);
            if (nArray[nArray.length - 1] - nArray.length + 1 < this.resources.getModel().getSize()) {
                this.resources.setSelectedIndex(nArray[nArray.length - 1] - nArray.length + 1);
            } else if (nArray[0] > 0) {
                this.resources.setSelectedIndex(nArray[0] - 1);
            }
        }

        private void moveDownPathElement() {
            int[] nArray = this.resources.getSelectedIndices();
            if (nArray.length == 0) {
                return;
            }
            PathModel pathModel = (PathModel)this.resources.getModel();
            pathModel.moveDownPath(nArray);
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = nArray[i] + 1;
            }
            this.resources.setSelectedIndices(nArray);
        }

        private void moveUpPathElement() {
            int[] nArray = this.resources.getSelectedIndices();
            if (nArray.length == 0) {
                return;
            }
            PathModel pathModel = (PathModel)this.resources.getModel();
            pathModel.moveUpPath(nArray);
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = nArray[i] - 1;
            }
            this.resources.setSelectedIndices(nArray);
        }

        private void selectionChanged() {
            if (this.type == CustomizerSupport.CLASSPATH) {
                return;
            }
            int[] nArray = this.resources.getSelectedIndices();
            this.removeButton.setEnabled(nArray.length > 0);
            this.moveUpButton.setEnabled(nArray.length > 0 && nArray[0] > 0);
            this.moveDownButton.setEnabled(nArray.length > 0 && nArray[nArray.length - 1] < this.resources.getModel().getSize() - 1);
        }
    }

    public static final class PathModel
    extends AbstractListModel {
        private final List<URL> data;

        public PathModel(List<URL> list) {
            if (list == null) {
                throw new NullPointerException("The data attribute must not be null.");
            }
            this.data = list;
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public Object getElementAt(int n) {
            Serializable serializable;
            URL uRL = this.data.get(n);
            if ("jar".equals(uRL.getProtocol())) {
                serializable = FileUtil.getArchiveFile((URL)uRL);
                if (FileUtil.getArchiveRoot((URL)serializable).equals(uRL)) {
                    uRL = serializable;
                } else {
                    return uRL.toExternalForm();
                }
            }
            if ("file".equals(uRL.getProtocol())) {
                serializable = new File(URI.create(uRL.toExternalForm()));
                return ((File)serializable).getAbsolutePath();
            }
            return uRL.toExternalForm();
        }

        public void removePath(int[] nArray) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                this.data.remove(nArray[i]);
            }
            this.fireIntervalRemoved(this, nArray[0], nArray[nArray.length - 1]);
        }

        public void moveUpPath(int[] nArray) {
            for (int i = 0; i < nArray.length; ++i) {
                URL uRL = this.data.get(nArray[i]);
                URL uRL2 = this.data.set(nArray[i] - 1, uRL);
                this.data.set(nArray[i], uRL2);
            }
            this.fireContentsChanged(this, nArray[0] - 1, nArray[nArray.length - 1]);
        }

        public void moveDownPath(int[] nArray) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                URL uRL = this.data.get(nArray[i]);
                URL uRL2 = this.data.set(nArray[i] + 1, uRL);
                this.data.set(nArray[i], uRL2);
            }
            this.fireContentsChanged(this, nArray[0], nArray[nArray.length - 1] + 1);
        }

        public boolean addPath(File file) {
            try {
                URL uRL = file.toURI().toURL();
                return this.addPath(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }

        public boolean addPath(URL uRL) {
            if (FileUtil.isArchiveFile((URL)uRL)) {
                uRL = FileUtil.getArchiveRoot((URL)uRL);
            } else if (!uRL.toExternalForm().endsWith("/")) {
                try {
                    uRL = new URL(uRL.toExternalForm() + "/");
                }
                catch (MalformedURLException malformedURLException) {
                    Logger.getLogger("global").log(Level.INFO, null, malformedURLException);
                }
            }
            int n = this.data.size();
            this.data.add(uRL);
            this.fireIntervalAdded(this, n, n);
            return true;
        }

        public List<URL> getData() {
            return this.data;
        }
    }
}

