/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wizards.checkoutstep;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.ui.browser.RepositoryPaths;
import org.netbeans.modules.subversion.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.ui.wizards.CheckoutWizard;
import org.netbeans.modules.subversion.ui.wizards.checkoutstep.CheckoutPanel;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class CheckoutStep
extends AbstractStep
implements ActionListener,
DocumentListener,
FocusListener,
ItemListener {
    public static final String CHECKOUT_DIRECTORY = "checkoutStep.checkoutDirectory";
    private CheckoutPanel workdirPanel;
    private RepositoryPaths repositoryPaths;

    @Override
    public HelpCtx getHelp() {
        return new HelpCtx(CheckoutStep.class);
    }

    @Override
    protected JComponent createComponent() {
        if (this.workdirPanel == null) {
            this.workdirPanel = new CheckoutPanel();
            this.workdirPanel.browseWorkdirButton.addActionListener(this);
            this.workdirPanel.scanForProjectsCheckBox.addItemListener(this);
            this.workdirPanel.atWorkingDirLevelCheckBox.addItemListener(this);
            this.workdirPanel.workdirTextField.setText(this.defaultWorkingDirectory().getPath());
            this.workdirPanel.workdirTextField.getDocument().addDocumentListener(this);
            this.workdirPanel.workdirTextField.addFocusListener(this);
            this.workdirPanel.repositoryPathTextField.getDocument().addDocumentListener(this);
            this.workdirPanel.repositoryPathTextField.addFocusListener(this);
            this.workdirPanel.revisionTextField.getDocument().addDocumentListener(this);
            this.workdirPanel.revisionTextField.addFocusListener(this);
        }
        this.validateUserInput(true);
        return this.workdirPanel;
    }

    public void setup(RepositoryFile repositoryFile) {
        if (this.repositoryPaths == null) {
            this.repositoryPaths = new RepositoryPaths(repositoryFile, this.workdirPanel.repositoryPathTextField, this.workdirPanel.browseRepositoryButton, this.workdirPanel.revisionTextField, this.workdirPanel.searchRevisionButton, this.workdirPanel.browseRevisionButton);
            String browserPurposeMessage = NbBundle.getMessage(CheckoutStep.class, (String)"LBL_BrowserMessage");
            int browserMode = 9;
            this.repositoryPaths.setupBehavior(browserPurposeMessage, browserMode, "org.netbeans.modules.subversion.ui.browser.checkout", "org.netbeans.modules.subversion.ui.search.checkout");
        } else {
            this.repositoryPaths.setRepositoryFile(repositoryFile);
        }
        this.workdirPanel.repositoryPathTextField.setText(repositoryFile.getPath());
        this.refreshWorkingCopy(new RepositoryFile[]{repositoryFile});
        if (!repositoryFile.getRevision().equals((Object)SVNRevision.HEAD)) {
            this.workdirPanel.revisionTextField.setText(repositoryFile.getRevision().toString());
        } else {
            this.workdirPanel.revisionTextField.setText("");
        }
        this.workdirPanel.scanForProjectsCheckBox.setSelected(SvnModuleConfig.getDefault().getShowCheckoutCompleted());
    }

    @Override
    protected void validateBeforeNext() {
        boolean done;
        String text;
        File file;
        if (this.validateUserInput(true) && !(file = new File(text = this.workdirPanel.workdirTextField.getText())).exists() && !(done = file.mkdirs())) {
            this.invalid(new AbstractStep.WizardMessage(NbBundle.getMessage(CheckoutWizard.class, (String)"BK2013") + file.getPath(), false));
        }
    }

    private boolean validateUserInput(boolean full) {
        String text;
        if (this.repositoryPaths != null) {
            try {
                this.repositoryPaths.getRepositoryFiles();
            }
            catch (NumberFormatException ex) {
                this.invalid(new AbstractStep.WizardMessage(NbBundle.getMessage(CheckoutStep.class, (String)"BK2018"), false));
                return false;
            }
            catch (MalformedURLException ex) {
                this.invalid(new AbstractStep.WizardMessage(NbBundle.getMessage(CheckoutStep.class, (String)"BK2015"), true));
                return false;
            }
        }
        if ((text = this.workdirPanel.workdirTextField.getText()) == null || text.length() == 0) {
            this.invalid(new AbstractStep.WizardMessage(NbBundle.getMessage(CheckoutStep.class, (String)"BK2014"), true));
            return false;
        }
        AbstractStep.WizardMessage errorMessage = null;
        if (full) {
            File file = new File(text);
            if (!file.exists()) {
                for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
                    if (!parent.exists()) continue;
                    if (!parent.canWrite()) {
                        errorMessage = new AbstractStep.WizardMessage(NbBundle.getMessage(CheckoutStep.class, (String)"BK2016") + parent.getPath(), false);
                    }
                    break;
                }
            } else if (file.isFile()) {
                errorMessage = new AbstractStep.WizardMessage(NbBundle.getMessage(CheckoutStep.class, (String)"BK2017"), false);
            }
        }
        if (errorMessage == null) {
            this.valid();
        } else {
            this.invalid(errorMessage);
        }
        return errorMessage == null;
    }

    private void onBrowseWorkdir() {
        File defaultDir = this.defaultWorkingDirectory();
        AccessibleJFileChooser fileChooser = new AccessibleJFileChooser(NbBundle.getMessage(CheckoutStep.class, (String)"ACSD_BrowseFolder"), defaultDir);
        fileChooser.setDialogTitle(NbBundle.getMessage(CheckoutStep.class, (String)"BK0010"));
        fileChooser.setMultiSelectionEnabled(false);
        FileFilter[] old = fileChooser.getChoosableFileFilters();
        for (int i = 0; i < old.length; ++i) {
            FileFilter fileFilter = old[i];
            fileChooser.removeChoosableFileFilter(fileFilter);
        }
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(CheckoutStep.class, (String)"BK0008");
            }
        });
        fileChooser.setFileSelectionMode(1);
        fileChooser.showDialog(this.workdirPanel, NbBundle.getMessage(CheckoutStep.class, (String)"BK0009"));
        File f = fileChooser.getSelectedFile();
        if (f != null) {
            this.workdirPanel.workdirTextField.setText(f.getAbsolutePath());
        }
    }

    private File defaultWorkingDirectory() {
        File projectFolder;
        String coDir;
        File defaultDir = null;
        String current = this.workdirPanel.workdirTextField.getText();
        if (current != null && !current.trim().equals("")) {
            File currentFile;
            for (currentFile = new File(current); currentFile != null && !currentFile.exists(); currentFile = currentFile.getParentFile()) {
            }
            if (currentFile != null) {
                defaultDir = currentFile.isFile() ? currentFile.getParentFile() : currentFile;
            }
        }
        if (defaultDir == null && (coDir = SvnModuleConfig.getDefault().getPreferences().get(CHECKOUT_DIRECTORY, null)) != null) {
            defaultDir = new File(coDir);
        }
        if (defaultDir == null && (projectFolder = ProjectChooser.getProjectsFolder()).exists() && projectFolder.isDirectory()) {
            defaultDir = projectFolder;
        }
        if (defaultDir == null) {
            defaultDir = new File(System.getProperty("user.home"));
        }
        return defaultDir;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validateUserInput(false);
        this.repositoryFoldersChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validateUserInput(false);
        this.repositoryFoldersChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.validateUserInput(true);
        this.repositoryFoldersChanged();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (e.getSource() == this.workdirPanel.browseWorkdirButton);
        this.onBrowseWorkdir();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.workdirPanel.scanForProjectsCheckBox) {
            SvnModuleConfig.getDefault().setShowCheckoutCompleted(this.workdirPanel.scanForProjectsCheckBox.isSelected());
        } else if (source == this.workdirPanel.atWorkingDirLevelCheckBox) {
            RepositoryFile[] repositoryFiles = null;
            if (this.getRepositoryPath().length() != 0) {
                try {
                    repositoryFiles = this.repositoryPaths.getRepositoryFiles();
                }
                catch (NumberFormatException ex) {
                }
                catch (MalformedURLException ex) {
                    // empty catch block
                }
            }
            this.refreshWorkingCopy(repositoryFiles);
        }
    }

    public File getWorkdir() {
        return new File(this.workdirPanel.workdirTextField.getText());
    }

    public RepositoryFile[] getRepositoryFiles() {
        try {
            return this.repositoryPaths.getRepositoryFiles(".");
        }
        catch (MalformedURLException ex) {
            Subversion.LOG.log(Level.INFO, null, ex);
            return null;
        }
    }

    public boolean isAtWorkingDirLevel() {
        return this.workdirPanel.atWorkingDirLevelCheckBox.isSelected();
    }

    public boolean isExport() {
        return this.workdirPanel.exportCheckBox.isSelected();
    }

    private void repositoryFoldersChanged() {
        if (this.getRepositoryPath().equals("")) {
            this.resetWorkingDirLevelCheckBox();
            this.refreshWorkingCopy(null);
            return;
        }
        RepositoryFile[] repositoryFiles = null;
        try {
            repositoryFiles = this.repositoryPaths.getRepositoryFiles();
        }
        catch (NumberFormatException ex) {
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        if (repositoryFiles == null || repositoryFiles.length == 0 || repositoryFiles.length > 1) {
            this.resetWorkingDirLevelCheckBox();
            this.refreshWorkingCopy(repositoryFiles);
            return;
        }
        String repositoryFolder = repositoryFiles[0].getFileUrl().getLastPathSegment().trim();
        if (repositoryFolder.equals("") || repositoryFolder.equals(".")) {
            this.resetWorkingDirLevelCheckBox();
            this.refreshWorkingCopy(repositoryFiles);
            return;
        }
        this.workdirPanel.atWorkingDirLevelCheckBox.setText(NbBundle.getMessage(CheckoutStep.class, (String)"CTL_Checkout_CheckoutContentFolder", (Object[])new Object[]{repositoryFolder}));
        this.workdirPanel.atWorkingDirLevelCheckBox.setEnabled(true);
        this.refreshWorkingCopy(repositoryFiles);
    }

    private void resetWorkingDirLevelCheckBox() {
        this.workdirPanel.atWorkingDirLevelCheckBox.setText(NbBundle.getMessage(CheckoutStep.class, (String)"CTL_Checkout_CheckoutContentEmpty"));
        this.workdirPanel.atWorkingDirLevelCheckBox.setEnabled(false);
    }

    private String getRepositoryPath() {
        return this.workdirPanel.repositoryPathTextField.getText().trim();
    }

    private void refreshWorkingCopy(RepositoryFile[] repositoryFiles) {
        String workingCopyPath;
        int filesCount;
        String localFolderPath = CheckoutStep.trimTrailingSlashes(this.workdirPanel.workdirTextField.getText().trim());
        int n = filesCount = repositoryFiles != null ? repositoryFiles.length : 0;
        if (filesCount == 0) {
            workingCopyPath = localFolderPath;
        } else {
            String repositoryFilePath = CheckoutStep.trimSlashes(repositoryFiles[0].getPath());
            if (repositoryFilePath.equals(".")) {
                repositoryFilePath = "";
            }
            if (filesCount == 1 && (this.workdirPanel.atWorkingDirLevelCheckBox.isSelected() || repositoryFilePath.length() == 0)) {
                workingCopyPath = localFolderPath;
            } else {
                String repositoryFolderName = repositoryFiles[0].getName();
                StringBuilder buf = new StringBuilder(localFolderPath.length() + repositoryFolderName.length() + 10);
                buf.append(localFolderPath).append(File.separatorChar).append(repositoryFolderName);
                if (filesCount > 1) {
                    buf.append(", ...");
                }
                workingCopyPath = buf.toString();
            }
        }
        this.workdirPanel.workingCopy.setText(workingCopyPath);
    }

    private static String trimTrailingSlashes(String path) {
        return CheckoutStep.trimSlashes(path, true);
    }

    private static String trimSlashes(String path) {
        return CheckoutStep.trimSlashes(path, false);
    }

    private static String trimSlashes(String path, boolean trailingOnly) {
        int endIndex;
        int startIndex;
        int length = path.length();
        if (length == 0) {
            return path;
        }
        if (!trailingOnly) {
            for (startIndex = 0; startIndex < length && path.charAt(startIndex) == '/'; ++startIndex) {
            }
            if (startIndex == length) {
                return "";
            }
        }
        for (endIndex = length; endIndex != 0 && path.charAt(endIndex - 1) == '/'; --endIndex) {
        }
        if (endIndex == 0) {
            return "";
        }
        return startIndex == 0 && endIndex == length ? path : path.substring(startIndex, endIndex);
    }
}

