/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnClientFactory;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.FileUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class VersionsCache {
    private static VersionsCache instance;

    private VersionsCache() {
    }

    public static synchronized VersionsCache getInstance() {
        if (instance == null) {
            instance = new VersionsCache();
        }
        return instance;
    }

    public File getFileRevision(SVNUrl repoUrl, SVNUrl url, String revision, String fileName) throws IOException {
        return this.getFileRevision(repoUrl, url, revision, revision, fileName);
    }

    public File getFileRevision(SVNUrl repoUrl, SVNUrl url, String revision, String pegRevision, String fileName) throws IOException {
        try {
            SvnClient client = Subversion.getInstance().getClient(repoUrl);
            InputStream in = this.getInputStream(client, url, revision, pegRevision);
            return this.createContent(fileName, in);
        }
        catch (SVNClientException ex) {
            IOException ioex = new IOException("Can not load: " + url + " in revision: " + revision);
            ioex.initCause(ex);
            throw ioex;
        }
    }

    public File getFileRevision(File base, String revision) throws IOException {
        return this.getFileRevision(base, revision, revision);
    }

    public File getFileRevision(File base, String revision, String pegRevision) throws IOException {
        try {
            SvnClientFactory.checkClientAvailable();
        }
        catch (SVNClientException e) {
            return null;
        }
        if ("BASE".equals(revision)) {
            return this.getBaseRevisionFile(base);
        }
        if ("PRISTINE".equals(revision)) {
            String name = base.getName();
            File svnDir = this.getMetadataDir(base.getParentFile());
            if (svnDir != null) {
                File text_base = new File(svnDir, "text-base");
                File pristine = new File(text_base, name + ".svn-base");
                if (pristine.isFile()) {
                    return pristine;
                }
                return null;
            }
            return null;
        }
        if ("LOCAL".equals(revision)) {
            return base;
        }
        SVNRevision svnrevision = SvnUtils.toSvnRevision(revision);
        try {
            InputStream in;
            SvnClient client = Subversion.getInstance().getClient(base);
            FileStatusCache cache = Subversion.getInstance().getStatusCache();
            try {
                SVNUrl url;
                in = (cache.getStatus(base).getStatus() & 0x5DF8) != 0 ? client.getContent(base, svnrevision) : ((url = SvnUtils.getRepositoryUrl(base)) != null ? this.getInputStream(client, url, revision, pegRevision) : new ByteArrayInputStream(NbBundle.getMessage(VersionsCache.class, (String)"MSG_UnknownURL").getBytes()));
            }
            catch (SVNClientException e) {
                if (SvnClientExceptionHandler.isFileNotFoundInRevision(e.getMessage()) || SvnClientExceptionHandler.isPathNotFound(e.getMessage())) {
                    in = new ByteArrayInputStream(new byte[0]);
                }
                throw e;
            }
            return this.createContent(base.getName(), in);
        }
        catch (SVNClientException ex) {
            IOException ioex = new IOException("Can not load: " + base.getAbsolutePath() + " in revision: " + revision);
            ioex.initCause(ex);
            throw ioex;
        }
    }

    File getBaseRevisionFile(File referenceFile) throws IOException {
        try {
            File svnDir = this.getMetadataDir(referenceFile.getParentFile());
            if (svnDir == null) {
                return null;
            }
            File svnBase = new File(svnDir, "text-base/" + referenceFile.getName() + ".svn-base");
            if (!svnBase.exists()) {
                return null;
            }
            File expanded = new File(svnDir, "text-base/" + referenceFile.getName() + ".netbeans-base");
            if (expanded.canRead() && svnBase.isFile() && expanded.lastModified() >= svnBase.lastModified()) {
                return expanded;
            }
            SvnClient client = Subversion.getInstance().getClient(referenceFile);
            InputStream in = client.getContent(referenceFile, SVNRevision.BASE);
            expanded = FileUtil.normalizeFile((File)expanded);
            FileUtils.copyStreamToFile((InputStream)new BufferedInputStream(in), (File)expanded);
            expanded.setLastModified(svnBase.lastModified());
            return expanded;
        }
        catch (SVNClientException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    private InputStream getInputStream(SvnClient client, SVNUrl url, String revision, String pegRevision) throws SVNClientException {
        InputStream in = null;
        try {
            in = client.getContent(url, SvnUtils.toSvnRevision(revision), SvnUtils.toSvnRevision(pegRevision));
        }
        catch (SVNClientException e) {
            if (SvnClientExceptionHandler.isFileNotFoundInRevision(e.getMessage()) || SvnClientExceptionHandler.isPathNotFound(e.getMessage())) {
                in = new ByteArrayInputStream(new byte[0]);
            }
            throw e;
        }
        return in;
    }

    private File createContent(String fileName, InputStream in) throws IOException {
        File tmp = new File(Utils.getTempFolder(), "nb-svn-" + fileName);
        tmp = FileUtil.normalizeFile((File)tmp);
        tmp.deleteOnExit();
        FileUtils.copyStreamToFile((InputStream)new BufferedInputStream(in), (File)tmp);
        return tmp;
    }

    private File getMetadataDir(File dir) {
        File svnDir = new File(dir, SvnUtils.SVN_ADMIN_DIR);
        if (!svnDir.isDirectory()) {
            return null;
        }
        return svnDir;
    }
}

