/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.httpunit.FrameSelector;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpInternalErrorException;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.servletunit.InvocationContext;
import com.meterware.servletunit.InvocationContextFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.xml.sax.SAXException;

public class ServletUnitClient
extends WebClient {
    private InvocationContextFactory _invocationContextFactory;

    public static ServletUnitClient newClient(InvocationContextFactory factory) {
        return new ServletUnitClient(factory);
    }

    public InvocationContext newInvocation(String requestString) throws IOException, MalformedURLException {
        return this.newInvocation(new GetMethodWebRequest(requestString));
    }

    public InvocationContext newInvocation(WebRequest request) throws IOException, MalformedURLException {
        return this.newInvocation(request, FrameSelector.TOP_FRAME);
    }

    InvocationContext newInvocation(WebRequest request, FrameSelector frame) throws IOException, MalformedURLException {
        ByteArrayOutputStream baos = this.getMessageBody(request);
        return this._invocationContextFactory.newInvocation(this, frame, request, this.getHeaderFields(request.getURL()), baos.toByteArray());
    }

    ByteArrayOutputStream getMessageBody(WebRequest request) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeMessageBody(request, baos);
        return baos;
    }

    public WebResponse getResponse(InvocationContext invocation) throws MalformedURLException, IOException, SAXException {
        this.updateMainWindow(invocation.getFrame(), invocation.getServletResponse());
        return this.getFrameContents(invocation.getFrame());
    }

    public HttpSession getSession(boolean create) {
        HttpSession session = this._invocationContextFactory.getSession(this.getCookieValue("JSESSION"), create);
        if (session != null) {
            this.putCookie("JSESSION", session.getId());
        }
        return session;
    }

    protected WebResponse newResponse(WebRequest request, FrameSelector targetFrame) throws MalformedURLException, IOException {
        try {
            InvocationContext invocation = this.newInvocation(request, targetFrame);
            invocation.service();
            return invocation.getServletResponse();
        }
        catch (ServletException e) {
            throw new HttpInternalErrorException(request.getURL(), (Throwable)e);
        }
    }

    private ServletUnitClient(InvocationContextFactory factory) {
        this._invocationContextFactory = factory;
    }
}

