/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.Component;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.SourceRoots;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

public final class NewFileWizardIterator
implements WizardDescriptor.InstantiatingIterator<WizardDescriptor> {
    private static final Logger LOGGER = Logger.getLogger(NewFileWizardIterator.class.getName());
    private static final long serialVersionUID = 2262026971167469147L;
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel<WizardDescriptor>[] wizardPanels;
    private int index;

    public Set<FileObject> instantiate() throws IOException {
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wizard);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)dir);
        DataObject dataTemplate = DataObject.find((FileObject)template);
        DataObject createdFile = dataTemplate.createFromTemplate(dataFolder, Templates.getTargetName((WizardDescriptor)this.wizard), Collections.singletonMap("freeFileExtension", true));
        return Collections.singleton(createdFile.getPrimaryFile());
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)wizard);
        if (targetFolder == null) {
            Project project = Templates.getProject((WizardDescriptor)wizard);
            assert (project instanceof PhpProject);
            PhpProject phpProject = (PhpProject)project;
            FileObject srcDir = ProjectPropertiesSupport.getSourcesDirectory(phpProject);
            if (srcDir != null) {
                targetFolder = srcDir;
                Templates.setTargetFolder((WizardDescriptor)wizard, (FileObject)srcDir);
            }
        }
        this.wizardPanels = this.getPanels();
        String[] beforeSteps = (String[])wizard.getProperty("WizardPanel_contentData");
        int beforeStepLength = beforeSteps.length - 1;
        String[] steps = this.createSteps(beforeSteps);
        for (int i = 0; i < this.wizardPanels.length; ++i) {
            Component c = this.wizardPanels[i].getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i + beforeStepLength - 1));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    private String[] createSteps(String[] beforeSteps) {
        int beforeStepLength = beforeSteps.length - 1;
        String[] res = new String[beforeStepLength + this.wizardPanels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < beforeStepLength ? beforeSteps[i] : this.wizardPanels[i - beforeStepLength].getComponent().getName();
        }
        return res;
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.wizardPanels = null;
    }

    public String name() {
        return "";
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.wizardPanels[this.index];
    }

    public boolean hasNext() {
        return this.index < this.wizardPanels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private WizardDescriptor.Panel<WizardDescriptor>[] getPanels() {
        Project p = Templates.getProject((WizardDescriptor)this.wizard);
        SourceGroup[] groups = PhpProjectUtils.getSourceGroups(p);
        if (groups != null && groups.length == 0) {
            PhpProject project = (PhpProject)p;
            FileObject sources = ProjectPropertiesSupport.getSourcesDirectory(project);
            FileObject tests = ProjectPropertiesSupport.getTestDirectory(project, false);
            FileObject selenium = ProjectPropertiesSupport.getSeleniumDirectory(project, false);
            SourceRoots sourceRoots = project.getSourceRoots();
            SourceRoots testRoots = project.getTestRoots();
            SourceRoots seleniumRoots = project.getSeleniumRoots();
            StringBuilder sb = new StringBuilder(200);
            sb.append("project directory equals sources: ");
            sb.append(project.getProjectDirectory().equals(sources));
            sb.append("; sources (not null, valid): ");
            sb.append(sources != null);
            sb.append(", ");
            sb.append(sources != null && sources.isValid());
            sb.append("; tests (not null, valid): ");
            sb.append(tests != null);
            sb.append(", ");
            sb.append(tests != null && tests.isValid());
            sb.append("; selenium (not null, valid): ");
            sb.append(selenium != null);
            sb.append(", ");
            sb.append(selenium != null && selenium.isValid());
            sb.append("; sourceRoots: ");
            sb.append(Arrays.asList(sourceRoots.getRoots()));
            sb.append("; testRoots: ");
            sb.append(Arrays.asList(testRoots.getRoots()));
            sb.append("; seleniumRoots: ");
            sb.append(Arrays.asList(seleniumRoots.getRoots()));
            LOGGER.log(Level.WARNING, sb.toString(), new IllegalStateException("No source roots found (attach your IDE log to https://netbeans.org/bugzilla/show_bug.cgi?id=180054)"));
            groups = null;
        }
        WizardDescriptor.Panel simpleTargetChooserPanel = Templates.buildSimpleTargetChooser((Project)p, (SourceGroup[])groups).freeFileExtension().create();
        WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{simpleTargetChooserPanel};
        return panels;
    }
}

