/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.modules.form.CustomCodeData;
import org.netbeans.modules.form.CustomCodeView;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.JavaCodeGenerator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.netbeans.modules.form.RADProperty;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CodeCustomizer
implements CustomCodeView.Listener {
    private FormModel formModel;
    private Map<RADComponent, CustomCodeData> changedDataMap = new HashMap<RADComponent, CustomCodeData>();
    private CustomCodeView codeView;
    private RADComponent customizedComponent;

    private CodeCustomizer(FormModel formModel) {
        this.formModel = formModel;
        this.codeView = new CustomCodeView(this);
        this.setupComponentNames();
    }

    public static void show(RADComponent rADComponent) {
        CodeCustomizer codeCustomizer = new CodeCustomizer(rADComponent.getFormModel());
        codeCustomizer.selectComponent(rADComponent);
        codeCustomizer.show();
    }

    private void show() {
        JavaCodeGenerator javaCodeGenerator = (JavaCodeGenerator)FormEditor.getCodeGenerator(this.formModel);
        javaCodeGenerator.regenerateCode();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.codeView, NbBundle.getMessage(CodeCustomizer.class, (String)"TITLE_CodeCustomizer"), true, 2, null, null);
        dialogDescriptor.setHelpCtx(new HelpCtx("gui.codecustomizer"));
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (DialogDescriptor.OK_OPTION.equals(object)) {
            this.retreiveCurrentData();
            this.storeChanges();
        }
    }

    private void setupComponentNames() {
        Collection<RADComponent> collection = this.formModel.getAllComponents();
        RADComponent rADComponent = this.formModel.getTopRADComponent();
        Object[] objectArray = new String[rADComponent != null ? collection.size() - 1 : collection.size()];
        int n = 0;
        for (RADComponent rADComponent2 : collection) {
            if (rADComponent2 == rADComponent) continue;
            objectArray[n++] = rADComponent2.getName();
        }
        Arrays.sort(objectArray, 0, objectArray.length - 1);
        this.codeView.setComponentNames((String[])objectArray);
    }

    private void selectComponent(RADComponent rADComponent) {
        this.customizedComponent = rADComponent;
        CustomCodeData customCodeData = this.changedDataMap.get(rADComponent);
        if (customCodeData == null) {
            customCodeData = JavaCodeGenerator.getCodeData(rADComponent);
            customCodeData.check();
        }
        this.codeView.setCodeData(this.customizedComponent.getName(), customCodeData, this.getSourceFile(), this.getSourcePositions());
    }

    private FileObject getSourceFile() {
        return FormEditor.getFormDataObject(this.formModel).getPrimaryFile();
    }

    private int[] getSourcePositions() {
        SimpleSection simpleSection = FormEditor.getFormDataObject(this.formModel).getFormEditorSupport().getInitComponentSection();
        return new int[]{simpleSection.getText().indexOf(123) + 2 + simpleSection.getStartPosition().getOffset(), simpleSection.getEndPosition().getOffset() + 1};
    }

    private void retreiveCurrentData() {
        if (this.codeView.isChanged()) {
            this.changedDataMap.put(this.customizedComponent, this.codeView.retreiveCodeData());
        }
    }

    private void storeChanges() {
        for (Map.Entry<RADComponent, CustomCodeData> entry : this.changedDataMap.entrySet()) {
            this.storeComponent(entry.getKey(), entry.getValue(), true);
        }
        this.changedDataMap.clear();
    }

    private void storeComponent(RADComponent rADComponent, CustomCodeData customCodeData, boolean bl) {
        CodeCustomizer.storeCodeCategory(rADComponent, customCodeData, CustomCodeData.CodeCategory.CREATE_AND_INIT, bl);
        CodeCustomizer.storeCodeCategory(rADComponent, customCodeData, CustomCodeData.CodeCategory.DECLARATION, bl);
        CodeCustomizer.storeDeclaration(rADComponent, customCodeData.getDeclarationData(), bl);
    }

    private static void storeCodeCategory(RADComponent rADComponent, CustomCodeData customCodeData, CustomCodeData.CodeCategory codeCategory, boolean bl) {
        int n;
        int n2 = customCodeData.getEditableBlockCount(codeCategory);
        for (n = 0; n < n2; ++n) {
            CustomCodeData.EditableBlock editableBlock = customCodeData.getEditableBlock(codeCategory, n);
            for (CustomCodeData.CodeEntry codeEntry : editableBlock.getEntries()) {
                CodeCustomizer.storeCodeEntry(rADComponent, codeEntry, bl);
            }
        }
        n = customCodeData.getGuardedBlockCount(codeCategory);
        for (int i = 0; i < n; ++i) {
            CustomCodeData.GuardedBlock guardedBlock = customCodeData.getGuardedBlock(codeCategory, i);
            if (!guardedBlock.isCustomizable()) continue;
            CodeCustomizer.storeCodeEntry(rADComponent, guardedBlock.getCustomEntry(), bl);
        }
    }

    private static void storeCodeEntry(RADComponent rADComponent, CustomCodeData.CodeEntry codeEntry, boolean bl) {
        boolean bl2;
        FormProperty formProperty = codeEntry.getTargetProperty();
        String string = codeEntry.getCode();
        if (!bl) {
            bl2 = formProperty.isChangeFiring();
            formProperty.setChangeFiring(false);
        } else {
            bl2 = true;
        }
        try {
            if (codeEntry.isPropertyPreInit()) {
                formProperty.setPreCode(string);
            } else if (codeEntry.isPropertyPostInit()) {
                formProperty.setPostCode(string);
            } else if (formProperty instanceof RADProperty) {
                if (string != null) {
                    FormProperty.ValueWithEditor valueWithEditor = new FormProperty.ValueWithEditor(new RADConnectionPropertyEditor.RADConnectionDesignValue(string), new RADConnectionPropertyEditor(formProperty.getValueType()));
                    formProperty.setValue(valueWithEditor);
                } else if (JavaCodeGenerator.isPropertyWithCustomCode(formProperty)) {
                    formProperty.restoreDefaultValue();
                    if (!bl && formProperty.getPreCode() == null && formProperty.getPostCode() == null) {
                        formProperty.setPreCode("\n");
                    }
                }
            } else {
                formProperty.setValue(string != null ? string : "");
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        if (!bl) {
            formProperty.setChangeFiring(bl2);
        }
    }

    private static void storeDeclaration(RADComponent rADComponent, CustomCodeData.VariableDeclaration variableDeclaration, boolean bl) {
        boolean bl2;
        FormProperty formProperty = (FormProperty)rADComponent.getSyntheticProperty("useLocalVariable");
        FormProperty formProperty2 = (FormProperty)rADComponent.getSyntheticProperty("modifiers");
        if (!bl) {
            bl2 = formProperty.isChangeFiring();
            formProperty.setChangeFiring(false);
            formProperty2.setChangeFiring(false);
        } else {
            bl2 = true;
        }
        try {
            formProperty.setValue(variableDeclaration.local);
            int n = variableDeclaration.modifiers;
            if (n < 0) {
                n = (Integer)formProperty2.getValue() & 0xFFFFFFEF | n & 0x10;
            }
            formProperty2.setValue(n);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        if (!bl) {
            formProperty.setChangeFiring(bl2);
            formProperty2.setChangeFiring(bl2);
        }
    }

    @Override
    public void componentExchanged(String string) {
        this.retreiveCurrentData();
        this.selectComponent(this.formModel.findRADComponent(string));
    }

    @Override
    public void renameInvoked() {
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(NbBundle.getMessage(CodeCustomizer.class, (String)"CTL_RenameLabel"), NbBundle.getMessage(CodeCustomizer.class, (String)"CTL_RenameTitle"));
        inputLine.setInputText(this.customizedComponent.getName());
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine))) {
            String string;
            this.retreiveCurrentData();
            CustomCodeData customCodeData = this.changedDataMap.get(this.customizedComponent);
            if (customCodeData != null) {
                string = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(CodeCustomizer.class, (String)"CTL_ApplyChangesLabel"), NbBundle.getMessage(CodeCustomizer.class, (String)"CTL_ApplyChangesTitle"), 2);
                if (!NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)string))) {
                    return;
                }
                this.storeComponent(this.customizedComponent, customCodeData, true);
                this.changedDataMap.remove(this.customizedComponent);
            }
            try {
                string = inputLine.getInputText();
                if (!string.equals("")) {
                    this.customizedComponent.rename(string);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Exceptions.printStackTrace((Throwable)illegalArgumentException);
                return;
            }
            this.setupComponentNames();
            customCodeData = JavaCodeGenerator.getCodeData(this.customizedComponent);
            customCodeData.check();
            this.codeView.setCodeData(this.customizedComponent.getName(), customCodeData, this.getSourceFile(), this.getSourcePositions());
        }
    }

    @Override
    public void declarationChanged() {
        CustomCodeData customCodeData = JavaCodeGenerator.getCodeData(this.customizedComponent);
        this.retreiveCurrentData();
        CustomCodeData customCodeData2 = this.changedDataMap.get(this.customizedComponent);
        this.storeComponent(this.customizedComponent, customCodeData2, false);
        CustomCodeData customCodeData3 = JavaCodeGenerator.getCodeData(this.customizedComponent);
        customCodeData3.check();
        this.storeComponent(this.customizedComponent, customCodeData, false);
        this.codeView.setCodeData(this.customizedComponent.getName(), customCodeData3, this.getSourceFile(), this.getSourcePositions());
    }
}

