/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.j2ee.ejbverification.EJBProblemFinder;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class EJBVerificationTaskProvider
extends FileTaskScanner {
    private static final String TASKLIST_ERROR = "nb-tasklist-error";
    private static final String TASKLIST_WARNING = "nb-tasklist-warning";

    public EJBVerificationTaskProvider() {
        super(NbBundle.getMessage(EJBVerificationTaskProvider.class, (String)"LBL_TaskList_DisplayName"), NbBundle.getMessage(EJBVerificationTaskProvider.class, (String)"LBL_TaskList_Desc"), null);
    }

    public List<? extends org.netbeans.spi.tasklist.Task> scan(FileObject fileObject) {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        EJBProblemFinder.ProblemFinderCompControl problemFinderCompControl = new EJBProblemFinder.ProblemFinderCompControl(fileObject);
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask((Task)problemFinderCompControl, true);
            }
            catch (IOException iOException) {
                EJBProblemFinder.LOG.log(Level.WARNING, iOException.getMessage(), iOException);
            }
        }
        ArrayList<org.netbeans.spi.tasklist.Task> arrayList = new ArrayList<org.netbeans.spi.tasklist.Task>();
        for (ErrorDescription errorDescription : problemFinderCompControl.getProblemsFound()) {
            try {
                org.netbeans.spi.tasklist.Task task = org.netbeans.spi.tasklist.Task.create((FileObject)fileObject, (String)EJBVerificationTaskProvider.severityToTaskListString(errorDescription.getSeverity()), (String)errorDescription.getDescription(), (int)errorDescription.getRange().getBegin().getLine());
                arrayList.add(task);
            }
            catch (IOException iOException) {
                EJBProblemFinder.LOG.log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
        return arrayList;
    }

    public void attach(FileTaskScanner.Callback callback) {
    }

    private static String severityToTaskListString(Severity severity) {
        if (severity == Severity.ERROR) {
            return TASKLIST_ERROR;
        }
        return TASKLIST_WARNING;
    }
}

