/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.ui.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.groovy.grailsproject.ui.wizards.NewGrailsProjectWizardIterator;
import org.netbeans.modules.groovy.grailsproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.groovy.grailsproject.ui.wizards.SettingsPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class PanelProjectLocationVisual
extends SettingsPanel
implements DocumentListener {
    private PanelConfigureProject panel;
    private JButton browseLocationJButton;
    private JLabel projectFolderLabel;
    private JTextField projectFolderTextField;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;

    @Override
    boolean valid(WizardDescriptor wizardDescriptor) {
        if (this.projectNameTextField.getText().trim().length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(NewGrailsProjectWizardIterator.class, (String)"GetProjectLocationPanel.EmptyProjectName"));
            return false;
        }
        if (!new File(this.projectLocationTextField.getText().trim()).isDirectory()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(NewGrailsProjectWizardIterator.class, (String)"GetProjectLocationPanel.LocationNotDirectory"));
            return false;
        }
        if (new File(this.projectFolderTextField.getText().trim()).exists()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(NewGrailsProjectWizardIterator.class, (String)"GetProjectLocationPanel.FileAlreadyExists"));
            return false;
        }
        return true;
    }

    @Override
    void read(WizardDescriptor wizardDescriptor) {
        File file = (File)wizardDescriptor.getProperty("projectFolder");
        file = file == null || file.getParentFile() == null || !file.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : file.getParentFile();
        Integer n = (Integer)wizardDescriptor.getProperty("WizardPanel_GrailsProjectCounter");
        String string = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"TXT_GrailsApplication");
        int n2 = n;
        String string2 = (String)wizardDescriptor.getProperty("name");
        if (string2 == null) {
            while ((string2 = this.validFreeProjectName(file, string, n2)) == null) {
                ++n2;
            }
        }
        this.projectLocationTextField.setText(file.getAbsolutePath());
        this.projectFolderTextField.setText(file.getAbsolutePath() + File.separatorChar + this.projectNameTextField.getText().trim());
        this.projectNameTextField.setText(string2);
    }

    @Override
    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
    }

    @Override
    void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("projectFolder", (Object)new File(this.projectFolderTextField.getText().trim()));
        wizardDescriptor.putProperty("projectName", (Object)this.projectNameTextField.getText().trim());
    }

    public PanelProjectLocationVisual(PanelConfigureProject panelConfigureProject) {
        this.panel = panelConfigureProject;
        this.initComponents();
        this.projectLocationTextField.getDocument().addDocumentListener(this);
        this.projectNameTextField.getDocument().addDocumentListener(this);
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectLocationLabel = new JLabel();
        this.projectFolderLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationTextField = new JTextField();
        this.projectFolderTextField = new JTextField();
        this.browseLocationJButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.projectNameLabel.setDisplayedMnemonic('N');
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"PanelProjectLocationVisual.projectNameLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.projectNameLabel, gridBagConstraints);
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.projectNameLabel.AccessibleContext.accessibleDescription"));
        this.projectLocationLabel.setDisplayedMnemonic('L');
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"PanelProjectLocationVisual.projectLocationLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.projectLocationLabel, gridBagConstraints);
        this.projectLocationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.projectLocationLabel.AccessibleContext.accessibleDescription"));
        this.projectFolderLabel.setDisplayedMnemonic('F');
        this.projectFolderLabel.setLabelFor(this.projectFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectFolderLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"PanelProjectLocationVisual.projectFolderLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.projectFolderLabel, gridBagConstraints);
        this.projectFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.projectFolderLabel.AccessibleContext.accessibleDescription"));
        this.projectNameTextField.setText(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"PanelProjectLocationVisual.projectNameTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.add((Component)this.projectNameTextField, gridBagConstraints);
        this.projectNameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.projectNameTextField.AccessibleContext.accessibleName"));
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.projectNameTextField.AccessibleContext.accessibleDescription"));
        this.projectLocationTextField.setText(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"PanelProjectLocationVisual.projectLocationTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.projectLocationTextField, gridBagConstraints);
        this.projectLocationTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.projectLocationTextField.AccessibleContext.accessibleName"));
        this.projectLocationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.projectLocationTextField.AccessibleContext.accessibleDescription"));
        this.projectFolderTextField.setEditable(false);
        this.projectFolderTextField.setText(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"PanelProjectLocationVisual.projectFolderTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.projectFolderTextField, gridBagConstraints);
        this.projectFolderTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.projectFolderTextField.AccessibleContext.accessibleName"));
        this.projectFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.projectFolderTextField.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseLocationJButton, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"PanelProjectLocationVisual.browseLocationJButton.text"));
        this.browseLocationJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PanelProjectLocationVisual.this.browseLocationJButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.add((Component)this.browseLocationJButton, gridBagConstraints);
        this.browseLocationJButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.browseLocationJButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.AccessibleContext.accessibleDescription"));
    }

    private void browseLocationJButtonActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setDialogTitle(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"GetProjectLocationPanel.FileChooserTitle"));
        jFileChooser.setFileSelectionMode(1);
        String string = this.projectLocationTextField.getText().trim();
        if (string.length() > 0 && (file = new File(string)).exists()) {
            jFileChooser.setSelectedFile(file);
        }
        if (0 == jFileChooser.showOpenDialog(SwingUtilities.getWindowAncestor(this))) {
            file = jFileChooser.getSelectedFile();
            this.projectLocationTextField.setText(file.getAbsolutePath());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
    }

    private void updateTexts(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this.projectNameTextField.getDocument() || document == this.projectLocationTextField.getDocument()) {
            String string = this.projectNameTextField.getText().trim();
            String string2 = this.projectLocationTextField.getText().trim();
            this.getProjectFolderTextField().setText(new File(string2, string).getAbsolutePath());
            this.panel.fireChangeEvent();
        }
    }

    public JTextField getProjectFolderTextField() {
        return this.projectFolderTextField;
    }

    private String validFreeProjectName(File file, String string, int n) {
        String string2 = MessageFormat.format(string, n);
        File file2 = new File(file, string2);
        return file2.exists() ? null : string2;
    }
}

