/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.SourceCategory;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GrailsSources
extends FileChangeAdapter
implements Sources {
    public static final List KNOWN_FOLDERS = Arrays.asList("docs", "grails-app", "lib", "scripts", "src", "test", "web-app");
    public static final List KNOWN_FOLDERS_IN_GRAILS_APP = Arrays.asList("conf", "controllers", "domain", "i18n", "services", "taglib", "utils", "views");
    public static final List KNOWN_OR_IGNORED_FOLDERS_IN_TEST = Arrays.asList("unit", "integration", "reports");
    private final FileObject projectDir;
    private final GrailsProject project;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    private GrailsSources(GrailsProject grailsProject) {
        this.project = grailsProject;
        this.projectDir = grailsProject.getProjectDirectory();
    }

    static GrailsSources create(GrailsProject grailsProject) {
        GrailsSources grailsSources = new GrailsSources(grailsProject);
        grailsSources.startFSListener();
        return grailsSources;
    }

    private void startFSListener() {
        try {
            FileSystem fileSystem = this.projectDir.getFileSystem();
            fileSystem.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)fileSystem));
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
    }

    public SourceGroup[] getSourceGroups(String string) {
        ArrayList<Group> arrayList = new ArrayList<Group>();
        if ("generic".equals(string)) {
            this.addGroup(this.projectDir, this.projectDir.getName(), arrayList);
        } else if ("java".equals(string)) {
            this.addGroup(SourceCategory.SRC_JAVA, "LBL_SrcJava", arrayList);
        } else if ("groovy".equals(string)) {
            this.addGroup(SourceCategory.GRAILSAPP_CONF, "LBL_grails-app_conf", arrayList);
            this.addGroup(SourceCategory.GRAILSAPP_CONTROLLERS, "LBL_grails-app_controllers", arrayList);
            this.addGroup(SourceCategory.GRAILSAPP_DOMAIN, "LBL_grails-app_domain", arrayList);
            this.addGroup(SourceCategory.GRAILSAPP_SERVICES, "LBL_grails-app_services", arrayList);
            this.addGroup(SourceCategory.GRAILSAPP_TAGLIB, "LBL_grails-app_taglib", arrayList);
            this.addGroup(SourceCategory.GRAILSAPP_UTILS, "LBL_grails-app_utils", arrayList);
            this.addGroup(SourceCategory.SCRIPTS, "LBL_scripts", arrayList);
            this.addGroup(SourceCategory.SRC_GROOVY, "LBL_SrcGroovy", arrayList);
            this.addGroup(SourceCategory.TEST_INTEGRATION, "LBL_IntegrationTests", arrayList);
            this.addGroup(SourceCategory.TEST_UNIT, "LBL_UnitTests", arrayList);
        } else if ("grails".equals(string)) {
            this.addGroup(SourceCategory.LIB, "LBL_lib", arrayList);
            this.addGroup(SourceCategory.GRAILSAPP_I18N, "LBL_grails-app_i18n", arrayList);
            this.addGroup(SourceCategory.WEBAPP, "LBL_web-app", arrayList);
            this.addGroup(SourceCategory.GRAILSAPP_VIEWS, "LBL_grails-app_views", arrayList);
        } else if ("grails_unknown".equals(string)) {
            File file = this.project.getBuildConfig().getProjectPluginsDir();
            FileObject fileObject = file == null ? null : FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            File file2 = this.project.getBuildConfig().getGlobalPluginsDir();
            FileObject fileObject2 = file2 == null ? null : FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file2));
            for (FileObject fileObject3 : this.projectDir.getChildren()) {
                if (!fileObject3.isFolder() || !VisibilityQuery.getDefault().isVisible(fileObject3) || KNOWN_FOLDERS.contains(fileObject3.getName()) || fileObject3 == fileObject || fileObject3 == fileObject2) continue;
                String string2 = fileObject3.getName();
                this.addGroup(fileObject3, Character.toUpperCase(string2.charAt(0)) + string2.substring(1), arrayList);
            }
            this.addGroup(SourceCategory.SRC_GWT, "LBL_SrcGwt", arrayList);
            this.addUnknownGroups(KNOWN_FOLDERS_IN_GRAILS_APP, arrayList, "grails-app", null);
            this.addUnknownGroups(KNOWN_OR_IGNORED_FOLDERS_IN_TEST, arrayList, "test", "LBL_SomeTests");
        }
        return arrayList.toArray(new SourceGroup[arrayList.size()]);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.changeSupport.fireChange();
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        this.changeSupport.fireChange();
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.changeSupport.fireChange();
    }

    private void addUnknownGroups(Collection<String> collection, List<Group> list, String string, String string2) {
        FileObject fileObject = this.projectDir.getFileObject(string);
        if (fileObject != null) {
            for (FileObject fileObject2 : fileObject.getChildren()) {
                if (!fileObject2.isFolder() || !VisibilityQuery.getDefault().isVisible(fileObject2) || collection.contains(fileObject2.getName())) continue;
                String string3 = fileObject2.getName();
                String string4 = Character.toUpperCase(string3.charAt(0)) + string3.substring(1);
                if (string2 != null) {
                    string4 = NbBundle.getMessage(GrailsSources.class, (String)string2, (Object)string4);
                }
                this.addGroup(fileObject2, string4, list);
            }
        }
    }

    private void addGroup(FileObject fileObject, String string, List<Group> list) {
        if (fileObject != null) {
            list.add(new Group(fileObject, string));
        }
    }

    private void addGroup(SourceCategory sourceCategory, String string, List<Group> list) {
        FileObject fileObject = this.projectDir.getFileObject(sourceCategory.getRelativePath());
        if (fileObject != null) {
            list.add(new Group(fileObject, NbBundle.getMessage(GrailsSources.class, (String)string)));
        }
    }

    private final class Group
    implements SourceGroup {
        private final FileObject loc;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private final String displayName;

        public Group(FileObject fileObject, String string) {
            this.loc = fileObject;
            this.displayName = string;
        }

        public FileObject getRootFolder() {
            return this.loc;
        }

        public String getName() {
            String string = this.loc.getPath();
            return string.length() > 0 ? string : "generic";
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getIcon(boolean bl) {
            return null;
        }

        public boolean contains(FileObject fileObject) throws IllegalArgumentException {
            if (fileObject == this.loc) {
                return true;
            }
            String string = FileUtil.getRelativePath((FileObject)this.loc, (FileObject)fileObject);
            if (string == null) {
                throw new IllegalArgumentException();
            }
            if (fileObject.isFolder()) {
                string = string + File.separator;
            }
            if (fileObject.isFolder() && fileObject != GrailsSources.this.projectDir && ProjectManager.getDefault().isProject(fileObject)) {
                return false;
            }
            File file = FileUtil.toFile((FileObject)fileObject);
            return file == null || SharabilityQuery.getSharability((File)file) != 2;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }

        public String toString() {
            return "GrailsSources.Group[name=" + this.getName() + ",rootFolder=" + this.getRootFolder() + "]";
        }
    }
}

