/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject;

import java.net.URL;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.groovy.grails.api.ExecutionSupport;
import org.netbeans.modules.groovy.grails.api.GrailsPlatform;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.GrailsServerState;
import org.netbeans.modules.groovy.grailsproject.actions.ConfigurationSupport;
import org.netbeans.modules.groovy.grailsproject.commands.GrailsCommandSupport;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.LifecycleManager;
import org.openide.util.Lookup;

public class GrailsActionProvider
implements ActionProvider {
    public static final String COMMAND_GRAILS_SHELL = "grails-shell";
    public static final String COMMAND_COMPILE = "compile";
    public static final String COMMAND_UPGRADE = "upgrade";
    private static final Logger LOGGER = Logger.getLogger(GrailsActionProvider.class.getName());
    private static final String[] supportedActions = new String[]{"build", "run", "debug", "test", "clean", "delete", "grails-shell", "compile", "upgrade"};
    private final GrailsProject project;

    public GrailsActionProvider(GrailsProject grailsProject) {
        this.project = grailsProject;
    }

    public String[] getSupportedActions() {
        return (String[])supportedActions.clone();
    }

    public void invokeAction(String string, Lookup lookup) throws IllegalArgumentException {
        GrailsPlatform grailsPlatform = GrailsPlatform.getDefault();
        if (!grailsPlatform.isConfigured()) {
            ConfigurationSupport.showConfigurationWarning(grailsPlatform);
            return;
        }
        if ("run".equals(string)) {
            LifecycleManager.getDefault().saveAll();
            this.executeRunAction();
        } else if ("debug".equals(string)) {
            LifecycleManager.getDefault().saveAll();
            this.executeRunAction(true);
        } else if (COMMAND_GRAILS_SHELL.equals(string)) {
            this.executeSimpleAction("shell");
        } else if ("test".equals(string)) {
            this.executeSimpleAction("test-app");
        } else if ("clean".equals(string)) {
            this.executeSimpleAction("clean");
        } else if (COMMAND_COMPILE.equals(string)) {
            this.executeSimpleAction(COMMAND_COMPILE);
        } else if (COMMAND_UPGRADE.equals(string)) {
            this.executeSimpleAction(COMMAND_UPGRADE);
        } else if ("delete".equals(string)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
        } else if ("build".equals(string)) {
            this.executeSimpleAction("war");
        }
    }

    public boolean isActionEnabled(String string, Lookup lookup) throws IllegalArgumentException {
        return true;
    }

    private void executeRunAction() {
        this.executeRunAction(false);
    }

    private void executeRunAction(final boolean bl) {
        GrailsServerState grailsServerState = (GrailsServerState)this.project.getLookup().lookup(GrailsServerState.class);
        Process process = null;
        if (grailsServerState != null && grailsServerState.isRunning()) {
            if (!bl) {
                URL uRL = grailsServerState.getRunningUrl();
                if (uRL != null) {
                    GrailsCommandSupport.showURL(uRL, bl, this.project);
                }
                return;
            }
            process = grailsServerState.getProcess();
            if (process != null) {
                process.destroy();
            }
        }
        final Process process2 = process;
        Callable<Process> callable = new Callable<Process>(){

            @Override
            public Process call() throws Exception {
                if (process2 != null) {
                    process2.waitFor();
                }
                Callable callable = ExecutionSupport.getInstance().createRunApp(GrailsProjectConfig.forProject((Project)GrailsActionProvider.this.project), bl, new String[0]);
                Process process = (Process)callable.call();
                GrailsServerState grailsServerState = (GrailsServerState)GrailsActionProvider.this.project.getLookup().lookup(GrailsServerState.class);
                if (grailsServerState != null) {
                    grailsServerState.setProcess(process);
                    grailsServerState.setDebug(bl);
                }
                return process;
            }
        };
        ProjectInformation projectInformation = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
        String string = projectInformation.getDisplayName() + " (run-app)";
        ExecutionDescriptor executionDescriptor = this.project.getCommandSupport().getRunDescriptor(bl);
        ExecutionService executionService = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)executionDescriptor, (String)string);
        executionService.run();
    }

    private void executeSimpleAction(String string) {
        ProjectInformation projectInformation = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
        String string2 = projectInformation.getDisplayName() + " (" + string + ")";
        Callable callable = ExecutionSupport.getInstance().createSimpleCommand(string, GrailsProjectConfig.forProject((Project)this.project), new String[0]);
        ExecutionDescriptor executionDescriptor = this.project.getCommandSupport().getDescriptor(string);
        ExecutionService executionService = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)executionDescriptor, (String)string2);
        executionService.run();
    }
}

