/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;

public final class HeapProgress {
    public static final int PROGRESS_MAX = 1000;
    private static ThreadLocal progressThreadLocal = new ThreadLocal();

    private HeapProgress() {
    }

    public static BoundedRangeModel getProgress() {
        BoundedRangeModel model = (BoundedRangeModel)progressThreadLocal.get();
        if (model == null) {
            model = new DefaultBoundedRangeModel(0, 0, 0, 1000);
            progressThreadLocal.set(model);
        }
        return model;
    }

    static void progress(long counter, long startOffset, long value, long endOffset) {
        if (counter % 100000L == 0L) {
            HeapProgress.progress(value, endOffset, startOffset);
        }
    }

    static void progress(long value, long endValue) {
        HeapProgress.progress(value, 0L, value, endValue);
    }

    private static void progress(long value, long endOffset, long startOffset) {
        BoundedRangeModel model = (BoundedRangeModel)progressThreadLocal.get();
        if (model != null) {
            long val = 1000L * (value - startOffset) / (endOffset - startOffset);
            model.setValue((int)val);
        }
    }

    static void progressFinish() {
        BoundedRangeModel model = (BoundedRangeModel)progressThreadLocal.get();
        if (model != null) {
            model.setValue(1000);
            progressThreadLocal.remove();
        }
    }
}

